/* 
Gesture Controlled Radio
Nick Ciulla and Michelle Nguyen 

Thanks to Simon Monk for library use.



*/


#include "mbed.h"
#include "SparkFun-Si4703.h"
#include "TextLCD.h"
#include "glibr.h"

Serial pc(USBTX, USBRX);
Si4703_Breakout radio(PTD9, PTD8, PTB11, &pc); // (sda, scl, rst, Serial) PTD9, PTD8, PTB11, &pc); 
DigitalIn chanUp(PTC16);
DigitalIn chanDown(PTC17);
DigitalIn  volUP(PTA12);
DigitalIn volDown(PTA13);
TextLCD lcd(PTE6, PTD15, PTD4, PTD5, PTD6, PTD7); // rs, e, d4-d7
glibr GSensor(PTD9,PTD8); //sda, scl


int main(int argc, char** argv) {
    
    int playlist[3] = {963, 1045, 1033}; //hardcoded stations that work
    int numtot =3; //total number of stations
    int isr_flag = 0;
    int chan = 0;
    int vol = 5;
    radio.powerOn();
    radio.setVolume(vol); // range: 0-15  set to 1-5 for testing ... loud
    radio.setChannel(playlist[chan]);  
   
    
    lcd.cls(); 
    lcd.printf("channel = '%d'", radio.getChannel());  
    lcd.printf(" volume = '%d'\n", radio.getVolume());  
    pc.printf("channel = '%d'", radio.getChannel());  
    pc.printf(" volume = '%d'\n", radio.getVolume());  
 
    if ( GSensor.ginit() ) {
        pc.printf("APDS-9960 initialization complete\r\n");
    } else {
        pc.printf("Something went wrong during APDS-9960 init\r\n");
        return -1;
    }

    // Start running the APDS-9960 gesture sensor engine
    if ( GSensor.enableGestureSensor(true) ) {
        pc.printf("Gesture sensor is now running\r\n");
    } else {
        pc.printf("Something went wrong during gesture sensor init!\r\n");
        return -1;
    }
    while(1){

   if ( GSensor.isGestureAvailable() ) {         // gesture detect
            switch ( GSensor.readGesture() ) {        // gesture differentiate
                case DIR_UP:
                 
                 
                 chan++;
                 if (chan == (numtot))  //works like a normal radio ... will loop
                {
                    chan = 0;
                     pc.printf("Back to the start!\r\n");
                    }
               
            radio.setChannel(playlist[chan%numtot]);
            lcd.cls();
            lcd.printf("channel = '%d'", radio.getChannel());  
            lcd.printf(" volume = '%d'\n", radio.getVolume());  
            pc.printf("channel = '%d'", radio.getChannel());  
            pc.printf(" volume = '%d'\n", radio.getVolume());  
            
                    pc.printf("UP\r\n");
                    break;
                case DIR_DOWN:
                if (chan ==0)
                {
                    chan = numtot;
                     pc.printf("Around to the top!\r\n");
                    }
                    
                chan--;
                
          radio.setChannel(playlist[chan%numtot]);
           lcd.cls();
           lcd.printf("channel = '%d'", radio.getChannel());  
          lcd.printf(" volume = '%d'\n", radio.getVolume());  
          pc.printf("channel = '%d'", radio.getChannel());  
           pc.printf(" volume = '%d'\n", radio.getVolume());  
          
                    pc.printf("DOWN\r\n");
                    break;
                case DIR_LEFT:
                vol++;
            radio.setVolume(vol);
            lcd.cls();
            lcd.printf("channel = '%d'", radio.getChannel());  
            lcd.printf(" volume = '%d'\n", radio.getVolume());  
            pc.printf("channel = '%d'", radio.getChannel());  
            pc.printf(" volume = '%d'\n", radio.getVolume());  
          
                    pc.printf("LEFT\r\n");
                    break;
                case DIR_RIGHT:
                  vol--;
            radio.setVolume(vol);
            lcd.cls();
            lcd.printf("channel = '%d'", radio.getChannel());  
            lcd.printf(" volume = '%d'\n", radio.getVolume());  
            pc.printf("channel = '%d'", radio.getChannel());  
            pc.printf(" volume = '%d'\n", radio.getVolume());  
            
                    pc.printf("RIGHT\r\n");
                    break;
                case DIR_NEAR:
                    pc.printf("NEAR\r\n");
                    break;
                case DIR_FAR:
                    pc.printf("FAR\r\n");
                    break;
                default:
                    pc.printf("NONE\r\n");
                    break;
            }

        }

    }
}