#include "mbed.h"
#include "math.h"

#define SAMPLE_LENGTH       2000 
#define NUM_TAPS            513
#define CARRIER_FREQ        220
#define TIME_CONST          0.0001
#define PI                  3.14159265

bool decimate = false;

float firCoeffs[NUM_TAPS] = {-0.0144708808511496,-0.000385188817745075,-0.000390533183235675,-0.000394742906792089,-0.000399769196519628,-0.000403738202294335,-0.000408404623158276,-0.000412113149650395,-0.000416462833527476,-0.000419815012719482,-0.000423797959228978,-0.000426739337854087,-0.000430334330303594,-0.000432832690421492,-0.000436010304838419,-0.000438015762483701,-0.000440725998487324,-0.000442176271462813,-0.000444366451120004,-0.000445200741523877,-0.000446824764367193,-0.000446985068265349,-0.000448006554506719,-0.000447442784206942,-0.000447849219199270,-0.000446533842477948,-0.000446356250904501,-0.000444298930233344,-0.000443635712144896,-0.000440904172137380,-0.000439959781942889,-0.000436697184341028,-0.000435806956375018,-0.000432172615546733,-0.000431753345765173,-0.000427687598858029,-0.000428156810812652,-0.000422747252741829,-0.000424187630414963,-0.000407818792155013,-0.000395501352613792,-0.000405744503950700,-0.000392851507058367,-0.000390382687328383,-0.000381121528334916,-0.000376496114768088,-0.000367538945283741,-0.000361525919288397,-0.000352310773450881,-0.000345231412211433,-0.000335566815920174,-0.000327541463775560,-0.000317294849082828,-0.000308353744912893,-0.000297429505735636,-0.000287581380689517,-0.000275914761004970,-0.000265156646491960,-0.000252692261710763,-0.000241008558077738,-0.000227700089453720,-0.000215083331568167,-0.000200913782464340,-0.000187389392522164,-0.000172384694451466,-0.000158020178787410,-0.000142244665767066,-0.000127136823721230,-0.000110658475023229,-9.48790548136458e-05,-7.76831002440304e-05,-6.11819123150781e-05,-4.30660620622803e-05,-2.56168041232741e-05,-6.17332989349961e-06,1.25088872664492e-05,3.37927012878936e-05,5.35608705831692e-05,7.59589602239430e-05,9.15368291316554e-05,0.000115204777102917,0.000138069211971015,0.000159190880367532,0.000182373449206352,0.000205067466595210,0.000228860953939147,0.000252562953392044,0.000277043582173064,0.000301679014228284,0.000326937646605074,0.000352496019331738,0.000378568482119590,0.000405024475185201,0.000431919761467725,0.000459260045317933,0.000486996257677674,0.000515223422553390,0.000543812348041683,0.000572911638300866,0.000602328160312027,0.000632248178590089,0.000662431004457176,0.000693100970238447,0.000723983335774392,0.000755351502448320,0.000786905176937580,0.000818981905467808,0.000851254211738706,0.000884129083715379,0.000917225959710777,0.000951002817600966,0.000984976999461651,0.00101962720509619,0.00105433282442391,0.00108958012424409,0.00112464418634772,0.00115993840154260,0.00119539198931307,0.00123186816927046,0.00127036077901721,0.00130541180260479,0.00134335225448012,0.00138072879053652,0.00141863315366209,0.00145663029979914,0.00149499706458300,0.00153361610136926,0.00157251046039164,0.00161168223712593,0.00165107252541929,0.00169074663426727,0.00173062458634377,0.00177079136483371,0.00181115593295544,0.00185179221443832,0.00189260160550475,0.00193364149890840,0.00197481806389987,0.00201618182472885,0.00205765641294420,0.00209929421544075,0.00214104214683175,0.00218295189552009,0.00222499505616725,0.00226720655336976,0.00230957893654704,0.00235209893435240,0.00239478098228574,0.00243752682581544,0.00248040445148945,0.00252320826984942,0.00256614456884563,0.00260887923650444,0.00265189493075013,0.00269464123994112,0.00273811141960323,0.00278127146884799,0.00282487273216248,0.00286725582554936,0.00291011668741703,0.00295400852337480,0.00299631315283477,0.00303968228399754,0.00308228214271367,0.00312544335611165,0.00316800503060222,0.00321092060767114,0.00325335212983191,0.00329604768194258,0.00333833065815270,0.00338080571964383,0.00342287984676659,0.00346506666392088,0.00350683252327144,0.00354864820837975,0.00359002966433764,0.00363143184222281,0.00367240631021559,0.00371339474804699,0.00375396921299398,0.00379455066286027,0.00383471907116473,0.00387486722320318,0.00391457835212350,0.00395421450957656,0.00399336963891983,0.00403239345178008,0.00407090689986944,0.00410927413031459,0.00414714356884360,0.00418491195887327,0.00422220071777701,0.00425944291055203,0.00429609837010503,0.00433271517977119,0.00436816038563848,0.00440392829477787,0.00443863216787577,0.00447419332340360,0.00450790720060468,0.00454199779778719,0.00457557942718267,0.00460866745561361,0.00464128935709596,0.00467348005622625,0.00470521813258529,0.00473655480891466,0.00476738158613443,0.00479778554290533,0.00482760230079293,0.00485697947442532,0.00488572614267468,0.00491404812783003,0.00494172982871532,0.00496901245787740,0.00499565014615655,0.00502189761027694,0.00504747871309519,0.00507265469059348,0.00509712658822537,0.00512116774916649,0.00514446385204792,0.00516731571406126,0.00518939504399896,0.00521104829385877,0.00523192156106234,0.00525241391733289,0.00527210766449571,0.00529145309701562,0.00530992168933153,0.00532803731039166,0.00534513592720032,0.00536190019920468,0.00537753105163574,0.00539305759593844,0.00540779717266560,0.00542178330942988,0.00543520553037524,0.00544764194637537,0.00546016823500395,0.00547122210264206,0.00548202730715275,0.00549201155081391,0.00550147471949458,0.00551019050180912,0.00551821896806359,0.00552552472800016,0.00553208775818348,0.00553797790780664,0.00554313324391842,0.00554766040295363,0.00555146159604192,0.00555464252829552,0.00555708399042487,0.00555888703092933,0.00555992824956775,0.00556031381711364,0.00555992824956775,0.00555888703092933,0.00555708399042487,0.00555464252829552,0.00555146159604192,0.00554766040295363,0.00554313324391842,0.00553797790780664,0.00553208775818348,0.00552552472800016,0.00551821896806359,0.00551019050180912,0.00550147471949458,0.00549201155081391,0.00548202730715275,0.00547122210264206,0.00546016823500395,0.00544764194637537,0.00543520553037524,0.00542178330942988,0.00540779717266560,0.00539305759593844,0.00537753105163574,0.00536190019920468,0.00534513592720032,0.00532803731039166,0.00530992168933153,0.00529145309701562,0.00527210766449571,0.00525241391733289,0.00523192156106234,0.00521104829385877,0.00518939504399896,0.00516731571406126,0.00514446385204792,0.00512116774916649,0.00509712658822537,0.00507265469059348,0.00504747871309519,0.00502189761027694,0.00499565014615655,0.00496901245787740,0.00494172982871532,0.00491404812783003,0.00488572614267468,0.00485697947442532,0.00482760230079293,0.00479778554290533,0.00476738158613443,0.00473655480891466,0.00470521813258529,0.00467348005622625,0.00464128935709596,0.00460866745561361,0.00457557942718267,0.00454199779778719,0.00450790720060468,0.00447419332340360,0.00443863216787577,0.00440392829477787,0.00436816038563848,0.00433271517977119,0.00429609837010503,0.00425944291055203,0.00422220071777701,0.00418491195887327,0.00414714356884360,0.00410927413031459,0.00407090689986944,0.00403239345178008,0.00399336963891983,0.00395421450957656,0.00391457835212350,0.00387486722320318,0.00383471907116473,0.00379455066286027,0.00375396921299398,0.00371339474804699,0.00367240631021559,0.00363143184222281,0.00359002966433764,0.00354864820837975,0.00350683252327144,0.00346506666392088,0.00342287984676659,0.00338080571964383,0.00333833065815270,0.00329604768194258,0.00325335212983191,0.00321092060767114,0.00316800503060222,0.00312544335611165,0.00308228214271367,0.00303968228399754,0.00299631315283477,0.00295400852337480,0.00291011668741703,0.00286725582554936,0.00282487273216248,0.00278127146884799,0.00273811141960323,0.00269464123994112,0.00265189493075013,0.00260887923650444,0.00256614456884563,0.00252320826984942,0.00248040445148945,0.00243752682581544,0.00239478098228574,0.00235209893435240,0.00230957893654704,0.00226720655336976,0.00222499505616725,0.00218295189552009,0.00214104214683175,0.00209929421544075,0.00205765641294420,0.00201618182472885,0.00197481806389987,0.00193364149890840,0.00189260160550475,0.00185179221443832,0.00181115593295544,0.00177079136483371,0.00173062458634377,0.00169074663426727,0.00165107252541929,0.00161168223712593,0.00157251046039164,0.00153361610136926,0.00149499706458300,0.00145663029979914,0.00141863315366209,0.00138072879053652,0.00134335225448012,0.00130541180260479,0.00127036077901721,0.00123186816927046,0.00119539198931307,0.00115993840154260,0.00112464418634772,0.00108958012424409,0.00105433282442391,0.00101962720509619,0.000984976999461651,0.000951002817600966,0.000917225959710777,0.000884129083715379,0.000851254211738706,0.000818981905467808,0.000786905176937580,0.000755351502448320,0.000723983335774392,0.000693100970238447,0.000662431004457176,0.000632248178590089,0.000602328160312027,0.000572911638300866,0.000543812348041683,0.000515223422553390,0.000486996257677674,0.000459260045317933,0.000431919761467725,0.000405024475185201,0.000378568482119590,0.000352496019331738,0.000326937646605074,0.000301679014228284,0.000277043582173064,0.000252562953392044,0.000228860953939147,0.000205067466595210,0.000182373449206352,0.000159190880367532,0.000138069211971015,0.000115204777102917,9.15368291316554e-05,7.59589602239430e-05,5.35608705831692e-05,3.37927012878936e-05,1.25088872664492e-05,-6.17332989349961e-06,-2.56168041232741e-05,-4.30660620622803e-05,-6.11819123150781e-05,-7.76831002440304e-05,-9.48790548136458e-05,-0.000110658475023229,-0.000127136823721230,-0.000142244665767066,-0.000158020178787410,-0.000172384694451466,-0.000187389392522164,-0.000200913782464340,-0.000215083331568167,-0.000227700089453720,-0.000241008558077738,-0.000252692261710763,-0.000265156646491960,-0.000275914761004970,-0.000287581380689517,-0.000297429505735636,-0.000308353744912893,-0.000317294849082828,-0.000327541463775560,-0.000335566815920174,-0.000345231412211433,-0.000352310773450881,-0.000361525919288397,-0.000367538945283741,-0.000376496114768088,-0.000381121528334916,-0.000390382687328383,-0.000392851507058367,-0.000405744503950700,-0.000395501352613792,-0.000407818792155013,-0.000424187630414963,-0.000422747252741829,-0.000428156810812652,-0.000427687598858029,-0.000431753345765173,-0.000432172615546733,-0.000435806956375018,-0.000436697184341028,-0.000439959781942889,-0.000440904172137380,-0.000443635712144896,-0.000444298930233344,-0.000446356250904501,-0.000446533842477948,-0.000447849219199270,-0.000447442784206942,-0.000448006554506719,-0.000446985068265349,-0.000446824764367193,-0.000445200741523877,-0.000444366451120004,-0.000442176271462813,-0.000440725998487324,-0.000438015762483701,-0.000436010304838419,-0.000432832690421492,-0.000430334330303594,-0.000426739337854087,-0.000423797959228978,-0.000419815012719482,-0.000416462833527476,-0.000412113149650395,-0.000408404623158276,-0.000403738202294335,-0.000399769196519628,-0.000394742906792089,-0.000390533183235675,-0.000385188817745075,-0.0144708808511496};

float decimatedFIR[NUM_TAPS] = {
    -0.00140781220330616, -0.000139680243382954, -0.000146404247129533, -0.000153380260487868, -0.000160358054902775, -0.000167594998778230, -0.000174826685798307, -0.000182327525649789, -0.000189824946371562, -0.000197598785182405, -0.000205384397733665, -0.000213427887696411, -0.000221470958675043, -0.000229772807811465, -0.000238049618312475, -0.000246567591545414, -0.000255034938034355, -0.000263721934820429, -0.000272321168079272, -0.000281131948836483, -0.000289843221436450, -0.000298765562188730, -0.000307585101529890, -0.000316650955348761, -0.000325618969853878, -0.000334855342718481, -0.000343975936992935, -0.000353357974172664, -0.000362544634184449, -0.000371941004210931, -0.000381024111936636, -0.000390255657684682, -0.000399088156676523, -0.000408207165488917, -0.000417020789208928, -0.000426496295026695, -0.000435648489505876, -0.000445439550183399, -0.000453172230024789, -0.000461660268788097, -0.000471635316163514, -0.000479499372082719, -0.000488476288769188, -0.000496672136936235, -0.000505189086295845, -0.000513218974024207, -0.000521360025966030, -0.000529114793277384, -0.000536854478912505, -0.000544249696796157, -0.000551583323282700, -0.000558584824336864, -0.000565477747623975, -0.000572054035563717, -0.000578468965223928, -0.000584552174690912, -0.000590425893175921, -0.000595949081082807, -0.000601200253942484, -0.000606082637475742, -0.000610668920187883, -0.000614882217079890, -0.000618778259830580, -0.000622308694572542, -0.000625497626837207, -0.000628297254986301, -0.000630695498825983, -0.000632650443402028, -0.000634130868631187, -0.000635164264832922, -0.000635761026451823, -0.000635967181300185, -0.000635724143226076, -0.000635003078358038, -0.000633597273946612, -0.000631631482873466, -0.000629134411213307, -0.000626603803355716, -0.000622782505082791, -0.000618727770214896, -0.000614148178145395, -0.000608790885954232, -0.000602983809420617, -0.000596430516098165, -0.000589338175725318, -0.000581501779768414, -0.000573069125627472, -0.000563911455667894, -0.000554101021810418, -0.000543559747075306, -0.000532354016357830, -0.000520395055447092, -0.000507745859224283, -0.000494335043762342, -0.000480203234628012, -0.000465276778512382, -0.000449606833404642, -0.000433138840464187, -0.000415906028795478, -0.000397866600246355, -0.000379060346696341, -0.000359436786270860, -0.000339015894938986, -0.000317740699425894, -0.000295627067522847, -0.000272641014736395, -0.000248836401356591, -0.000224199400086325, -0.000198742160896760, -0.000172407601775126, -0.000145190671156311, -0.000117045347359629, -8.80751272068533e-05, -5.82740696285398e-05, -2.76411999534569e-05, 4.04401613033564e-06, 3.65984391749181e-05, 6.98079135743859e-05, 0.000104194913744367, 0.000139265001871243, 0.000175323843452667, 0.000212225660414214, 0.000250041672541152, 0.000288731639017152, 0.000328303067272255, 0.000368768031558810, 0.000410107369479582, 0.000452307466383416, 0.000495395175265087, 0.000539331552961722, 0.000584135271449011, 0.000629794805723046, 0.000676324434358735, 0.000723692579251588, 0.000771907381438338, 0.000820953090117775, 0.000870821511917016, 0.000921484852485368, 0.000972954215880515, 0.00102521798364415, 0.00107828503717442, 0.00113213502585819, 0.00118675164943918, 0.00124209904820303, 0.00129817383913273, 0.00135497990267232, 0.00141251944417704, 0.00147077043048314, 0.00152970713186801, 0.00158928340180831, 0.00164949846708349, 0.00171039657639008, 0.00177194862277590, 0.00183409607086238, 0.00189672745561680, 0.00196007035416052, 0.00202391903684120, 0.00208824391132099, 0.00215319633049186, 0.00221854583847226, 0.00228445797865602, 0.00235076297219949, 0.00241756988507026, 0.00248475343989325, 0.00255234987121874, 0.00262031356572019, 0.00268863560479671, 0.00275726089169212, 0.00282622747425243, 0.00289545679576046, 0.00296496495561586, 0.00303468793848164, 0.00310465029422548, 0.00317476753523368, 0.00324505506219278, 0.00331546217344017, 0.00338601015522827, 0.00345663256658588, 0.00352733575600996, 0.00359804284729557, 0.00366876468102628, 0.00373945014055407, 0.00381012169646394, 0.00388070876734894, 0.00395120444528220, 0.00402154279639318, 0.00409173171254159, 0.00416173124721950, 0.00423156818582252, 0.00430114706446985, 0.00437044863608342, 0.00443943048745045, 0.00450815205643151, 0.00457651665688236, 0.00464443753488891, 0.00471204573900059, 0.00477916483350526, 0.00484583308784604, 0.00491204135096321, 0.00497770104244254, 0.00504286516134843, 0.00510739858102646, 0.00517139743734042, 0.00523472192447666, 0.00529741817506733, 0.00535943867085980, 0.00542076991779664, 0.00548134825113098, 0.00554120085527070, 0.00560025408386779, 0.00565850878091468, 0.00571590115366314, 0.00577247133665566, 0.00582814600600365, 0.00588293478428767, 0.00593676502246772, 0.00598965488930740, 0.00604154696810768, 0.00609247220464676, 0.00614236085714198, 0.00619121945304127, 0.00623897597939753, 0.00628566236877679, 0.00633122339801930, 0.00637568755846381, 0.00641898891954461, 0.00646112437618597, 0.00650203246575002, 0.00654176987317808, 0.00658027498541388, 0.00661755068828877, 0.00665350784741265, 0.00668825437518407, 0.00672167727481079, 0.00675377453504693, 0.00678459858417483, 0.00681404651496248, 0.00684217008450498, 0.00686891180782161, 0.00689428165948642, 0.00691827851213634, 0.00694083019733330, 0.00696204422560743, 0.00698178676368780, 0.00700012584755218, 0.00701702448731868, 0.00703249360499076, 0.00704647619369649, 0.00705902447003037, 0.00707010915038278, 0.00707974715357706, 0.00708787974661498, 0.00709455322702824, 0.00709972877882829, 0.00710345327398210, 0.00710568171010634, 0.00710644118250910, 0.00710568171010634, 0.00710345327398210, 0.00709972877882829, 0.00709455322702824, 0.00708787974661498, 0.00707974715357706, 0.00707010915038278, 0.00705902447003037, 0.00704647619369649, 0.00703249360499076, 0.00701702448731868, 0.00700012584755218, 0.00698178676368780, 0.00696204422560743, 0.00694083019733330, 0.00691827851213634, 0.00689428165948642, 0.00686891180782161, 0.00684217008450498, 0.00681404651496248, 0.00678459858417483, 0.00675377453504693, 0.00672167727481079, 0.00668825437518407, 0.00665350784741265, 0.00661755068828877, 0.00658027498541388, 0.00654176987317808, 0.00650203246575002, 0.00646112437618597, 0.00641898891954461, 0.00637568755846381, 0.00633122339801930, 0.00628566236877679, 0.00623897597939753, 0.00619121945304127, 0.00614236085714198, 0.00609247220464676, 0.00604154696810768, 0.00598965488930740, 0.00593676502246772, 0.00588293478428767, 0.00582814600600365, 0.00577247133665566, 0.00571590115366314, 0.00565850878091468, 0.00560025408386779, 0.00554120085527070, 0.00548134825113098, 0.00542076991779664, 0.00535943867085980, 0.00529741817506733, 0.00523472192447666, 0.00517139743734042, 0.00510739858102646, 0.00504286516134843, 0.00497770104244254, 0.00491204135096321, 0.00484583308784604, 0.00477916483350526, 0.00471204573900059, 0.00464443753488891, 0.00457651665688236, 0.00450815205643151, 0.00443943048745045, 0.00437044863608342, 0.00430114706446985, 0.00423156818582252, 0.00416173124721950, 0.00409173171254159, 0.00402154279639318, 0.00395120444528220, 0.00388070876734894, 0.00381012169646394, 0.00373945014055407, 0.00366876468102628, 0.00359804284729557, 0.00352733575600996, 0.00345663256658588, 0.00338601015522827, 0.00331546217344017, 0.00324505506219278, 0.00317476753523368, 0.00310465029422548, 0.00303468793848164, 0.00296496495561586, 0.00289545679576046, 0.00282622747425243, 0.00275726089169212, 0.00268863560479671, 0.00262031356572019, 0.00255234987121874, 0.00248475343989325, 0.00241756988507026, 0.00235076297219949, 0.00228445797865602, 0.00221854583847226, 0.00215319633049186, 0.00208824391132099, 0.00202391903684120, 0.00196007035416052, 0.00189672745561680, 0.00183409607086238, 0.00177194862277590, 0.00171039657639008, 0.00164949846708349, 0.00158928340180831, 0.00152970713186801, 0.00147077043048314, 0.00141251944417704, 0.00135497990267232, 0.00129817383913273, 0.00124209904820303, 0.00118675164943918, 0.00113213502585819, 0.00107828503717442, 0.00102521798364415, 0.000972954215880515, 0.000921484852485368, 0.000870821511917016, 0.000820953090117775, 0.000771907381438338, 0.000723692579251588, 0.000676324434358735, 0.000629794805723046, 0.000584135271449011, 0.000539331552961722, 0.000495395175265087, 0.000452307466383416, 0.000410107369479582, 0.000368768031558810, 0.000328303067272255, 0.000288731639017152, 0.000250041672541152, 0.000212225660414214, 0.000175323843452667, 0.000139265001871243, 0.000104194913744367, 6.98079135743859e-05, 3.65984391749181e-05, 4.04401613033564e-06, -2.76411999534569e-05, -5.82740696285398e-05, -8.80751272068533e-05, -0.000117045347359629, -0.000145190671156311, -0.000172407601775126, -0.000198742160896760, -0.000224199400086325, -0.000248836401356591, -0.000272641014736395, -0.000295627067522847, -0.000317740699425894, -0.000339015894938986, -0.000359436786270860, -0.000379060346696341, -0.000397866600246355, -0.000415906028795478, -0.000433138840464187, -0.000449606833404642, -0.000465276778512382, -0.000480203234628012, -0.000494335043762342, -0.000507745859224283, -0.000520395055447092, -0.000532354016357830, -0.000543559747075306, -0.000554101021810418, -0.000563911455667894, -0.000573069125627472, -0.000581501779768414, -0.000589338175725318, -0.000596430516098165, -0.000602983809420617, -0.000608790885954232, -0.000614148178145395, -0.000618727770214896, -0.000622782505082791, -0.000626603803355716, -0.000629134411213307, -0.000631631482873466, -0.000633597273946612, -0.000635003078358038, -0.000635724143226076, -0.000635967181300185, -0.000635761026451823, -0.000635164264832922, -0.000634130868631187, -0.000632650443402028, -0.000630695498825983, -0.000628297254986301, -0.000625497626837207, -0.000622308694572542, -0.000618778259830580, -0.000614882217079890, -0.000610668920187883, -0.000606082637475742, -0.000601200253942484, -0.000595949081082807, -0.000590425893175921, -0.000584552174690912, -0.000578468965223928, -0.000572054035563717, -0.000565477747623975, -0.000558584824336864, -0.000551583323282700, -0.000544249696796157, -0.000536854478912505, -0.000529114793277384, -0.000521360025966030, -0.000513218974024207, -0.000505189086295845, -0.000496672136936235, -0.000488476288769188, -0.000479499372082719, -0.000471635316163514, -0.000461660268788097, -0.000453172230024789, -0.000445439550183399, -0.000435648489505876, -0.000426496295026695, -0.000417020789208928, -0.000408207165488917, -0.000399088156676523, -0.000390255657684682, -0.000381024111936636, -0.000371941004210931, -0.000362544634184449, -0.000353357974172664, -0.000343975936992935, -0.000334855342718481, -0.000325618969853878, -0.000316650955348761, -0.000307585101529890, -0.000298765562188730, -0.000289843221436450, -0.000281131948836483, -0.000272321168079272, -0.000263721934820429, -0.000255034938034355, -0.000246567591545414, -0.000238049618312475, -0.000229772807811465, -0.000221470958675043, -0.000213427887696411, -0.000205384397733665, -0.000197598785182405, -0.000189824946371562, -0.000182327525649789, -0.000174826685798307, -0.000167594998778230, -0.000160358054902775, -0.000153380260487868, -0.000146404247129533, -0.000139680243382954, -0.00140781220330616
    };

void print_array_serial(float *bar,int length, Serial *pc){
    int i =0;
    for(i = 0; i < length; i++){
        pc->printf("%f, ", bar[i]);
    }
}

void filter( float *in, Serial *pc)
{
    float *taps = firCoeffs;
    int i, j;
    float out[SAMPLE_LENGTH] = {};
    
    for( i = NUM_TAPS; i < SAMPLE_LENGTH; i++ )
    {
        out[ i ] = 0.0;
        for( j = 0; j < NUM_TAPS; j++ ){
            if(i-j >= 0)
                out[ i ] += in[ i - j ] * taps[ j ];
        }
    }
    //print_array_serial(out, SAMPLE_LENGTH, pc);
    for( i = 0; i < SAMPLE_LENGTH; i++ )
    {
        in[ i ] = out[i];
    }
}

//=------------------------------------------ DSP END ------------------------------------------------------------------------------

//-------------------------------------uiu----- QAM ------------------------------------------------------------------------------------

float avg_QAM(float *sI, float *sQ, int length){
    int i = 0;
    float total = 0;
    int denom = length - 2*NUM_TAPS;
    for(i = NUM_TAPS; i < length - NUM_TAPS; i++){
        total = total + sqrt(sI[i]*sI[i] + sQ[i]*sQ[i]);
    }   
    return total/denom;
}

float qam_in(float *sI, float *sQ, Serial *pc){
    filter(sI, pc);
    filter(sQ, pc);
    return avg_QAM(sI, sQ, SAMPLE_LENGTH);
}

//------------------------------------------- QAM END ------------------------------------------------------------------------------

