#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"

//Objects
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
DigitalIn pb_L(p21);        //left pb
DigitalIn pb_R(p29);        //right pb
DigitalIn pb_D(p25);        //down pb



/////////////////////////////////////////////////////////////////////SHAPES////////////////////////////////////////////////////
// Square Shape
struct Rect{
    int x1,y1,x2,y2;    // rectangle positions
    float fx1 , fy1, fx2, fy2, vx, vy; // change in positions and rate of change
};

int mat[18][10]={};
int y,x;
int col;
void arrayclear(){
    for(x=0;x<10;x++)
        {
            for (y=0;y<18;y++)
                mat[x][y]=0;
        }    
        }
// L Shape = 2 piece rectangle
struct L{
    int x1, y1, x2, y2;     //first piece of L
    int x3, y3, x4, y4;     //second piece of L
    float fx1, fy1, fx2, fy2, fx3, fy3, fx4, fy4;
    float vx, vy; 
};
    
// Z Shape = 3 piece rectangle
struct Z{
    int x1, y1, x2, y2;     //first piece of Z
    int x3, y3, x4, y4;     //second piece of Z
    int x5, y5, x6, y6;     //third piece of Z
    float fx1, fy1, fx2, fy2, fx3, fy3, fx4, fy4, fx5, fy5, fx6, fy6;
    float vx, vy;
};
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//void drawShapes(int shape);
//void test();
void matrixread()
{
    int i,j;
    for(i=0;i<10;i++)
        {
            for (j=0;j<18;j++)
                if (mat[j][i]==1)
                    {
                        uLCD.filled_rectangle(i*7, j*7, i*7+6, j*7+6, BLUE);
                    }
                else if (mat[j][i]==2)
                    {
                        uLCD.filled_rectangle(i*7, j*7, i*7+6, j*7+6, BLACK);
                    }    
        }    
}
void bottomrowdelete()
{
    int count1,hot,coding;
    for(count1=0;count1<10;count1++)
    {
        mat[17][count1]=2;
    }
    int f,u;

    matrixread();
        for(f=0;f<10;f++)
        {
            for (u=0;u<17;u++)
            {
                if(mat[u][f]==1)
                {
                    mat[u][f]=2;
                    mat[u+1][f]=1;   
                }
            }
        }
}
void checkbottom()
{   
    int count;
    int check;
    check=1;
    for(count=0;count<10;count++)
    {
        if(mat[17][count]!=1)
            check=0;
    }
    if(check==1)
        bottomrowdelete();
}
void start()
{   
    col=5;
    mat[0][col]=1  ;
    checkbottom();
}


void updatePos(Rect s)
{
        //update square position
        s.fx1 += s.vx;
        s.fx2 += s.vx;
        s.fy1 += s.vy;
        s.fy2 += s.vy;
        s.x1 = (int)s.fx1;
        s.x2 = (int)s.fx2;
        s.y1 = (int)s.fy1;
        s.y2 = (int)s.fy2;
}
        
Rect s = { 60, 10, 75, 25, 60.0, 10.0, 75.0, 25.0, 0.0, 0.05};        

int main()
{   
    
    arrayclear();
    
    //set inputs to pullup
    pb_L.mode(PullUp);
    pb_R.mode(PullUp);
    pb_D.mode(PullUp);

    //set up backgrd
    uLCD.baudrate(3000000); 
    uLCD.background_color(BLACK);
    uLCD.cls();
    int qi,nick,quack,stop;
    qi=0;
    while(1)
    {
        if(stop==1)
        {
            qi=0;
            stop=0;
            start();
        }
        if(!pb_R && pb_L ) 
        {
            mat[qi][col]=2;
            col--;
            mat[qi][col]=1;
        }
        else if(!pb_L && pb_R) 
        {
            mat[qi][col]=2;
            col++;
            mat[qi][col]=1;
        }
        else
        {
            mat[qi][col]=2;
            qi++;
            mat[qi][col]=1;
        }
        if(qi==17||mat[qi+1][col]==1) stop=1;
        matrixread();
    }

}

