// snake made for mbed application board
#include "mbed.h"
#include "C12832_lcd.h"
 
#define UP 1
#define DOWN 2
#define LEFT 4
#define RIGHT 8
 
C12832_LCD lcd;

BusIn joystick(p15,p12,p13,p16); //up, down , left, right


//globals
int ver[50];
int hor[50];
int tail =1; 
int coinHor =200; //coin x,y coordinates
int coinVer =200;
int ranC = 12; //used for random spwan point
int ranL = 52; //used for random spawn point
int direction= RIGHT;

//function prototypes
void display(int a);
void control();
void coin();

int main()
{
         hor[0]= 0;
         ver[0] = 1;
         for (int p = 49; p > 0 ; p--){
       hor[p]= 200;
       ver[p] = 200;
       }//end of for
        coin();
        while(1){
        lcd.cls();
        control();
        for (int n=0; n<tail; n++){
        display(n);
        }
           wait(0.1);
        }
}//end of main


void display(int a)
{
    //display box
    lcd.fillrect(hor[a],ver[a],hor[a]+2,ver[a]+2,1);
    //display coin
    lcd.fillrect(coinHor,coinVer,coinHor+2,coinVer+2,1);
    //check if maximum tail length reached
        if (tail>49){ lcd.locate(40,16);
    lcd.printf("YOU WIN!");
    while(1){}}
    

}//end void display


void control(){
    //shift boxes position in array
   for (int p = 49; p > 0 ; p--){
       hor[p]= hor [p-1];
       ver[p] = ver [p-1];
       }//end of for
       
       //moves the main box depending on direction
        switch (direction){
        case RIGHT: if (hor[0]<123){hor[0]+=5;}else{hor[0]=0;}ranC +=2; ranL +=3; break;
        case LEFT: if (hor[0]>0){hor[0]-=5;}else{hor[0]=123;}ranC +=3; ranL +=5; break;
        case UP: if (ver[0]>0){ver[0]-=5;}else{ver[0]=25;}ranC +=8; ranL +=2; break;
        case DOWN: if (ver[0]<25){ver[0]+=5;}else{ver[0]=0;}ranC +=5; ranL +=9; break;
            }//end of switch
    //change direction if statements
    if (joystick == UP)
    {if (direction !=DOWN){
      direction = UP;
      }

    }//end of if UP
    
    if (joystick == DOWN)
    {
      if (direction !=UP){
      direction = DOWN;}
      
    }//end of if DOWN
    
     if (joystick == LEFT)
    {
      if (direction !=RIGHT){
      direction = LEFT;}

    }//end of if LEFT
    
     if (joystick == RIGHT)
    {
      if (direction !=LEFT){
      direction = RIGHT;}

    }//end of if RIGHT

    //checks if first box hits any other box
     for (int p = tail; p > 3 ; p--){
         if( hor[0]==hor[p] && ver[0] == ver[p]){
             lcd.locate(40,10);
            lcd.printf("YOU LOSE!");
            lcd.locate(40,20);
            lcd.printf("Score: %d",tail);
                while(1){}
                }//end of if
             }//end of for

   
    //check if first box hits coin, adds tail and moves coin
    if (coinHor+5>hor[0] && hor[0]>coinHor-5 && coinVer+5>ver[0] && ver[0] >coinVer-5){
        tail++;
        coin();
    }
    }//end of button pressed
    

void coin() {
    //changes location of coin
    coinVer =  ranC % 25;
    coinHor =  ranL % 123;
    
}//end void coin