/****************************************************************************************
* Date Created: 2/26/2010
* Title: NBitWonder Binary Counter Code Example
* Description: A binary adder implemented using the mbed embedded development platform.
*       This program utilizes the mbed's 4 onboard leds to represent the value of a 4-bit
*       binary variable. The variable begins at 0 and is incremented once every second.
* Author: George Hadley
* Website: http://nbitwonder.com
****************************************************************************************/
#include "mbed.h"

//LED Output initializations
BusOut Bits(LED1,LED2,LED3,LED4); //LED outputs for counter

char bin_val = 0x00;
int main() {
    while(1) {
        //increment bin_val, resetting if 4-bit overflow condition occurs
        bin_val++;
        if(bin_val > 0x0F) 
        {
            bin_val = 0;
        }
        //Assign bin_val to led output
        Bits = bin_val;
        //wait 1 second
        wait(1);
    }
}