#include "mbed.h"
#include "rtos.h"
#include "NeoStrip.h"

#define N 24
#define NUM_WIDTH 5
#define NUM_HEIGHT 7
#define CHARACTER_SIZE 7
#define WAIT_TIME  600

DigitalIn  hall1(p15);
DigitalIn  hall2(p16);

DigitalOut myled(LED1);
NeoStrip strip1(p11, N);
Serial usb(USBTX, USBRX);
//134125 = move backwards slowly
//135000 = move backwards slowly
//140000 = move forwards quickly
//136000 = move forward slowly
//135500 = move backwards slowly
//135750 = move backwards slowly
volatile int motor_speed_us = 135750;
volatile int one_degree_time = motor_speed_us/360;

volatile int startSeconds = 0;
volatile int startMinutes = 0;
volatile int startHours = 8;

time_t seconds;

int drawCharacter(char* character, int startNum_time, int startPos);

char zero  [5] = {0b0000000, 0b0111110, 0b1000001, 0b1000001, 0b0111110};
char one   [5] = {0b0000000, 0b0000000, 0b0100001, 0b1111111, 0b0000001};
char two   [5] = {0b0000000, 0b0100011, 0b1000101, 0b1001001, 0b0110001};
char three [5] = {0b0000000, 0b1000001, 0b1001001, 0b1001001, 0b0110110};
char four  [5] = {0b0000000, 0b1111000, 0b0001000, 0b0001000, 0b1111111};
char five  [5] = {0b0000000, 0b1110010, 0b1001001, 0b1001001, 0b1000110};
char six   [5] = {0b0000000, 0b0111110, 0b1001001, 0b1001001, 0b0100110};
char seven [5] = {0b0000000, 0b1000000, 0b1000111, 0b1011000, 0b1100000};
char eight [5] = {0b0000000, 0b0110110, 0b1001001, 0b1001001, 0b0110110};
char nine  [5] = {0b0000000, 0b0110000, 0b1001001, 0b1001001, 0b0111110};
char colon [5] = {0b0000000, 0b0000000, 0b0110110, 0b0110110, 0b0000000};

char A [5] = {0b0111111, 0b1001000, 0b1001000, 0b1001000, 0b0111111};
char P [5] = {0b1111111, 0b1001000, 0b1001000, 0b1001000, 0b0110000};
char R [5] = {0b1111111, 0b1001000, 0b1001000, 0b1001100, 0b0110011};
char space [5] = {0b0000000, 0b0000000, 0b0000000, 0b0000000, 0b0000000};



Timer t;
Timer time_tracker;

//Will be issues of random orientation of the clock. Fix the issue with resynchronization using the magnet

void LEDstrip1_thread(void const *args)
{
    t.start();
    time_tracker.start();

    int startNum_time = 50*one_degree_time - NUM_WIDTH/2;
    int endNum_time =  50*one_degree_time + NUM_WIDTH/2;

    bool wroteThisRotation = false;

    strip1.setPixel(23, (uint8_t) 10,(uint8_t) 50,(uint8_t) 50);
    strip1.setPixel(22, (uint8_t) 20,(uint8_t) 200,(uint8_t) 50);
    strip1.setPixel(14,(uint8_t) 20,(uint8_t) 200,(uint8_t) 20);
    strip1.setPixel(13,(uint8_t) 10,(uint8_t) 50,(uint8_t) 50);
    strip1.setPixel(12,(uint8_t) 20,(uint8_t) 200,(uint8_t) 20);
    strip1.setPixel(3, (uint8_t) 10,(uint8_t) 50,(uint8_t) 50);
    strip1.setPixel(4, (uint8_t) 20,(uint8_t) 200,(uint8_t) 50);
    while(1) {

        int time = t.read_us();

        if (time > startNum_time && !wroteThisRotation) {


            int seconds = ((int)time_tracker.read() + startSeconds)%60;
            int minutes = ((int)time_tracker.read()/60 + startMinutes)%60;
            int hours = ((int)time_tracker.read()/3600 + startHours)%24;
            bool AM = true;
            if (hours >= 12) {
                AM = false;
            }
            int printHours = hours % 12;
            if (printHours == 0) {
                printHours = 12;
            }

            char buf [10];
            sprintf(buf, "%02i:%02i:%02i", hours, minutes, seconds);

            for (int i = 8; i > 0; i--) {
                if (buf[i] == '0') {
                    endNum_time = drawCharacter(zero, endNum_time,21);
                } else if (buf[i] == '1') {
                    endNum_time = drawCharacter(one, endNum_time,21);
                } else if (buf[i] == '2') {
                    endNum_time = drawCharacter(two, endNum_time,21);
                } else if (buf[i] == '3') {
                    endNum_time = drawCharacter(three, endNum_time,21);
                } else if (buf[i] == '4') {
                    endNum_time = drawCharacter(four, endNum_time,21);
                } else if (buf[i] == '5') {
                    endNum_time = drawCharacter(five, endNum_time,21);
                } else if (buf[i] == '6') {
                    endNum_time = drawCharacter(six, endNum_time,21);
                } else if (buf[i] == '7') {
                    endNum_time = drawCharacter(seven, endNum_time,21);
                } else if (buf[i] == '8') {
                    endNum_time = drawCharacter(eight, endNum_time,21);
                } else if (buf[i] == '9') {
                    endNum_time = drawCharacter(nine, endNum_time,21);
                } else if (buf[i] == ':') {
                    endNum_time = drawCharacter(colon, endNum_time,21);
                }
            }

            char date[15];
            sprintf(date,"APR 29 2016");

            for (int i = 12; i >= 0; i--) {
                if (date[i] == '0') {
                    endNum_time = drawCharacter(zero, endNum_time,11);
                } else if (date[i] == '1') {
                    endNum_time = drawCharacter(one, endNum_time,11);
                } else if (date[i] == '2') {
                    endNum_time = drawCharacter(two, endNum_time,11);
                } else if (date[i] == '3') {
                    endNum_time = drawCharacter(three, endNum_time,11);
                } else if (date[i] == '4') {
                    endNum_time = drawCharacter(four, endNum_time,11);
                } else if (date[i] == '5') {
                    endNum_time = drawCharacter(five, endNum_time,11);
                } else if (date[i] == '6') {
                    endNum_time = drawCharacter(six, endNum_time,11);
                } else if (date[i] == '7') {
                    endNum_time = drawCharacter(seven, endNum_time,11);
                } else if (date[i] == '8') {
                    endNum_time = drawCharacter(eight, endNum_time,11);
                } else if (date[i] == '9') {
                    endNum_time = drawCharacter(nine, endNum_time,11);
                } else if (date[i] == ':') {
                    endNum_time = drawCharacter(colon, endNum_time,11);
                } else if (date[i] == 'A') {
                    endNum_time = drawCharacter(A, endNum_time,11);
                } else if (date[i] == 'P') {
                    endNum_time = drawCharacter(P, endNum_time,11);
                } else if (date[i] == 'R') {
                    endNum_time = drawCharacter(R, endNum_time,11);
                } else if (date[i] == ' ') {
                    endNum_time = drawCharacter(space, endNum_time,11);
                }
            }
            wroteThisRotation = true;
        }
        if (t.read_us() > motor_speed_us) {
            t.reset();
            //usb.printf("wroteThisRotation\n\r");
            wroteThisRotation = false;
        }
    }
}
int drawCharacter(char* printable_number, int startNum_time, int startPos)
{

    int time = t.read_us();

    int number_column_repeats = CHARACTER_SIZE/NUM_WIDTH;
    int count_num_trans = NUM_WIDTH - 1;

    int transitionNum_time = startNum_time + number_column_repeats*one_degree_time;
    int endNum_time = startNum_time + number_column_repeats*one_degree_time*NUM_WIDTH;


    for (int i = 0; i < NUM_HEIGHT; i++) {
        int litPixel = (printable_number[count_num_trans] & (1 << i))>>i;
        strip1.setPixel(startPos-i, (uint8_t)0*litPixel,(uint8_t)0*litPixel,(uint8_t)100*litPixel);
        //(uint8_t)0,(uint8_t)0,(uint8_t)40
        //(uint8_t) 10*litPixel,(uint8_t) 50*litPixel,(uint8_t) 50*litPixel)
    }


    strip1.write();
    //usb.printf("printable_number[%i] = %i", count_num_trans, printable_number[count_num_trans] );
    count_num_trans = count_num_trans - 1;
    wait_us(WAIT_TIME);
    while (count_num_trans >= 0) {

        //usb.printf("Attempting to print column %i bottom: %i\r\n", count_num_trans, printable_number[count_num_trans]);

        for (int i = 0; i < NUM_HEIGHT; i++) {
            int litPixel = (printable_number[count_num_trans] & (1 << i))>>i;
            strip1.setPixel(startPos-i, (uint8_t)0*litPixel,(uint8_t)0*litPixel,(uint8_t)100*litPixel);
        }



        strip1.write();

        count_num_trans = count_num_trans - 1;
        transitionNum_time = (transitionNum_time + number_column_repeats*one_degree_time);
        //wroteMiddle = true;
    }
    wait_us(WAIT_TIME);

    //usb.printf("Number is finished printing\r\n");

    for (int i = startPos; i > startPos-NUM_HEIGHT; i--) {

        strip1.setPixel(i, 0,0,0);
    }

//    strip1.setPixel(22, 0,0,0);
//    strip1.setPixel(21, 0,0,0);
//    strip1.setPixel(20, 0,0,0);
//    strip1.setPixel(19, 0,0,0);
//    strip1.setPixel(18, 0,0,0);
//
    strip1.write();
    endNum_time = (endNum_time + one_degree_time) % motor_speed_us;
    transitionNum_time = (startNum_time + one_degree_time*number_column_repeats) % motor_speed_us;
    count_num_trans = NUM_WIDTH - 1;
    wait_us(WAIT_TIME);

    return endNum_time;
}


void HallEffect_thread(void const *args)
{
    bool sensesMagnet = false;

    hall1.mode(PullUp);
    hall2.mode(PullUp);
    Thread::wait(10);

    while(1) {
        if (!sensesMagnet && (hall1 == 0 || hall2 == 0)) {
            sensesMagnet = true;
            t.reset();
        } else if (sensesMagnet && hall1 == 1 && hall2 == 1) {
            sensesMagnet = false;
        }
    }
}




int main()
{

    float brightness = 0.05f;
    strip1.setBrightness(brightness);

    for (int i = 0; i < N; i++) {
        strip1.setPixel(i,0,0,0);
    }

    strip1.setPixel(1,0,(uint8_t)255,0);
    strip1.write();

    set_time(1461931200);
    seconds = time(NULL);   // get current time from mbed RTC

    Thread thread2(LEDstrip1_thread);
    Thread thread3(HallEffect_thread);

    thread2.set_priority(osPriorityRealtime);
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }

}















//            if (time < transitionNum_time && time > endNum_time) {
//
//
//                usb.printf("Attempting to print column %i top: %i\r\n", count_num_trans, printable_number[count_num_trans]);
//
//                int led22 = printable_number [count_num_trans] & 0x01;
//                int led21 = (printable_number [count_num_trans] & 0x02)>>1;
//                int led20 = (printable_number [count_num_trans] & 0x04)>>2;
//                int led19 = (printable_number [count_num_trans] & 0x08)>>3;
//                int led18 = (printable_number [count_num_trans] & 0x10)>>4;
//
//                strip1.setPixel(22, (uint8_t)(led22*255),0,0);
//                strip1.setPixel(21, (uint8_t)(led21*255),0,0);
//                strip1.setPixel(20, (uint8_t)(led20*255),0,0);
//                strip1.setPixel(19, (uint8_t)(led19*255),0,0);
//                strip1.setPixel(18, (uint8_t)(led18*255),0,0);
//
//                strip1.write();
//
//                count_num_trans = (count_num_trans + 1)%NUM_WIDTH;
//                transitionNum_time = (transitionNum_time + number_column_repeats*one_degree_time);
//                wroteMiddle = true;
//            }
//        } else {










//
//
//
//
//
//        int time = t.read_us();
//
//    int number_column_repeats = CHARACTER_SIZE/NUM_WIDTH;
//    int count_num_trans = 0;
//
//    int transitionNum_time = startNum_time + number_column_repeats*one_degree_time;
//    int endNum_time = startNum_time + number_column_repeats*one_degree_time*NUM_WIDTH;
//
//    usb.printf("startNum_time: %i\r\n", startNum_time);
//    usb.printf("transitionNum_time: %i\r\n", transitionNum_time);
//    usb.printf("endNum_time: %i\r\n", endNum_time);
//
//    int led22 = printable_number [count_num_trans] & 0x01;
//    int led21 = (printable_number [count_num_trans] & 0x02)>>1;
//    int led20 = (printable_number [count_num_trans] & 0x04)>>2;
//    int led19 = (printable_number [count_num_trans] & 0x08)>>3;
//    int led18 = (printable_number [count_num_trans] & 0x10)>>4;
//
//    strip1.setPixel(22, (uint8_t)(led22*255),0,0);
//    strip1.setPixel(21, (uint8_t)(led21*255),0,0);
//    strip1.setPixel(20, (uint8_t)(led20*255),0,0);
//    strip1.setPixel(19, (uint8_t)(led19*255),0,0);
//    strip1.setPixel(18, (uint8_t)(led18*255),0,0);
//
//    strip1.write();
//    usb.printf("printable_number[%i] = %i", count_num_trans, printable_number[count_num_trans] );
//    count_num_trans = count_num_trans + 1;
//
//    while (count_num_trans < NUM_WIDTH) {
//        int time = t.read_us();
//        if (time > transitionNum_time) {
//
//
//            usb.printf("Attempting to print column %i bottom: %i\r\n", count_num_trans, printable_number[count_num_trans]);
//
//            int led22 = printable_number [count_num_trans] & 0x01;
//            int led21 = (printable_number [count_num_trans] & 0x02)>>1;
//            int led20 = (printable_number [count_num_trans] & 0x04)>>2;
//            int led19 = (printable_number [count_num_trans] & 0x08)>>3;
//            int led18 = (printable_number [count_num_trans] & 0x10)>>4;
//
//            strip1.setPixel(22, (uint8_t)(led22*255),0,0);
//            strip1.setPixel(21, (uint8_t)(led21*255),0,0);
//            strip1.setPixel(20, (uint8_t)(led20*255),0,0);
//            strip1.setPixel(19, (uint8_t)(led19*255),0,0);
//            strip1.setPixel(18, (uint8_t)(led18*255),0,0);
//
//            strip1.write();
//
//            count_num_trans = count_num_trans + 1;
//            transitionNum_time = (transitionNum_time + number_column_repeats*one_degree_time);
//            //wroteMiddle = true;
//        }
//    }
//    bool wroteEnd = false;
//
//    while (!wroteEnd){
//         //           usb.printf("end time %i, current time: %i \r\n", endNum_time, time);
//        int time = t.read_us();
//
//        if ( time > endNum_time) {
//            usb.printf("Number is finished printing\r\n");
//
//            strip1.setPixel(22, 0,0,0);
//            strip1.setPixel(21, 0,0,0);
//            strip1.setPixel(20, 0,0,0);
//            strip1.setPixel(19, 0,0,0);
//            strip1.setPixel(18, 0,0,0);
//
//            strip1.write();
//            endNum_time = (endNum_time + one_degree_time) % motor_speed_us;
//            transitionNum_time = (startNum_time + one_degree_time*number_column_repeats) % motor_speed_us;
//            count_num_trans = 0;
//            return endNum_time;
//
//        }
//    }
//    return endNum_time;
//}
