struct SensorData {
    char Voltage[10];
    char Current[10];
    char Temperature[10];
    //float Battery[2];
} SensorData;

int quantiz(float start,float step,float x)
{
    int y=((x*3.18/65536)-start)/step;
    if(y<=0)y=0;
    if(y>=15)y=15;
    return y;
}

void FUNC_HK_MAIN()
{

    int LoopIterator;

    SelectLine0=0;
    SelectLine1=0;
    SelectLine2=0;
    SelectLine3=0;

    for(LoopIterator=0; LoopIterator<16; LoopIterator++) {

        if(LoopIterator%2==0) {
            SensorData.Current[LoopIterator]=quantiz(start,step,CurrentInput.read_u16());
            SensorData.Voltage[LoopIterator]=quantiz(start,step,VoltageInput.read_u16());
            SensorData.Temperature[LoopIterator]=quantiz(start,step,TemperatureInput.read_u16());
        } else {
            SensorData.Current[LoopIterator-1]=Current[LoopIterator-1]<<4+quantiz(start,step,CurrentInput.read_u16());
            SensorData.Voltage[LoopIterator-1]=Voltage[LoopIterator-1]<<4+quantiz(start,step,VoltageInput.read_u16());
            SensorData.Temperature[LoopIterator-1]=Temperature[LoopIterator-1]<<4+quantiz(start,step,TemperatureInput.read_u16());
        }
// The following lines are used to iterate the select lines from 0 to 15
        SelectLine0=!(SelectLine0);

        if(LoopIterator%2==1)
            SelectLine1=!(SelectLine1);

        if(LoopIterator%4==3)
            SelectLine2=!(SelectLine2);

        if(LoopIterator%8==7)
            SelectLine3=!(SelectLine3);

        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.

    }

}