
struct SensorData {
    float Voltage[10];
    float Current[10];
    float Temp[10];
    //float Battery[2];
} SensorData;


void FUNC_HK_MAIN()
{

    int LoopIterator;

    SelectLine0=0;
    SelectLine1=0;
    SelectLine2=0;
    SelectLine3=0;

    for(LoopIterator=0; LoopIterator<16; LoopIterator++) {

        float SignalValue= AnalogInput.read()*3.180; // Calculation using ADC Reference
        float Temperature=-90.7*SignalValue+190.1543; // Linear Equation for Temperature Sensor


        if(LoopIterator%3==0)
            SensorData.Current[LoopIterator/3]=SignalValue/4.37; // Equation for Current Sensor

        if(LoopIterator%3==1)
            SensorData.Voltage[LoopIterator/3]=SignalValue*4.64; // Equation for Voltage Sensor  || GAIN NEEDS TO BE CHANGED ||


        if(LoopIterator%3==2)
            SensorData.Temp[LoopIterator/3]=Temperature;


        // The following lines are used to iterate the select lines from 0 to 15
        SelectLine0=!(SelectLine0);

        if(LoopIterator%2==1)
            SelectLine1=!(SelectLine1);

        if(LoopIterator%4==3)
            SelectLine2=!(SelectLine2);

        if(LoopIterator%8==7)
            SelectLine3=!(SelectLine3);

        wait_us(10.0); // A delay of 10 microseconds between each sensor output. Can be changed.
    }

}

