/*
 * Source file tokenization
 */
 
enum TokenType {
    UNKNOWN,
    WORD,
    INTEGER,
    EOL
};

struct Token
{
    Token();
    ~Token();

    TokenType getType() const { return type_; }
    bool isValid() const { return type_ != UNKNOWN; }
    
    bool isWord() const { return type_ == WORD; }
    bool isInteger() const { return type_ == INTEGER; }
    bool isEOL() const { return type_ == EOL; }
    
    const char* getWord() const;
    int getInteger() const;
    
    static void get_token(Token* token, const char* str, int* pos);
    
private:
    TokenType type_;
    union {
        char* word;
        int value;
    } u;
};

inline void get_token(Token* token, const char* str, int* pos) {
    Token::get_token(token, str, pos);
}