/*
 * Main program, looks for LOGO file on robot and executes the commands
 * within it.
 */
 
#include "mbed.h"
#include "m3pi.h"

#include "commands.h"

m3pi m3pi(p23,p9,p10);
LocalFileSystem local("local");

FILE* open_last_lgo_file() {
    char* fn = NULL;
    
    DIR *d = opendir("/local");
    for (struct dirent *p = readdir(d); p != NULL; p = readdir(d)) {
        const char* dot = strchr(p->d_name, '.');
        if (dot != NULL) {
            const char* ext = dot+1; // skip '.'
            if (strcmp(ext, "LGO") == 0) {
                m3pi.cls();
                m3pi.printf("Found");
                m3pi.locate(0,1);
                m3pi.printf("%.*s", 8, p->d_name);
                
                // Save reference to the file. Treat the last file as the 
                // most recent. This may or may not be correct!
                size_t fn_len = strlen("/local/") + strlen(p->d_name) + 0;
                fn = (char*)((fn != NULL) ? realloc(fn, fn_len) : malloc(fn_len));
                sprintf(fn, "/local/%s", p->d_name);
            }
        }
    }
    closedir(d);
    
    FILE* f = NULL;
    if (fn != NULL) {
        f = fopen(fn, "r");
        free(fn);
        fn = NULL;
        wait(2.0);
    }
    return f;
}

int main() {
    FILE* f = open_last_lgo_file();
    if (f != NULL) {
        int line = 1;
        char buf[256];
        while (!feof(f)) {
            const char* str = fgets(buf, sizeof(buf), f);
            if (str == NULL) {
                break;
            }
            int pos = 0;
            while (true) {
                Command* cmd =  build_command(line, str, &pos);
                if (cmd != NULL) {
                    m3pi.cls();
                    m3pi.printf("%s", cmd->string());
                    wait(2.0);
                    cmd->go();
                    destroy_command(cmd);
                } else
                    break;
            }
            ++line;
        }
        fclose(f);
        m3pi.cls();
        m3pi.printf("Success");
    } else {
        m3pi.cls();
        m3pi.printf("NotFound");
    }
}
