// m3pi RFID Reader Example

#include "mbed.h"
#include "m3pi.h"     // m3pi robot controls
#include "ID12RFID.h" // RFID reader library

m3pi m3pi;

// This is needed to access the RFID Reader...
ID12RFID rfid(p14);

int main() {

    m3pi.locate(0,0);
    m3pi.printf("RFIDRead");

    while (1) {
    
        // Check if the reader is reading an ID?
        if(rfid.readable()) {
        
            // Get the ID from the reader...
            int id = rfid.read();

            // Print it on the LCD...
            m3pi.locate(0,1);
            m3pi.printf("%d", id);
        }
    }
}
