// Réalisation du projet ATTITUDE IMU  
// Dernière Modification le 30.10.2021
// Thanks to Jason Mar for his library and Sebastian Madgwick for his filter algorithm



#include "LSM9DS1.h"
#include "mbed.h"
#include <math.h>
#define PI 3.14f

#include "Fusion.h"
#include <stdio.h>



Serial pc(SERIAL_TX, SERIAL_RX);  // sans la carte bluetooth
//Serial pc(PC_10,PC_11);   //avec la carte bluetooth

CircularBuffer <unsigned char,1024> buf;
Timer temps;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
LSM9DS1 lol(PB_9,PB_8, 0xD4, 0x38);
double angle;

Ticker  calcul;
float testmove;
int flag = 0;
int flug = 0;
int u = 0;
float my_ini,mx_ini,mz_ini;
float correction = 0;
float correct_yaw;
float affi_correct_yaw;
 

FusionBias fusionBias;
FusionAhrs fusionAhrs;

void mesure (void){
    flag = 1;
   }

float samplePeriod = 0.01f;

FusionVector3 gyroscopeSensitivity = {
    .axis.x = 1.0f,
    .axis.y = 1.0f,
    .axis.z = 1.0f,                  
};

FusionVector3 accelerometerSensitivity = {
    .axis.x = 1.0f, 
    .axis.y = 1.0f,                   
    .axis.z = 1.0f,                   
};

FusionVector3 hardIronBias = {
    .axis.x = 0.0f,
    .axis.y = 0.0f,
    .axis.z = 0.0f,
}; 

///////////////////////////////////////////////////////////////////////////
void serial_receive()
{
    unsigned char  c=pc.getc(); // attention à protéger les appels pc
    buf.push(c);
    
}
    
void setup ()
{
     
      lol.begin();                       
      lol.calibrate();                 
                                   
}
void yaw_correct_val_ini ()/////////////////////////////////////////////création des variables initiales du magnéto
{
    
    
    lol.readMag();
    my_ini=lol.calcMag(lol.my)*10;
    mx_ini=lol.calcMag(lol.mx)*10;
    mz_ini=lol.calcMag(lol.mz)*10;
    flug = 1;
    }
    
    
////////////////////////////////////////////////////////////////////////
int main()
{
    
      setup();
    
    char l1,l2,l3,l4;
    
    
  
    
    pc.attach(&serial_receive);     // isr sur reception char
    
    
   
    int i = 0;
    float f=10;  
    int j=0;
    char str[20];
 
    
    // Initialise gyroscope bias correction algorithm
    FusionBiasInitialise(&fusionBias, 20.0f, samplePeriod); 

    // Initialise AHRS algorithm
    FusionAhrsInitialise(&fusionAhrs, 0.5f); 

      // Set optional magnetic field limits
    FusionAhrsSetMagneticField(&fusionAhrs, 20.0f, 70.0f); // valid magnetic field range = 20 uT to 70 uT
    // The contents of this do while loop should be called for each time new sensor measurements are available
     pc.baud(115200); //vit de comunication 
       
     calcul.attach(&mesure,0.01);
    //////////////////////// //////////// ///////////////////Partie Transmission
    while(1) {
        
             
             
               
    
        // envoi de données
        
        int x=temps.read_ms();
     if (flug == 0){
           yaw_correct_val_ini ();
           }
        
        if(flag == 1) {
           
            lol.readGyro();
            lol.readAccel();
            lol.readMag();
           
        
             
      ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
       // Calibrate gyroscope
        FusionVector3 uncalibratedGyroscope = {
            .axis.x = -lol.calcGyro(lol.gx), 
            .axis.y = -lol.calcGyro(lol.gy), 
            .axis.z = lol.calcGyro(lol.gz), 
            };
       
        FusionVector3 calibratedGyroscope = FusionCalibrationInertial(uncalibratedGyroscope, FUSION_ROTATION_MATRIX_IDENTITY, gyroscopeSensitivity, FUSION_VECTOR3_ZERO);

        // Calibrate accelerometer
        FusionVector3 uncalibratedAccelerometer = {
            .axis.x = lol.calcAccel(lol.ax), 
            .axis.y = lol.calcAccel(lol.ay), 
            .axis.z = lol.calcAccel(lol.az), 
        };
        FusionVector3 calibratedAccelerometer = FusionCalibrationInertial(uncalibratedAccelerometer, FUSION_ROTATION_MATRIX_IDENTITY, accelerometerSensitivity, FUSION_VECTOR3_ZERO);
        
          // Calibrate magnetometer
        FusionVector3 uncalibratedMagnetometer = {
            .axis.x = lol.calcMag(lol.mx), 
            .axis.y = lol.calcMag(lol.my), 
            .axis.z = lol.calcMag(lol.mz), 
        };
        FusionVector3 calibratedMagnetometer = FusionCalibrationMagnetic(uncalibratedMagnetometer, FUSION_ROTATION_MATRIX_IDENTITY, hardIronBias);
        
        
        // Update gyroscope bias correction algorithm
        calibratedGyroscope = FusionBiasUpdate(&fusionBias, calibratedGyroscope);

        // Update AHRS algorithm
        FusionAhrsUpdate(&fusionAhrs, calibratedGyroscope, calibratedAccelerometer, calibratedMagnetometer, samplePeriod);

        // Print Euler angles
        FusionEulerAngles eulerAngles = FusionQuaternionToEulerAngles(FusionAhrsGetQuaternion(&fusionAhrs));
        u = u+1;
      testmove = testmove + eulerAngles.angle.yaw;
       
  
///////////////////////////////////////////////////////////////////////////////////////////////////////repérage de pas de mouvement et application de la correction
      
       if (u == 10 ) 
       {
   if ((testmove/10) > eulerAngles.angle.yaw -0.02 &&  (testmove/10) < eulerAngles.angle.yaw +0.02)
       { 
        if ((lol.calcMag(lol.my)*10) > my_ini-0.1 && ((lol.calcMag(lol.my)*10 < my_ini+0.1)))
        {
          if (((lol.calcMag(lol.mx)*10) > mx_ini-0.25 && ((lol.calcMag(lol.mx)*10) < mx_ini+0.25)))
           {
               if (((lol.calcMag(lol.mz)*10) > mz_ini-0.25 && ((lol.calcMag(lol.mz)*10) < mz_ini+0.25)))
               { 
///////////////////////////////////////////////////////////////////////////////////////////////////////// correction progressive
           if(correct_yaw < 10)
           {
            correction = correction + 5;
                correct_yaw = eulerAngles.angle.yaw + (correction);
                }
            if(correct_yaw < 2)
            {
                correction = correction + 1;
                correct_yaw = eulerAngles.angle.yaw + (correction);
             
                }
                 if(correct_yaw > -10)
           {
            correction = correction - 5;
                correct_yaw = eulerAngles.angle.yaw + (correction);
               
                }
            if(correct_yaw > -2)
            {
                correction = correction - 1;
                correct_yaw = eulerAngles.angle.yaw + (correction);
                
            
                }  
            }
           
        } 
     }
 }
 
///////////////////////////////////////////////////////////////////////////////////////////////////////
        affi_correct_yaw = eulerAngles.angle.yaw +(correction);
   
       
              
      // pc.printf("%6.1f %6.1f %6.1f\n",eulerAngles.angle.roll, eulerAngles.angle.pitch, affi_correct_yaw);    //affichage LabVIEW
       pc.printf("Roulis : %6.1f Tangage : %6.1f  Lacet : %6.1f\n\r",eulerAngles.angle.roll, eulerAngles.angle.pitch, affi_correct_yaw);    //affichage TeraTerm
       u = 0;
       testmove =0;
       }
        i++;
        flag = 0;
       }   
}
        
 //////////////////////// //////////// /////////////////////////Partie Réception         
        //reception de données
        while(!buf.empty()) {
            unsigned char c;
            buf.pop(c);
            switch(c) {
                case '\r' :  // fin de message on traite
                    str[j]=NULL;  // fin de chaine
                    j=0;
                    // debut traitement chaine recue
                    sscanf(str,"%d %d %d %d %f",&l1,&l2,&l3,&l4,&f);
                    
                    led2=l2;
                    // fin traitement chaine recue
                    break;
                case '\n':  // on ignore
                    break;
                default :   // on stocke
                    str[j]=c;
                    j++;
          }
        }  
}

