#ifndef SOCKET_MODULE_H
#define SOCKET_MODULE_H
#include "mbed.h"

#ifndef DIST_S
#define DIST_S
class SonicDist
{
    public:
        SonicDist(PinName Trig, PinName Echo);
        double read(void);
        double read_mm(void);
        double takeDist(void);
        void Init(void);
    private:
        void releaseTrig(void);
        void setTrig(void);
        void endMeasure(void);
        void FallNoiseCheck(void);//立ち下がりノイズの判定
        void StartMeasure(void);
        double soundspeed;//音速
        bool startflag;
        Ticker pulse;
        Timeout Postponement;//ノイズ判定を行うための割り込み
        DigitalOut* trig;
        InterruptIn* echo;
        Timer echotime;
        int distbuf;//仮格納距離(mm)
        bool NoiseCheckFlag;//ノイズチェックが終了しているかの判定用
        int dist;//距離(mm)
};
#endif

#endif
