#include "mbed.h"
#include "SonicDist.h"
SonicDist::SonicDist(PinName Trig, PinName Echo)
{
    trig=new DigitalOut(Trig);
    echo=new InterruptIn(Echo);
    soundspeed=340;
    startflag=false;
    NoiseCheckFlag=false;
    dist=-1;//まだ未測定時かどうかの判定用にdistはありえない値（負の値を代入しておく）
    trig->write(1);
    echo->rise( this, &SonicDist::StartMeasure );
    echo->fall( this, &SonicDist::endMeasure );
}
void SonicDist::StartMeasure(void)
{
    if(startflag && NoiseCheckFlag==false) {
        echotime.reset();
    }else{
        Postponement.detach();
    }
}
void SonicDist::endMeasure(void)
{
    if(dist!=-1&& startflag) {
        distbuf=echotime.read()*soundspeed*1000/2;//mmで出力
        if(distbuf<10){distbuf=dist;}//立ち上がりノイズと判定
        startflag=false;
        NoiseCheckFlag=true;
        Postponement.attach(this,&SonicDist::FallNoiseCheck,0.04);
    }
}

void SonicDist::FallNoiseCheck(void)//ここに到達すると立下りのノイズではないと判定される
{
    dist=distbuf;
    NoiseCheckFlag=false;
}
void SonicDist::Init(void)
{
    echotime.start();
    pulse.attach(this,&SonicDist::setTrig,0.05);
    dist=-2;
}
void SonicDist::setTrig(void)
{
    startflag=true;
    trig->write(!trig->read());
}
double SonicDist::read(void)
{
    return SonicDist::read_mm()/10;
}
double SonicDist::read_mm(void)
{
    if(dist<0) {
        SonicDist::takeDist();
        wait(0.03);
    }
    return dist;
}
double SonicDist::takeDist(void)
{
    if(dist==-1) {
        SonicDist::Init();
    }
    return (double)dist/10;
}