#include "mbed.h"
#include "SonicDist.h"
#include "beep_sound.h"
#define TH 0.2
DigitalOut myled(LED1);
SonicDist dist(D9,A3);
DigitalIn sw1(D4);
DigitalIn sw2(D5);
DigitalOut led1 (A1);
DigitalOut led2 (A0);
beep_sound sp(D10);
PwmOut Ain1(PA_11);
PwmOut Ain2(PC_6);
PwmOut Bin1(PC_8);
PwmOut Bin2(PC_9);
AnalogIn LineL(PB_1);
AnalogIn LineC(PC_5);
DigitalOut ledL(PB_13);
DigitalOut ledC(PB_14);
DigitalOut ledR(PB_15);
AnalogIn LineR(PC_2);
void move(double mA,double mB);
void brake(void);
int main()
{

    double buf;
    buf=dist.read();
    wait(0.4);
    while(!sw1) {
        printf("%lf,%lf,%lf,(%lf)\n",(double)LineL,(double)LineC,(double)LineR,dist.read());
    }
    
    while(1) {
        buf=dist.read();
        if(buf<5) {
            move(0,0);
            wait(1);
            move(1,-1);
            wait(0.5);
            move(1,1);
            wait(0.5);
            move(-1,1);
            wait(0.5);
            move(1,1);
            wait(1);
            move(-1,1);
            wait(0.5);
            move(1,1);
            while((double)LineC<TH){
                printf("%lf,%lf,%lf,(%lf)\n",(double)LineL,(double)LineC,(double)LineR,dist.read());
                }
            move(0.5,0.5);
            wait(0.5);
            while(1) {
                move(1,-1);
                if((double)LineC>TH) {
                    led1=1;
                } else {
                    led1=0;
                }
                if((double)LineC>TH) {
                    move(0,0);
                    break;
                }
            }
        } else {
            if((double)LineC>TH) {
                move(0.8,0.8);
                if((double)LineC>0.7) {
                    led2=1;
                    sp.beep_right(1);
                    move(0,0);
                    wait(1);
                    move(0.8,-0.8);
                    wait(0.5);
                    while((double)LineC<TH);
                } else {
                    led2=0;
                }
            } else {
                if((double)LineR>TH) {
                    move(0.8,0.4);
                } else  if((double)LineL>TH) {
                    move(0.4,0.8);
                }
            }
        }
        //if(buf<20)sp.beep_right(1);
        //printf("%lfcm\n", buf);

    }
}
void move(double mA,double mB)
{
    if(mA<0) {
        Ain2=1;
        Ain1=1+mA;
    } else {
        Ain2=1-mA;
        Ain1=1;
    }
    if(mB<0) {
        Bin2=1;
        Bin1=1+mB;
    } else {
        Bin2=1-mB;
        Bin1=1;
    }
}
