#include "ROBOXformat.h"
ROBOXformat::ROBOXformat(PinName irin, double delay)
{
    button = new InterruptIn(irin);
    signal_ignore_flag=false;
   //button->mode(PullDown);
    IRinit(delay);
}
ROBOXformat::~ROBOXformat()
{
    delete button;
}
void ROBOXformat::IR_timeout(void)
{
    if (signal_change_flag == true) { data = 0;}
    signal_timeout_flag=false;
}
void ROBOXformat::IR_ON(void) {
    
    //if(signal_progress!=0)
    if(signal_ignore_flag)return;
    s_timer[1]+=t.read_us();
    t.reset();
    int bit=code_check();
    switch(bit)
    {
        case -1://ノイズ。不正データの場合
        break;
        case 2://リーダーコードの場合
        signal_progress=0;
        break;
        case 0:
        case 1://データの場合
        recieve_bit[signal_progress]=bit;
        signal_progress++;
        if(signal_progress>=LAST_PROGRESS)
        {
            signal_progress=0; 
            dataset();
        }
        break;   
    }

}
int ROBOXformat::code_check(void)
{
    if((s_timer[0]>SIGNAL_T*15)&&(s_timer[0]<=SIGNAL_T*17)&&(s_timer[1]>SIGNAL_T*6)&&(s_timer[1]<=SIGNAL_T*9))
    {s_timer[0]=0;s_timer[1]=0;return 2;//リーダーコードの場合
    }else if((s_timer[0]>SIGNAL_T*0.5)&&(s_timer[0]<=SIGNAL_T*1.5))
    {
        if((s_timer[1]>SIGNAL_T*2.0)&&(s_timer[1]<=SIGNAL_T*3.5))
        {
            s_timer[0]=0;s_timer[1]=0;return 0;
        }else if((s_timer[1]>SIGNAL_T*0.5)&&(s_timer[1]<=SIGNAL_T*2.0))
        {
            s_timer[0]=0;s_timer[1]=0;return 1;
        }
    }else if((s_timer[1]>SIGNAL_T*9)||(s_timer[0]>SIGNAL_T*17))
    {
        s_timer[0]=0;s_timer[1]=0;return -1;
    }else if(s_timer[1]>s_timer[0])
    {
        s_timer[1]+=s_timer[0];s_timer[0]=0;return 3;
    }else
    {
        s_timer[0]+=s_timer[1];s_timer[0]=0;return 3;
    }  
    
    s_timer[0]=0;s_timer[1]=0;return -1;//拾われなかった＝不正な信号
}
void ROBOXformat::IR_OFF(void) {
    if(signal_ignore_flag)return;
    s_timer[0]+=t.read_us();
    t.reset();
}

void ROBOXformat::IRinit(double delay) 
{
    signal_change_flag=false;
    signal_timeout_flag=false;
    grobal_signal = false;
    no_signal_delay=delay;
    t.start(); 
    button->rise(this, &ROBOXformat::IR_OFF);  
    button->fall(this, &ROBOXformat::IR_ON);  
}
unsigned char ROBOXformat::encode_ECC(unsigned char data)
{
    unsigned char b[8],i;
    for (i = 0; i < 8; i++) {
        b[i] = data & 1;
        data >>= 1;
    }
    /*戻り値にパリティを格納*/
    return
      (b[0] ^ b[2] ^ b[4] ^ b[6]) << 5 //p[0]
    | (b[1] ^ b[3] ^ b[5] ^ b[7]) << 4 //q[0]
    | (b[0] ^ b[1] ^ b[4] ^ b[5]) << 3 //p[1]
    | (b[2] ^ b[3] ^ b[6] ^ b[7]) << 2 //q[1]
    | (b[0] ^ b[1] ^ b[2] ^ b[3]) << 1 //p[2]
    | (b[4] ^ b[5] ^ b[6] ^ b[7]);     //q[2]
    /*ECCのアルゴリズムは（http://community.osdev.info/index.php?ECC）にある
    サンプル＋α（８ビット目に１を指定）を参考にして作りました
    */
}
unsigned char ROBOXformat::decode_ECC(unsigned char data,unsigned char ecc)
{
    unsigned char pardata=0,comparison=0,i=0;
    pardata = encode_ECC(data);//受信データをもとにパリティを作成
    if(pardata!=ecc)//実際に作ったパリティと比較
    {
        /*受信データ内に誤りあり*/
        comparison=pardata;
        comparison^=ecc;
             if(comparison == (1<<1|1<<3|1<<5))data ^= 1;
        else if(comparison == (1<<1|1<<3|1<<4))data ^= (1<<1);
        else if(comparison == (1<<1|1<<2|1<<5))data ^= (1<<2);
        else if(comparison == (1<<1|1<<2|1<<4))data ^= (1<<3);
        else if(comparison == (1   |1<<3|1<<5))data ^= (1<<4);
        else if(comparison == (1   |1<<3|1<<4))data ^= (1<<5);
        else if(comparison == (1   |1<<2|1<<5))data ^= (1<<6);
        else if(comparison == (1   |1<<3|1<<4))data ^= (1<<7);//ビット列の誤りを修正
        else 
        {
            //ここまで来たらECCのエラーまたは2bit以上の誤り（修復不可能）の場合である
            ecc=0;for(i=0;i<6;i++){if(comparison & 1 << i )ecc++;}//食い違うビットの数を確認(とりあえずeccに格納)
            if(ecc==1)return data;//ECCのエラーと判定（ビット修正無し）
            return 0;//そうじゃない場合=2bit以上の誤りにより修復不可能なノイズを検知（戻り値0b10000000)
        }
    }
    return data;
}
void ROBOXformat::dataset(void)
{
    int bdata=0,eccs=0;
    for(int i=1;i<5;i++){if(recieve_bit[i]!=recieve_bit[9-i])return;}//反転データに誤りが無いかの確認
    if(!(recieve_bit[0]))for(int i=1;i<5;i++){if(recieve_bit[i]!=Ccode[i-1])return;}//カスタムコードと一致しているかの確認
    for(int i=0;i<8;i++){
        bdata|=(recieve_bit[10+i]<<i);
        if(i<6)eccs|=(recieve_bit[18+i]<<i);
    }
    if(recieve_bit[0]==1)
    {
        gl_data=decode_ECC(bdata,eccs);
        for(int i=1;i<5;i++){gl_address[i-1]=recieve_bit[i];}
    }else 
    {
        data=decode_ECC(bdata,eccs);
        IrTimeout.attach(this, &ROBOXformat::IR_timeout,no_signal_delay);
        signal_change_flag=true;
        grobal_signal = false;
    }
}
void ROBOXformat::send_code(PinName s,unsigned int data,bool global)
{
    int sdata[25],ecc;
    PwmOut signal(s);
    signal.period(1.0/38000);//38khz変調を掛けるため、周期を変更
    signal=0;//消す
    signal_ignore_flag=true;
    ecc=encode_ECC(data);
    if(global){sdata[0]=1;sdata[9]=0;}else{sdata[0]=0;sdata[9]=0;}//服従bit設定
    for (int i = 0; i < 4; i++) {
        sdata[1+i]   = Ccode[i];
        sdata[8-i] = Ccode[i];
    }
    for (int i = 0; i < 8; i++) {
        sdata[10+i] = data & 1;
        data >>= 1;
    }
    for (int i = 0; i < 6; i++) {
        sdata[18+i] = ecc & 1;
        ecc >>= 1;
    }
    sdata[24] = 1;//終端ビット指定
    //リーダーコード送信
    signal=0.33;//付ける
    wait_us(SIGNAL_T*16);
    signal=0;//消す
    wait_us(SIGNAL_T*8);
    
    for(int i=0;i<25;i++)
    {
        signal=0.33;//付ける
        wait_us(SIGNAL_T);
        signal=0;//消す
        if(sdata[i]==0){//ここの待機時間によって0,1が変化
            wait_us(SIGNAL_T*3);
        }else{
            wait_us(SIGNAL_T);
        }
    }
    //DigitalIn aa(s);
    //delete &signal;
    signal_ignore_flag=false;
}
unsigned int ROBOXformat::getData()
{
    return data;
}
unsigned int ROBOXformat::get_glData()
{  
    return gl_data;
}
unsigned int ROBOXformat::takeData()
{
    unsigned int buf;
    buf=data;data=0;
    return buf;
}
unsigned int ROBOXformat::take_glData()
{
    unsigned int buf;
    buf=gl_data;gl_data=0;    
    return buf;
}unsigned int ROBOXformat::take_glData_With_address(int code[4])
{
    unsigned int buf;
    buf=gl_data;gl_data=0;
    for(int i=0;i<4;i++){code[i]=gl_address[i];}    
    return buf;
}
void ROBOXformat::printData()
{
    int bitbuf=data;
    printf("Ccode:");
    for(int i=0;i<10;i++){printf("%d",recieve_bit[i]);}
    printf(" data:");
    for(int i=0;i<8;i++){printf("%d",bitbuf&1);bitbuf>>=1;}
}
void ROBOXformat::printglData()
{
    int bitbuf=gl_data;
    printf(" gldata:");
    for(int i=0;i<8;i++){printf("%d",bitbuf&1);bitbuf>>=1;}
}
