#ifndef ROBOXFORMAT_H
#define ROBOXFORMAT_H
#include "mbed.h"
#define RECIEVE_MODE 0 //0=精度重視1＝確実さ重視
#define SIGNAL_T 562
#define LAST_PROGRESS 24
/*How to use
受信側の設定
ROBOXformat name(PinName irin, double delay);
    ピン定義と待ち受け時間設定を行います
    待ち受け時間とは新しい信号が来てないと判断し受信コードを０にするまでの時間です。
name.send_code(PinName s,unsigned int data,bool global);
    データ送信を行います
        s：赤外線送信を行うピン番号
        data:送るデータ（8bitまで）
        global:trueの場合グローバルアドレスで送信されます
name.getData();
    受信データを取得します
    戻り値に現在受信したデータが返ってきます
name.takeData();
    受信データを取得します
    一回取得すると受信データが空に成る点でgetDataと違います
name.get_glData();
    受信グローバルデータを取得します
    戻り値に現在受信したデータが返ってきます
name.take_glData();
    受信グローバルデータを取得します
    一回取得すると受信データが空に成る点でget_glDataと違います
name.take_glData_With_address(int code[4]);
    受信グローバルデータとその送信元を取得します
    一回取得すると受信データが空に成る点でget_glDataと違います
name.Ccode[4]
    送信時に自分宛てかどうかを判別するカスタムコードを格納しています
name.data
    8bitの受信データを格納しています
*/

class ROBOXformat
{
    public:
    ROBOXformat(PinName irin, double delay);
    ~ROBOXformat();

    void send_code(PinName s,unsigned int data,bool global);//データ送信
    unsigned int getData();//受信データ取得
    unsigned int get_glData();
    unsigned int takeData();//受信データ取得（取得後に受信データは破棄されます。一回だけ送られた信号を一回だけ取り出したいときに有効）
    unsigned int take_glData();
    bool jammer;//ジャマー状態か否かを判別します
    int Ccode[4];//カスタムコードはここに入れてください
    unsigned int  data,gl_data;
    void printData(void);
    void printglData(void);
    unsigned int take_glData_With_address(int code[4]);
    
    private:
    int gl_address[4];
    void IR_timeout(void);
    void IR_ON(void);
    void IR_OFF(void);
    void IRinit(double delay);
    unsigned char encode_ECC(unsigned char data);
    unsigned char decode_ECC(unsigned char data, unsigned char ecc);
    void dataset(void);
    void ReadCcode(PinName c1,PinName c2,PinName c3,PinName c4);
    int code_check(void);
    InterruptIn* button;
    Timer t;
    Timeout IrTimeout;
    double no_signal_delay;
    bool signal_change_flag;
    bool signal_timeout_flag;
    bool grobal_signal;
    bool signal_ignore_flag;
    int s_timer[2];
    int recieve_bit[LAST_PROGRESS];
    uint8_t signal_progress;
    int count;
};
#endif

