#include "mbed.h"
#include "beep_sound.h"
#include "ROBOXformat.h"
ROBOXformat ir(A3,0.4);//SOCKET_E2に赤外線受信モジュールをセット
beep_sound sp(D10);//SOCKET_E3にスピーカーモジュールをセット
//スタートアップボード用のスイッチやLED類
DigitalIn sw1(D4);
DigitalIn sw2(D5);
DigitalOut led1 (A1);
DigitalOut led2 (A0);
//モーター用の設定(ギア比は１１４．７：１を想定)
PwmOut Ain1(PA_11);
PwmOut Ain2(PC_6);
PwmOut Bin1(PC_8);
PwmOut Bin2(PC_9);
int ir_data;//赤外線データ格納用の変数
void move(double mA,double mB);
void brake(void);
int main()
{
    while(1) {//無限ループ
        ir_data=ir.getData();//現在受信中の赤外線データを取得
        /*受け取る赤外線データ
        ＜方向キー（pad左側4つのボタン）＞
        上ボタン＝１
        右ボタン＝２
        下ボタン＝４
        左ボタン＝８
        ＜特殊キー（pad右側4つのボタン）＞
        Ｘボタン＝１６（上）
        Ａボタン＝３２（右）
        Ｂボタン＝６４（下）
        Ｙボタン＝１２８（左）
        この中で押すボタンの数を合計したのが受信しているボタンです
        rev2(緑のコントローラー)だと2個まで、rev3(黒のコントローラー)だと全キーの同時入力まで対応しています。
        例）上ボタンとＡボタンの同時押し→1+32=33
        */
        if(ir_data==8) {
            move(-1,1);
        } else if(ir_data==2) {
            move(1,-1);
        } else if(ir_data==64) {
            move(-1,-1);
        } else if(ir_data==128) {
            move(1,1);
        } else if(ir_data==8+128) {
            move(0.5,1);
        } else if(ir_data==2+128) {
            move(1,0.5);
        } else if(ir_data==8+64) {
            move(-0.5,-1);
        } else if(ir_data==2+64) {
            move(-1,-0.5);
        } else {
            move(0,0);
        }
        if(ir_data==32) {
            sp.beep_wrong(1);//クラクション
            wait(1);
        } else if(ir_data==16) {
            sp.beep_notif1(1);//発射音
            ir.send_code(PA_15,255,true);//攻撃光線発射！(PA_15から)
            wait(1);
        } 

    }
}
void move(double mA,double mB)
{
    if(mA<0) {
        Ain2=-mA;
        Ain1=0;
    } else {
        Ain2=0;
        Ain1=mA;
    }
    if(mB<0) {
        Bin2=-mB;
        Bin1=0;
    } else {
        Bin2=0;
        Bin1=mB;
    }
}
void brake(void)
{
    Ain1=1;
    Ain2=1;
    Bin1=1;
    Bin2=1;
}
