#include "mbed.h"
#include "beep_sound.h"
DigitalOut leds[]= {DigitalOut(D9),DigitalOut(A2),DigitalOut(D3),DigitalOut(A5),DigitalOut(D5),DigitalOut(A4),DigitalOut(D4),DigitalOut(A3),DigitalOut(D10),DigitalOut(A0)};
//モーター用のピン設定
DigitalOut Ain1(PD_2);
DigitalOut Ain2(PC_12);
PwmOut Aen(PC_8);
DigitalOut Bin1(PC_11);
DigitalOut Bin2(PC_10);
PwmOut Ben(PC_9);
//スピーカー用のピン設定
beep_sound sp(PB_7);
//ボタン用のピン設定
DigitalIn sw(PC_13);
//以下関数プロトタイプ宣言//
void play_music();
/**
音楽を鳴らします
**/
void move(int Lspeed,int Rspeed);
/**
モーターを動かす関数
Rspeed 入れられる値:整数で-100~100
Lspeed 入れられる値:整数で-100~100
いずれも負の数で後退,正の数で前進
例)move(100,100)//両モーター前進
**/
int main (void) //ここからプログラム開始
{
    ////サンプルプログラム////
    //音を鳴らして動きます. //
    ///////////////////////
    sp.boot();
    while(sw);
    while(1) {
        play_music();
        move(-100,100);
        wait(0.8);
        move(100,-100);
        wait(0.8);
    }
}//プログラム終了
void move(int Lspeed,int Rspeed) //モーターを動かす関数
{
    if(Lspeed>0) { //前転
        Ain1=0;
        Ain2=1;
        Aen=(float)Lspeed/100;
    } else if(Lspeed==0) {
        Ain1=1;
        Ain2=1;
        Aen=1;
    } else {
        Ain1=1;
        Ain2=0;
        Aen=-(float)Lspeed/100;
    }
    if(Rspeed>0) { //前転
        Bin1=1;
        Bin2=0;
        Ben=(float)Rspeed/100;
    } else if(Rspeed==0) {
        Bin1=1;
        Bin2=1;
        Ben=1;
    } else {
        Bin1=0;
        Bin2=1;
        Ben=-(float)Rspeed/100;
    }
}
void play_music() //音楽を鳴らす関数
{
    sp.setGakuhu(1,0,0.2);
    sp.setGakuhu(1,2,0.2);
    sp.setGakuhu(1,4,0.2);
    sp.setGakuhu(1,5,0.2);
    sp.setGakuhu(1,7,0.2);
    sp.setGakuhu(1,5,0.2);
    sp.setGakuhu(1,4,0.2);
    sp.setGakuhu(1,2,0.2);
    sp.playGakuhu();
}