//Monitoring Center

#include "mbed.h"

#define RX_  PTC14
#define TX_  PTC15

//Delay declared in seconds
/*GPIO declaration*/
DigitalOut Red(LED1);
DigitalOut Green(LED2);
DigitalOut Blue(LED3);

DigitalIn sw2(SW2);

//DigitalOut buzzer(D2);
PwmOut buzzer(D3);

int on = 1, off = 0; 

Serial BlueTooth(TX_, RX_);  // bluetooth serial port
//Serial BlueTooth(USBTX, USBRX); // USB serial port


int main(void)
{

    int pause = 3000;
    int buzz_on = 0;
    int reset_flg = 1;
    
    /*LedsOFF (active low)*/
    Red = 1;
    Green = 1;
    Blue = 1;
      
    BlueTooth.baud(9600);
    printf("Trying to Connect to Master\n\r");
    buzzer.write(0.0);
    
    while (!BlueTooth.readable()){   // read data from the bluetooth serial port   
        printf("Trying to c\n\r");
        //wait(0.1);
    }
    while (BlueTooth.getc() != 'Z'){   // searching for starting byte from master
        printf("Searching for Z\n\r");    
    }
    
    //data[0] = BlueTooth.getc();
    printf("Connected\n\rStarting byte= %c\n\r", BlueTooth.getc() );
   
    printf("Sending Ack\n\r");
    
    while(pause--){ // sending master acknowledgment 
        BlueTooth.putc('X');
    }
    
    printf("Ack Recived: System Ready\n\r"); // turn LGB LED blue upon Ack recived
    Red = 1;
    Green = 1;
    Blue = 0;
    
    while (true)  
    {
     
        buzzer.write(0.0);
        if(BlueTooth.readable()) // read data from the bluetooth serial port    
        {   
            while(BlueTooth.getc() == 'A'){   // turn LGB LED yellow when Alert recived
                printf("Alert Recieved\n\r");
                reset_flg = 1;
                Blue = 1;
                Red = 0;
                Green = 0;
                wait(.5);
                Red = 1;
                Green=1;
                wait(0.5);
            }
            buzzer.write(0.0);
            while(BlueTooth.getc() == 'C') // turn LGB LED green upon correct password
            {
                printf("Correct password\n\r");
                Blue = 1;
                Red = 1;
                Green = 0;    
            }
            
            while(BlueTooth.getc() == 'G')
            {
                printf("Alam TimeOut\n\r"); 
            }
            
            buzz_on=1;
            while((BlueTooth.getc() == 'F') && reset_flg) // turn LGB LED Red, sound buzzer
            {
                printf("Incorrect Password\n\r");
                
                Blue = 1;
                Red = 0;
                Green = 1;
                
                if(buzz_on)
                {
                    printf("Buzzer On\n\r");
                    buzzer.period(1.0/8.0);
                    buzzer.write(.5);
                    buzz_on = 0;    
                }
                if(sw2==0) // turn off buzzer when sw2 pressed
                {
                    printf("Alarm Disabled\n\r");
                    buzzer.write(0.0); 
                    reset_flg = 0;
                    wait(2);
                }   
            }//end while
            
            
            //reset_flg = 1;
            printf("Alarm Off\n\r");    
            buzzer.write(0.0);
            Blue = 1;        
            Red = 1;
            Green = 1;     
        }  
          
    }//end while(true)      
}
