//Home_System

#include "mbed.h"

#define RX_  PTC14
#define TX_  PTC15

Timeout response; // Timer

//Delay declared in seconds
/*GPIO declaration*/
DigitalOut Green(LED_GREEN);
DigitalOut Red(LED_RED);
DigitalOut Blue(LED_BLUE);

DigitalIn  sw2(SW2);
DigitalIn  motion(D7);

Serial BlueTooth(TX_, RX_);  // bluetooth serial port
Serial pc(USBTX, USBRX ); // USB serial port

void Alert() { // Timer call back function
    printf("TimeOut\n\r");
    Blue = 1;
    Green = 1;
    Red = 0;
    int run = 5000;
    while(run--){
        BlueTooth.putc('F'); // send alert to slave
    }
    printf("Alert Sent\n\r");
   
    run = 100;
    while(run--){
        BlueTooth.putc('G'); // send alarm timeout to slave
    }
    printf("Alert Timeout\n\r");
    
}


int main()
{
    char send = 'Z';
    char hold = 'a';
    char correct = 'C';
    
    /*LedsOFF (active low)*/
    Red = 1;
    Green = 1;
    Blue = 1;
    
    pc.baud(9600);
    BlueTooth.baud(9600);
    printf("Master Connecting to Slave:\n\r");
    
    while (send!='R') {
      
        BlueTooth.putc(send);
        wait(0.5f); // wait a small period of time       

        if(BlueTooth.readable()) // read data from the bluetooth serial port
        {
            while(hold!='X'){
                hold = BlueTooth.getc(); 
            }
            if(hold=='X')
            {   
                printf("Ack Recieved from Slave: Sytem Ready!\n\r");
                Blue = 0;
                Red = 1;
                Green = 1;
                send = 'R'; //System Ready
            } 
        }
        wait(0.5f); // wait a small period of time        
    }
    
  //  -----------------------------------------------------------------------------------------
    while(1)
    {
        while(motion) // detecting motion
        {   Blue = 1;
            printf("Motion Detected\n\r");
            
            if(sw2==1){ // use has 2 second window to enter password after motion dection
                response.attach(&Alert, 2.0); // set timer for 2 seconds
                BlueTooth.putc('A'); // send alert to slave
                // LED yellow
                Green=0;
                Red = 0;
            }
            else{
                printf("Sw2 pressed\n\r");
                response.detach(); // disable timer
                printf("Correct Password\n\r"); 
                int run = 1000; 
                while(run--){
                    BlueTooth.putc(correct); // send correct password msg to slave
                    Red = 1;
                    Green = 0;
                }
                wait(3);
            }         
        }        
    }
}//end Main
