//Monitoring Center

#include "mbed.h"
#include "rtos.h"

#define RX_  PTC14
#define TX_  PTC15

//Delay declared in seconds
/*GPIO declaration*/
DigitalOut Red(LED1);
DigitalOut Green(LED2);
DigitalOut Blue(LED3);

//DigitalIn sw2(SW2);

//DigitalOut buzzer(D2);
PwmOut buzzer(D3);

int on = 1, off = 0; 

Serial BlueTooth(TX_, RX_);  // bluetooth serial port

InterruptIn sw3(SW3);
Thread thread1;

void read_BlueTooth();
void switch_ISR(void);
void sendMsg(char msg,int time);
void LED_Color(char color,int blink);


char correct = 'C';
char alert = 'A';
char connectREQ = 'M'; // connect Request
char connected = 'M';
char ReconnectREQ = 'R';
char Fail = 'F';

int ReconnectFlg = false;
int buzzerFlg = false;
int readyFlg = true;
int actionFlg = 0; 

int main(void)
{
 
    BlueTooth.baud(9600);
    
    LED_Color('P',0);
    buzzer.write(0.0);
    
    sw3.rise(switch_ISR);
    thread1.start(read_BlueTooth);
    
    sendMsg(ReconnectREQ,50); // sending master reconnection request
    
    while(true)
    { 
        
        if( ReconnectFlg )
        {
            LED_Color('P',0);
            printf("Connected\n\rSending Ack to Master\n\r");
            
            sendMsg(connectREQ,100); // sending master acknowledgment
            
            printf("System Ready\n\r"); // turn LGB LED blue upon Ack recived
            ReconnectFlg = false;
            LED_Color('B',0);
        } 
  
        else if( actionFlg == 1 )   // turn LGB LED yellow when Alert recived
        {    
            printf("Alert Recieved\n\r");
            LED_Color('Y',1);
            actionFlg = 0;
        }
    
        else if(actionFlg == 2) // turn LGB LED green upon correct password
        {
            printf("\nCorrect password\n\r");
            LED_Color('G',0);
            wait(2);
            actionFlg = 0;
            readyFlg = true;
            //LED_Color('B',0);
            //printf("System Ready\n\r");    
        }
        else if(actionFlg == 3) // turn LGB LED Red, sound buzzer
        {
            printf("Incorrect Password\n\r");
            //LED_Color('R',1);
            buzzerFlg = true;
            actionFlg = 0;
            printf("Buzzer On\n\r");
            LED_Color('R',0);
        }
        if(buzzerFlg)
        {
            buzzer.period(1.0/8.0);
            buzzer.write(.5);
            //buzzer.write(0.0);
        }
        else
        {
            buzzer.write(0);    
        }
        if(readyFlg)
        {   
            readyFlg = false;
            LED_Color('B',0);
            printf("System Ready\n\r");
        } 
        
    }//end while(true)
          
}// End main-------------------------------

void read_BlueTooth(){
    
    while(true)
    {
        if(BlueTooth.readable()) // read data from the bluetooth serial port
        {
            //printf("data:%c\n\r",BlueTooth.getc());    
            if( BlueTooth.getc() == connectREQ ){
                printf("Trying to Connect to Master\n\r");  
                ReconnectFlg = true;
                buzzerFlg = false;
                actionFlg = 0; 
            }         
            else if( BlueTooth.getc() == alert ){
                actionFlg = 1; //intruder detected
                buzzerFlg = false;  
            }
            else if( BlueTooth.getc() == correct){
                actionFlg = 2;  //correct password
            }
            else if( BlueTooth.getc() == Fail){
                actionFlg = 3;  //incorrect password detected
            }
        }//end if
        
    }// end while
    
}// read_BlueTooth

void switch_ISR(void) { 
    if (buzzerFlg){
        readyFlg = true;
        buzzerFlg = false;
    }
}//end switch_ISR

void sendMsg(char msg,int time){
 
    while(time--){
        BlueTooth.putc(msg);
    }
}//end sendMSg

void LED_Color(char color,int blink){
    
    /*LedsOFF (active low)*/
    Red = 1;
    Green = 1;
    Blue = 1;
    if (color == 'C')
        return;
    else if(color == 'G')
        Green = 0;
    else if(color == 'R')
        Red = 0;
    else if(color == 'B')
        Blue = 0;
    else if(color == 'Y'){
        Red = 0;
        Green = 0;
    }
    else if(color == 'P'){
        Blue = 0;
        Red = 0;   
    }
    else if(color == 'W'){
        Blue = 0;
        Red = 0;
        Green = 0;   
    }
    else{} // do nothing
    
    if(blink){
        wait(0.1f);  // wait a small period of time
        Red = 1;
        Green = 1;
        Blue = 1;
        wait(0.1f);
     }        
}
