//Final_Home_Base

#include "mbed.h"
#include "rtos.h"

#define RX_MC  PTC14
#define TX_MC  PTC15

#define RX_HS  PTB10
#define TX_HS  PTB11

Serial BlueTooth_MC(TX_MC, RX_MC);  // bluetooth serial port
Serial BlueTooth_HS(TX_HS, RX_HS);  // bluetooth serial port


Timeout response; // Timer

/*GPIO declaration*/
DigitalOut Green(LED_GREEN);
DigitalOut Red(LED_RED);
DigitalOut Blue(LED_BLUE);

DigitalIn  sw2(SW2);
DigitalIn  sw3(SW3);
//DigitalIn  motion(D8);

/*GPIO for keypad*/
DigitalOut col4(D0);
DigitalOut col3(D1);
DigitalOut col2(D2);
DigitalOut col1(D3);
DigitalIn  row4(D4);
DigitalIn  row3(D5);
DigitalIn  row2(D6);
DigitalIn  row1(D7);

//keypad Lookup Table
char pad[4][4] = {{'1', '2', '3', 'A'},
                  {'4', '5', '6', 'B'},  
                  {'7', '8', '9', 'C'},
                  {'*', '0', '#', 'D'}};



Thread thread1;
Thread thread2;

void LED_Color(char color,int blink);
void read_BlueTooth();
void Timer_thread();
void sendMsg(char msg,int time,char addr);
int CheckPass(void);
char getkey(void);


char correct = 'C';
char alert = 'A';
char MC_ConnectREQ = 'M'; // connect Request
char MC_ConnectACK = 'M';
char HS_ConnectREQ = 'H'; // connect Request
char HS_ConnectACK = 'H';
char ReconnectREQ = 'R';
char IntruderAlert = 'I';
char Fail = 'F';
char key = 0;

char MonitorCenter = 'M';
char HomeSystem = 'H';

char DefaultPass[4] = {'1','2','3','4'};
char Password[4] = {0};

int timer = 0;
int entryCount = 0;

bool motionFlg = false;
bool Connect_MC_Flg = false; //connect to monitoring center
bool Connect_HS_Flg = false; //connect to Home System
bool ReconnectFlg = true;
bool intruderFlg = false;
bool readyFlg = false;
bool motion = false;

int main()
{
    
    BlueTooth_MC.baud(9600);
    BlueTooth_HS.baud(9600);
    
    LED_Color('P',0);
    
    thread1.start(read_BlueTooth);
    //thread2.start(motion_thread);
    
    while(true) // detecting motion
    {
        if(ReconnectFlg){
        /*
            printf("\n\rMaster Connecting to MS:\n\r");
            while (!Connect_MC_Flg){
                sendMsg(MC_ConnectREQ,1,MonitorCenter);
                wait(0.2f); // wait a small period of time             
            }
    
            printf(">Connected\n\rMaster Connecting to HS:\n\r");
            while (!Connect_HS_Flg){
                sendMsg(HS_ConnectREQ,1,HomeSystem);
                wait(0.2f); // wait a small period of time             
            }
        */
        
            //Connect_MC_Flg = false; // reset status incase of reconnect request
            printf(">Connected\n\rAck Recieved from Slaves!\n\rSystem Ready\n\r");
            ReconnectFlg = false;
            LED_Color('B',0);
            //thread2.start(motion_thread);
        }
          
        if(motion){
            printf("Motion Detected\n\r Alert Sent!\n\r");
            thread1.terminate(); //stop reading bluetooth
            motionFlg = true;
            
            while(key != 'D' && motionFlg){
                key = getkey();  //ready keypad
                wait(0.15f);  //wait for button debounce
                
                if ( key != '!' ){ // use has 10 second window to enter password after motion dection
                    Password[entryCount++] = key;
                    printf("  key: %c\n",key);
                    if(entryCount > 4 )
                        entryCount = 0;
                }
                sendMsg(alert,1,MonitorCenter); // send alert to MS
                LED_Color('Y',0);
                printf( "\rTimer: %d", timer/10);
        
                if(timer++ >= 100)
                {   
                    printf("\n\rTimeOut!\n\r");
                    LED_Color('R',0);
                    sendMsg(Fail,200,MonitorCenter); //send Fail to MS
                    sendMsg(Fail,200,HomeSystem); //send Fail to MS
                    motionFlg = false; //end of motion session
                }
                
            }//end while
            
            if( CheckPass() ){
                printf("\n\rCorrect Password!\n\r"); 
                sendMsg(correct,200,MonitorCenter); // send correct password msg to MC
                sendMsg(correct,200,HomeSystem); // send correct password msg to HS
                LED_Color('G',0);
            }
            else
            {   
                printf("\n\rWrong Password!\n\r");
                LED_Color('R',0);
                sendMsg(Fail,200,MonitorCenter); //send Fail to MC
                sendMsg(Fail,200,HomeSystem); // send Fail msg to HS
            } 
            motion = false;
            motionFlg = false;
            Password[3] = 0;
            timer = 0;
            entryCount = 0;
            key = '!';
            thread1.start(read_BlueTooth);
            wait(2);
            LED_Color('B',0);
            printf("Checking for motion!\n\r");
            
        }// end if(motion)
        
    }// while(true)
    
}//end Main --------------------------------


void read_BlueTooth(){
    char data = 0;
    while(true)
    {
        if(BlueTooth_MC.readable()) // read data from the bluetooth serial port
        {
            data = BlueTooth_MC.getc();
            //printf("recieved:%c\n\r",data);
            if( data == MC_ConnectACK )
            {  
                Connect_MC_Flg = true;  //System Ready
            }
            else if( data == ReconnectREQ )
            {
                printf("\n\rMC loss power\n\r");
                ReconnectFlg = true;
                //Connect_MC_Flg = false;
                //Connect_MC_Flg = false;
            }
            
        }//end if(readable)
        
        if(BlueTooth_HS.readable()) // read data from the bluetooth serial port
        {
            data = BlueTooth_HS.getc();
            printf("recieved:%c\n\r",data);
            if( data == HS_ConnectACK )
            {  
                Connect_HS_Flg = true;  //System Ready
            }
            else if( data == ReconnectREQ )
            {
                printf("\n\rHS loss power\n\r");
                ReconnectFlg = true;
                //Connect_MC_Flg = false;
                //Connect_MC_Flg = false;
            }
            else if( data == IntruderAlert )
            {
                motion = true;
            }
            
        }//end if(readable)
    
    }//end while
    
}// read_BlueTooth

void sendMsg(char msg,int time, char Addrs){
    
    //printf("send %c\n\r",Addrs);
    if(Addrs == MonitorCenter){
        while(time--)
            BlueTooth_MC.putc(msg);
    }else{
        while(time--)
            BlueTooth_HS.putc(msg);
    }
    
}//end sendMSg

void LED_Color(char color,int blink){
    
    /*LedsOFF (active low)*/
    Red = 1;
    Green = 1;
    Blue = 1;
    if (color == 'C')
        return;
    else if(color == 'G')
        Green = 0;
    else if(color == 'R')
        Red = 0;
    else if(color == 'B')
        Blue = 0;
    else if(color == 'Y'){
        Red = 0;
        Green = 0;
    }
    else if(color == 'P'){
        Blue = 0;
        Red = 0;   
    }
    else if(color == 'W'){
        Blue = 0;
        Red = 0;
        Green = 0;   
    }
    else{} // do nothing
    
    if(blink){
        wait(0.1f);  // wait a small period of time
        Red = 1;
        Green = 1;
        Blue = 1;
        wait(0.1f);
     }        
}//end LED_Color

char getkey(void)
{   
        DigitalOut col[4] = {col1, col2, col3, col4};
        
        for(int i = 0; i<4; i++)
            col[i] = 1;
        
        
        for(int i = 0; i<4; i++)
        {
            col[i] = 0;
            //printf("\n\rhere\n\r");
                if(!row1)
                {
                    col[i]=1;
                    return pad[0][i];//printf("in: %d %c\n\r", i, pad[0][i]);    
                }   
                else if(!row2)
                {
                    col[i]=1;
                    return pad[1][i];//printf("in: %d %c\n\r", i, pad[1][i]);     
                }
                else if(!row3)
                {
                    col[i]=1;
                    return pad[2][i];//printf("in: %d %c\n\r", i, pad[2][i]);     
                }
                else if(!row4)
                {
                    col[i]=1;
                    return pad[3][i];//printf("in: %d %c\n\r", i, pad[3][i]);
                }
                else
                {
                    //printf("no press\n\r");    
                }
            col[i]=1;
        }
        return '!';
}//end getKey

int CheckPass(void)
{
    for(int i = 0; i < 4; i++){
        if( DefaultPass[i] != Password[i] )
            return 0;
    }
return 1;
    
}//end CheckPass    

        
