#include "mbed.h"
#include <cctype>
#include <string>
#include "config_me.h"
#include "cell_modem.h"
#include "hardware.h"

#define RX_  PTB10
#define TX_  PTB11

Serial BlueTooth(TX_, RX_);  // bluetooth serial port

I2C i2c(PTC11, PTC10);    //SDA, SCL -- define the I2C pins being used
MODSERIAL pc(USBTX, USBRX, 256, 256); // tx, rx with default tx, rx buffer sizes
MODSERIAL mdm(PTD3, PTD2, 4096, 4096);
DigitalOut led_green(LED_GREEN);
DigitalOut led_red(LED_RED);
DigitalOut led_blue(LED_BLUE);

DigitalOut Green(LED_GREEN);
DigitalOut Red(LED_RED);
DigitalOut Blue(LED_BLUE);

//DigitalIn  motion(D8);

// interrupts for buttons
InterruptIn sw3(SW3);
InterruptIn sw2(SW2);

//Thread thread1;

// flag - must be volatile as changes within ISR
// g_ prefix makes it easier to distinguish it as global
volatile int g_sw3_flag = 0;
volatile int g_sw2_flag = 0;

// SW2 event-triggered interrupt
// ISR = interrupt service routine
// down = button was pushed down/falling
// up = button was released/rising
void sw2_isr_down()
{
    g_sw2_flag = 1;   // set flag in ISR
}

void sw2_isr_up()
{
    g_sw2_flag = 0;
}

// SW3 event-triggered interrupt
void sw3_isr_down()
{
    g_sw3_flag = 1;   // set flag in ISR
}

void sw3_isr_up()
{
    g_sw3_flag = 0;
}

void GenerateModemString(char * modem_string, char btn1, char btn2)
{
    
    sprintf(modem_string, "serial:%s button1:%c button2:%c\r\n",
            M2X_DEVICE_SERIAL, btn1, btn2
           );
    
    
    // HTTP method
    /*
    sprintf(modem_string, "GET %s%s?serial=%s&button1=%c&button2=%c %s%s\r\n\r\n",FLOW_BASE_PATH,
    FLOW_INPUT_NAME, M2X_DEVICE_SERIAL, 
    btn1, btn2, FLOW_URL_TYPE, MY_SERVER_NAME);
    */

} //GenerateModemString


//********************************************************************************************************************************************
//* Set the RGB LED's Color
//* LED Color 0=Off to 7=White.  3 bits represent BGR (bit0=Red, bit1=Green, bit2=Blue)
//********************************************************************************************************************************************
void SetLedColor(unsigned char ucColor)
{
    //Note that when an LED is on, you write a 0 to it:
    led_red = !(ucColor & 0x1); //bit 0
    led_green = !(ucColor & 0x2); //bit 1
    led_blue = !(ucColor & 0x4); //bit 2
} //SetLedColor()

//********************************************************************************************************************************************
//* Process the JSON response.  In this example we are only extracting a LED color.
//********************************************************************************************************************************************
bool parse_JSON(char* json_string)
{
    char* beginquote;
    char token[] = "\"LED\":\"";
    beginquote = strstr(json_string, token );
    if ((beginquote != 0)) {
        char cLedColor = beginquote[strlen(token)];
        PRINTF(GRN "LED Found : %c" DEF "\r\n", cLedColor);
        switch(cLedColor) {
            case 'O': {
                //Off
                SetLedColor(0);
                break;
            }
            case 'R': {
                //Red
                SetLedColor(1);
                break;
            }
            case 'G': {
                //Green
                SetLedColor(2);
                break;
            }
            case 'Y': {
                //Yellow
                SetLedColor(3);
                break;
            }
            case 'B': {
                //Blue
                SetLedColor(4);
                break;
            }
            case 'M': {
                //Magenta
                SetLedColor(5);
                break;
            }
            case 'T': {
                //Turquoise
                SetLedColor(6);
                break;
            }
            case 'W': {
                //White
                SetLedColor(7);
                break;
            }
            default: {
                break;
            }
        } //switch(cLedColor)
        return true;
    } else {
        return false;
    }
} //parse_JSON

void send_button_data(char btn1, char btn2)
{
    char modem_string[512];
    GenerateModemString(&modem_string[0], btn1, btn2);
    char myJsonResponse[512];
    if (cell_modem_Sendreceive(&modem_string[0], &myJsonResponse[0])) {
        if (true) {
            //ledOnce = 1;
            SetLedColor(0x2); //Green
        }
        parse_JSON(&myJsonResponse[0]);
    }
}

void sendMsg(char msg,int time);
void read_BlueTooth(void);
void LED_Color(char color,int blink);

char Base_ConnectACK ='H';
char Base_ConnectREQ = 'H';
char ReconnectREQ = 'R';
char IntruderAlert = 'I';

bool ReconnectFlg = false; 
bool readyFlg = true;
bool BlueFlg = true;
bool motionFlg = true;

DigitalIn  motion(D10);
DigitalOut camera(PTB20);

int main()
{
    //static unsigned ledOnce = 0;

    pc.baud(115200);
    PRINTF(GRN "Hello World from the Cellular IoT Kit!\r\n");
    PRINTF(GRN "Cellular IoT Buttons!\r\n\r\n");

    // SW have a pull-up resistor, so the pin will be at 3.3 V by default
    // and fall to 0 V when pressed. We therefore need to look for a falling edge
    // on the pin to fire the interrupt
    sw3.fall(&sw3_isr_down);
    sw3.rise(&sw3_isr_up);
    sw2.fall(&sw2_isr_down);
    sw2.rise(&sw2_isr_up);
    // since SW have an external pull-up, we should disable to internal pull-down
    // resistor that is enabled by default using InterruptIn
    sw3.mode(PullNone);
    sw2.mode(PullNone);

    LED_Color('P',0); //Red
    
    PRINTF("\r\n");
    //cell_modem_init(); // Initialize the modem

    // Send and receive data perpetually
    
    sendMsg(ReconnectREQ,10); // sending master reconnection request
    while(true) 
    {
        if(BlueFlg){
            read_BlueTooth();
        }
        
        if( ReconnectFlg )
        {
            SetLedColor(5); //purple
            printf("Connected\n\rSending Ack to Master\n\r");
            
            sendMsg(Base_ConnectACK,10); // sending master acknowledgment
            
            //printf("System Ready\n\r"); // turn LGB LED blue upon Ack recived
            //LED_Color('B',0);
            //cell_modem_init(); // Initialize the modem
            ReconnectFlg = false;
            readyFlg = true;
        }
        
        if (g_sw3_flag) {
            printf("%s\n","SW3 Button");
            LED_Color('Y',0);
            sendMsg(IntruderAlert,10);
            send_button_data('0','1');
            readyFlg = true;
            //wait(4);
        } 

        if (motionFlg) {
            if(motion){
                printf("\n\rMotion Detected\n\r");
                LED_Color('Y',0);
                camera = 1;
                sendMsg(IntruderAlert,100);
                send_button_data('0','1');
                camera =0;
                motionFlg = false;
                readyFlg = true;
                wait(4);
            }
        }
        
        if(readyFlg)
        {   
            readyFlg = false;
            BlueFlg = false;
            motionFlg =true;
            LED_Color('B',0);
            cell_modem_init(); // Initialize the modem
            LED_Color('G',0);
            printf("System Ready\n\r");
        }

        // put the MCU to sleep until an interrupt wakes it up
        //sleep();
        //printf("\rWaiting...");
    } //forever loop
}

void read_BlueTooth(){

    if(BlueTooth.readable()) // read data from the bluetooth serial port
    {
        //printf("data:%c\n\r",BlueTooth.getc());    
        if( BlueTooth.getc() == Base_ConnectREQ ){
            printf("Connecting to Master\n\r");  
            ReconnectFlg = true; 
        }         
    }//end if
    
    
}// read_BlueTooth

void sendMsg(char msg,int time){
    //printf("send:%c\n\r",msg);
    while(time--){
        BlueTooth.putc(msg);
        wait(0.1);
    }
}//end sendMSg

void LED_Color(char color,int blink){
    
    /*LedsOFF (active low)*/
    Red = 1;
    Green = 1;
    Blue = 1;
    if (color == 'C')
        return;
    else if(color == 'G')
        Green = 0;
    else if(color == 'R')
        Red = 0;
    else if(color == 'B')
        Blue = 0;
    else if(color == 'Y'){
        Red = 0;
        Green = 0;
    }
    else if(color == 'P'){
        Blue = 0;
        Red = 0;   
    }
    else if(color == 'W'){
        Blue = 0;
        Red = 0;
        Green = 0;   
    }
    else{} // do nothing
    
    if(blink){
        wait(0.1f);  // wait a small period of time
        Red = 1;
        Green = 1;
        Blue = 1;
        wait(0.1f);
     }        
}//end LED_Color