/**
 * Notebook page https://os.mbed.com/users/JohnnyK/notebook/how-start-with-the-littlevgl/
 */

#include "mbed.h"
#include "MPU6050.h"
#include "LCD_DISCO_F746NG.h"
#include "lvgl/lvgl.h"
#include "hal_stm_lvgl/tft/tft.h"
#include "hal_stm_lvgl/touchpad/touchpad.h" 
#include "lv_demo.h"    /*Comment/uncomment will switch between LVGL demo and Hello word example*/

#define LVGL_TICK   10                               //Time tick value for lvgl in ms (1-10msa)
#define TICKER_TIME 10ms                             //modified to miliseconds

Ticker ticker;                                       //Ticker for lvgl                    
 

/*
 * Callback function for lvgl timing.
 * Call lv_tick_inc(x) every x milliseconds in a Timer or Task (x should be between 1 and 10). 
 * It is required for the internal timing of LittlevGL.
 */
void lv_ticker_func(){
    lv_tick_inc(LVGL_TICK); 
}

    //definition des connexion serie
    //Serial pc(USBTX, USBRX);


    //I2C test(I2C_SDA, I2C_SCL);
    const int addr = 0x68;

    //acquisition position angulaire
    float accelero[3]= {1};
    float gyro[3]= {1};
    float temperature =0;
    float MAAccelero[3]= {0,0,0};
    float MIAccelero[3]= {0,0,0};
    int i=0;


    MPU6050 module(D14,D15);

    static void event_MAX(lv_event_t* e)
    {
    LV_LOG_USER("btn_max et min was Clicked");

        
    
    }
    

static void event_handler(lv_event_t* event)
{
    lv_event_code_t code = lv_event_get_code(event);
    if(code == LV_EVENT_CLICKED) {
        printf("Clicked\n");
        
        MAAccelero[0]= 0;
        MAAccelero[1]= 0;
        MAAccelero[2]= 0;

    }
    else if(code == LV_EVENT_VALUE_CHANGED) {
        printf("Toggled\n");
    }
}

    
    
// main() runs in its own thread in the OS
int main()
{
    
    //changement du l'echelle du module
   module.setGyroRange(MPU6050_GYRO_RANGE_2000);
   module.setAcceleroRange(MPU6050_ACCELERO_RANGE_16G);
   
       //Event lorsqu'appuie sur bouton MIN/MAX

   
    printf("LVGL-"); 
    lv_init();                                              //Initialize the LVGL
    tft_init();                                             //Initialize diplay 
    touchpad_init();                                        //Initialize touchpad
    ticker.attach(callback(&lv_ticker_func),TICKER_TIME);   //Attach callback to ticker

    LV_IMG_DECLARE(Logoiut);

    printf("Hello world\n");
    
    /*lv_obj_t * label1 = lv_label_create(lv_scr_act());
    lv_label_set_long_mode(label1, LV_LABEL_LONG_WRAP);     //Break the long lines
    lv_label_set_recolor(label1, true);                      //Enable re-coloring by commands in the text
    lv_label_set_text(label1, "#0000ff Hello# #ff00ff world# #ff0000 - the LVGL and MbedOS#");
    lv_obj_set_width(label1, 150);
    lv_obj_align(label1, LV_ALIGN_TOP_MID, 0, 20);*/
    
    //Circular scroll
    lv_obj_t * label2 = lv_label_create(lv_scr_act());
    lv_label_set_long_mode(label2, LV_LABEL_LONG_SCROLL_CIRCULAR);     
    lv_obj_set_width(label2, 300);
    lv_label_set_text(label2, "IUT CACHAN - Enregistreur de g - Leprevier-Destas Nathan - LP MECSE -");
    lv_obj_align(label2, LV_ALIGN_BOTTOM_MID, -30, 0);
    

    lv_obj_t * label;
    
    //Bouton MAX/MIN 
    lv_obj_t * btn2 = lv_btn_create(lv_scr_act());
    lv_obj_add_event_cb(btn2, event_handler,LV_EVENT_ALL, NULL);
    lv_obj_align(btn2, LV_ALIGN_TOP_LEFT, 25, 5);
    label = lv_label_create(btn2);
    lv_label_set_text(label, "Reset Valeurs Max");
    
    //Logo IUT
    lv_obj_t * img = lv_img_create(lv_scr_act());
    lv_img_set_src(img, &Logoiut);
    lv_obj_set_width(img, 250);
    lv_obj_align(img, LV_ALIGN_TOP_RIGHT, -5, 7);
            
    //MAX GX
    lv_obj_t * labelMaxX = lv_label_create(lv_scr_act());
    lv_label_set_recolor(labelMaxX, true);                      //Enable re-coloring by commands in the text
    lv_label_set_text(labelMaxX, "#0080ff MAX# G sur #0080ff Axe X :#");
    lv_obj_set_width(labelMaxX, 200);
    lv_obj_align(labelMaxX, LV_ALIGN_TOP_RIGHT, -5, 70);
    
    //MAX GY
    lv_obj_t * labelMaxY = lv_label_create(lv_scr_act());
    lv_label_set_recolor(labelMaxY, true);                      //Enable re-coloring by commands in the text
    lv_label_set_text(labelMaxY, "#0080ff MAX G# sur #0080ff Axe Y :#");
    lv_obj_set_width(labelMaxY, 200);
    lv_obj_align(labelMaxY, LV_ALIGN_CENTER, 138, 0);
    
    //MAX GZ
    lv_obj_t * labelMaxZ = lv_label_create(lv_scr_act());
    lv_label_set_recolor(labelMaxZ, true);                      //Enable re-coloring by commands in the text
    lv_label_set_text(labelMaxZ, "#0080ff MAX G# sur #0080ff Axe Z :#");
    lv_obj_set_width(labelMaxZ, 200);
    lv_obj_align(labelMaxZ, LV_ALIGN_BOTTOM_RIGHT, -5, -70);
    
    //MIN GX
    lv_obj_t * labelMinX = lv_label_create(lv_scr_act());
    lv_label_set_recolor(labelMinX, true);                      //Enable re-coloring by commands in the text
    lv_label_set_text(labelMinX, "G sur #ff0000 Axe X :#");
    lv_obj_set_width(labelMinX, 200);
    lv_obj_align(labelMinX, LV_ALIGN_TOP_LEFT, 10, 70);
    
    //MIN GY
    lv_obj_t * labelMinY = lv_label_create(lv_scr_act());
    lv_label_set_recolor(labelMinY, true);                      //Enable re-coloring by commands in the text
    lv_label_set_text(labelMinY, "G sur #ff0000 Axe Y :#");
    lv_obj_set_width(labelMinY, 200);
    lv_obj_align(labelMinY, LV_ALIGN_CENTER, -130, 0);
    
    //MIN GZ
    lv_obj_t * labelMinZ = lv_label_create(lv_scr_act());
    lv_label_set_recolor(labelMinZ, true);                      //Enable re-coloring by commands in the text
    lv_label_set_text(labelMinZ, "G sur #ff0000 Axe Z :#");
    lv_obj_set_width(labelMinZ, 200);
    lv_obj_align(labelMinZ, LV_ALIGN_BOTTOM_LEFT, 10, -70);
    
    //VALEUR MAX GX
    lv_obj_t * labelMaxXV = lv_label_create(lv_scr_act());
    lv_label_set_text_fmt(labelMaxXV, "MX");
    lv_obj_set_width(labelMaxXV, 200);
    lv_obj_align(labelMaxXV, LV_ALIGN_TOP_RIGHT, 125,70);
    
    //VALEUR MAX GY
    lv_obj_t * labelMaxYV = lv_label_create(lv_scr_act());
    lv_label_set_text_fmt(labelMaxYV, "MX");
    lv_obj_set_width(labelMaxYV, 200);
    lv_obj_align(labelMaxYV, LV_ALIGN_CENTER, 267,0);
    
    //VALEUR MAX GZ
    lv_obj_t * labelMaxZV = lv_label_create(lv_scr_act());
    lv_label_set_text_fmt(labelMaxZV, "MX");
    lv_obj_set_width(labelMaxZV, 200);
    lv_obj_align(labelMaxZV, LV_ALIGN_BOTTOM_RIGHT, 125,-70);
    
    //VALEUR Direct GX
    lv_obj_t * labelMinXV = lv_label_create(lv_scr_act());
    lv_label_set_text_fmt(labelMinXV, "MX");
    lv_obj_set_width(labelMinXV, 200);
    lv_obj_align(labelMinXV, LV_ALIGN_TOP_LEFT, 105,70);
    
    //VALEUR Direct GY
    lv_obj_t * labelMinYV = lv_label_create(lv_scr_act());
    lv_label_set_text_fmt(labelMinYV, "MX");
    lv_obj_set_width(labelMinYV, 200);
    lv_obj_align(labelMinYV, LV_ALIGN_CENTER, -35, 0);
    
    //VALEUR Direct GZ
    lv_obj_t * labelMinZV = lv_label_create(lv_scr_act());
    lv_label_set_text_fmt(labelMinZV, "MX");
    lv_obj_set_width(labelMinZV, 200);
    lv_obj_align(labelMinZV, LV_ALIGN_BOTTOM_LEFT, 105,-70);
       
    
    
    while (true){
        module.getAccelero(accelero);
        lv_task_handler(); 
        //Call lv_task_handler() periodically every few milliseconds. 
        //It will redraw the screen if required, handle input devices etc.
        thread_sleep_for(LVGL_TICK);
        
        fabs(accelero[0]);
        fabs(accelero[1]);
        fabs(accelero[2]);
        
        accelero[0] = accelero[0]/9,81;
        accelero[1] = accelero[1]/9,81;
        accelero[2] = accelero[2]/9,81;
        
        if (accelero[0] < 0){
            fabs(accelero[0]);
        }
        
        if (accelero[1] < 0){
            accelero[1] = !accelero[1];
        }
        
        if (accelero[2] < 0){
            accelero[2] = !accelero[2];
        }
        
        if (accelero[0] > MAAccelero[0]){
            MAAccelero[0] = accelero[0];
        }
    
        if (accelero[1] > MAAccelero[1]){
            MAAccelero[1] = accelero[1];
        }
        
        if (accelero[2] > MAAccelero[2]){
            MAAccelero[2] = accelero[2];
        }
        
        /*if (accelero[0] < MIAccelero[0]){
            MIAccelero[0] = accelero[0];
        }
        
        if (accelero[1] < MIAccelero[1]){
            MIAccelero[1] = accelero[1];
        }
        
        if (accelero[2] < MIAccelero[2]){
            MIAccelero[2] = accelero[2];
        }*/
        
        
            
            
        
        //VALEUR MAX GX
        lv_label_set_text_fmt(labelMaxXV, "%f",MAAccelero[0]);
        
        //VALEUR MAX GY
        lv_label_set_text_fmt(labelMaxYV, "%f",MAAccelero[2]);
        
        //VALEUR MAX GZ
        lv_label_set_text_fmt(labelMaxZV, "%f",MAAccelero[1]);
        
        if(i>50){
            //VALEUR Direct GX
            lv_label_set_text_fmt(labelMinXV, "%2.2f",accelero[0]);
        
            //VALEUR Direct GY
            lv_label_set_text_fmt(labelMinYV, "%2.2f",accelero[2]);
        
            //VALEUR Direct GZ
            lv_label_set_text_fmt(labelMinZV, "%2.2f",accelero[1]);
            
            i=0;
        } 
    
        i++;
        
        
        
       
        

                
    
    }
}