#include "mbed.h"
#include "PinDefinitions.h"

Serial pc(USBTX, USBRX);        // serial pc not working yet
InterruptIn mybutton(USER_BUTTON);
DigitalOut Led3(LD3);
DigitalOut motor_enabler(PB_6);     //change this to D

int distance = LENC.getPulses();


void setLeftPwm(float speed) {
    if (speed == 0) {
        LMOTORA = 1.0;
        LMOTORB = 1.0;
    }
    
    if (speed > 0) {
        LMOTORA = speed;
        LMOTORB = 0;
    }
    else {
        LMOTORA = 0;
        LMOTORB = -speed;
    }
}

void setRightPwm(float speed) {
    if (speed == 0) {
        RMOTORA = 1.0;
        RMOTORB = 1.0;
    }
    
    if (speed > 0) {
        RMOTORA = speed;
        RMOTORB = 0;
    }
    else {
        RMOTORA = 0;
        RMOTORB = -speed;
    }
}

void pressed()
{
    Led3 = !Led3;
    pc.printf("Hellooooo\r\n");
}

int main() {

    mybutton.fall(&pressed);
    Led3 = 0;
    
    motor_enabler = 1;
    
    while (LENC.getPulses() < 5000) {   //while encoder pulses are less than 5000, turn led3 on and set LMOTORA to 0.50
        led3 = 1;
        setLeftPwm(0.5);
    }
    LENC.reset();                       // reset encoder pulse count to zero
    while (LENC.getPulses() < 5000) {   //while encoder pulses are less than 5000, turn led3 off and set LMOTORA to 0.25
        led3 = 0;
        setLeftPwm(0.25);
    }
    LENC.reset();
    while (LENC.getPulses() < 10000) {  //while encoder pulses are less than 10000, turn led3 on and set LMOTORA to 1.00
        led3 = 1;
        setLeftPwm(1.0);
    }

    
  
        
 
       
       
} 
       
    

