

#ifndef INIT_H
#define INIT_H

#include "mbed.h"
#include "Encoder.h"
#include "HipControl.h"
#include "knee.h"
#include "FSM.h"
#include "MM_gait.h"
#include "Brad_poly_gait.h"
#define PI (3.141592653589793)
#define my_delete(x) {delete x; x = NULL;}

//#define SAMPLE_TIME .01
#define SAMPLE_TIME .001
#define TO_RAD(x) (x * 0.01745329252)  // *pi/180


/********************************
*  Initializing various I/O pins!
********************************/
extern DigitalOut mbedLED1;
extern DigitalOut mbedLED2;
extern DigitalOut mbedLED3;
extern DigitalOut motorLED;

extern SPI dataBedSPI; // mosi, miso, sclk
extern DigitalOut DB_cs;
extern SPI IMUspi;
extern DigitalOut IMUcs;
extern Serial pc;

// Setup stuff
// absolutes
//extern SPI encoder_L;
//extern DigitalOut encoder_cs_L;
//extern SPI encoder_R;
//extern DigitalOut encoder_cs_R;
extern Encoder encoder_L;
extern Encoder encoder_R;

// Incremental Indexes (only for homing!)
extern InterruptIn encIdx_R;
extern InterruptIn encIdx_L;

// Right Leg
extern PwmOut pwmpin_R;
extern DigitalOut dirpin_R;

//Left Leg
//extern PwmOut pwmpin_L;
//extern DigitalOut dirpin_L;
extern HipControl hip_L;
extern HipControl hip_R;
extern Knee knee_L;
extern Knee knee_R;

extern FSM fsm;

extern struct MMgait_t mm_gait_params;
extern struct Brad_poly_gait_t gait_params;
//extern MMSwing swing;
//extern MMStance stance;
extern BradPolySwing swing;
extern BradPolyStance stance;
extern MMFSStance   fsStance;
extern MMFSSwing fsSwing;
extern MMFTG ftgSwing;
extern MMFTG ftgStance;
extern GaitGenerator mm_gait;
extern LinearBlend blend_left;
extern LinearBlend blend_right;


/*******************************
* END OF I/O Initialization
*******************************/

/*******************************
* GLOBAL VARS
*******************************/

// Global Timers!
extern Timer sysClk;     // system clock (primarily for datalogging)
extern Timer tState;   // time in FSM state
extern Timer t_HCl;  // time when high current begins
extern Timer t_HCr;
extern Timer t_BetweenStepCommand;

const unsigned int enc_ticks=pow(2.,14.)-1; //the number of ticks that the encoder has, 2^14 for our encoder, -1 for 0 state
const float enc2deg = 360./enc_ticks; // converts encoder reading from 0-16383 (14 bit) to 0-360deg (360 / 16383);
const float control_lim_high=90; //soft stop on the controller
const float control_lim_low=-55;//soft stop on the controller
extern float TimeSinceLastStep;

//Control Variables
// Control variables
// Gain Scheduling!
extern float Kp_Swing;
extern float Kp_Stance;
extern const float Kp_DoubleStance;//.01;
extern const float Kp_Standing;//.01; //0.0025
extern const float Kp_StandUp;
extern const float Kp_SitDown ;
extern const float Kp_Seated;

extern float Kd_Stance;
extern float Kd_Swing;

extern const float Kp;
extern float Kd;
extern const float sat;
extern const float Kp_mag;
extern const float Kp_freq;
extern const float Kp_offset;
extern float stand_adjust;

extern float zero_enc_offset_L;//=EncOffset_L;
extern float zero_enc_offset_R;//=EncOffset_R;
//extern float bob_dole;

extern float zero_ang_L;
extern float zero_ang_R;

extern void initializeExoIOs();
void readCalib();

#endif