#ifndef HAPTIC_H
#define HAPTIC_H

#include "mbed.h"
#include "HipControl.h"

extern bool hapticOn;

class MotorMusic
{
public:
    MotorMusic(HipControl &left, HipControl &right);
    void check();
    void playIronMan();
    void playArpeggio();
    void playDH();
    void playLock();
    void playUnlock();
    void setDefault(float a);
private:
    void song();
    void init();
    Timer time;
    HipControl _left;
    HipControl _right;
    bool musicFlag;
    const float *ptrNotes;
    const float *ptrTimes;
    int count_max;
    int count;
    float pwmDefault;

};

extern void initializeHapticFeedback(int);
extern void hapticMaintenance();


#endif