//11/13/12 MM Made fix to haptic error where exo would freak out when it was in the sitting position and you commanded it to stand up
#include "mbed.h"
#include "HipControl.h"
#include "hapticFeedback.h"

// arpeggio down (A E C# A) = f(880 659 554 440) = T(.0011363 .00151745 .00180505 .0022727)
// doogie howser MD theme (A(high) A(high) A(Low) A(low) A(high) D#) = f(880 880 440 440 880 622) = T(.0011363 .0011363 .0022727 .0022727 .0011363 .0016077)

const float arpeggio[] = {.0011363, .00151745, .00180505, .0022727};
const float arpeggio_t[] = {.1, .1, .1, .1};
const float DH[] = {.0011363, .00005, .0011363, .00005, .0022727, .00005, .0022727, .00005, .0011363, .00005, .0016077}; // doogie howser periods
const float DH_t[] = {.1, .05, .1, .05, .1, .05, .1, .05, .1, .05, .1};
const float IronMan[] = {0.0010124,0.0008513,0.00005,0.0008513,0.00005,0.0007584,0.00005,0.0007584,0.0006378,0.0006757,0.0006378,0.0006757,0.0006378,0.0006757,0.0008513,0.000050,0.0008513,0.000050,.0007584,0.00005,0.0007584};
const float IronMan_t[] = {.8,.5,.3,.3,.1,.3,.1,.4,.2,.2,.2,.2,.2,.2,.3,.1,.3,.1,.3,.1,.3};
const float lockSound[] = {.0011363,.0022727};
const float lockSound_t[] = {.3, .3};
const float unlockSound[] = {.0022727,.0011363};
const float unlockSound_t[] = {.2, .2};
const float LowBatterySound[] = {.00151745,.00151745};
const float LowBatterySound_t[] = {.1,.1};
const short unsigned int IronMan_count=(sizeof(IronMan)/sizeof(IronMan[0]))-1;
const short unsigned int arpeggio_count=(sizeof(arpeggio)/sizeof(arpeggio[0]))-1;
const short unsigned int DH_count=(sizeof(DH)/sizeof(DH[0]))-1;
const short unsigned int lockSound_count=(sizeof(lockSound)/sizeof(lockSound[0]))-1;
const short unsigned int unlockSound_count=(sizeof(unlockSound)/sizeof(unlockSound[0]))-1;


bool hapticOn = false;
int buzzMode;

MotorMusic::MotorMusic(HipControl& left, HipControl& right):pwmDefault(0.00005),count(0),count_max(0),_left(left),_right(right)
{
    time.start();
}
void MotorMusic::setDefault(float a)
{
    pwmDefault=a;
}
void MotorMusic::check()
{
    if (musicFlag==1) {
        song();
    }
}
void MotorMusic::init()
{
    _left.pwmPeriod(ptrNotes[count]); //play first note
    _right.pwmPeriod(ptrNotes[count]); //play first note
}
void MotorMusic::song()
{
    if(time.read()>=ptrTimes[count]) { //change note if the time to play the previous note is over
        count++; //change note counter
        time.reset(); //reset and start timer
        _left.pwmPeriod(ptrNotes[count]); //increment note
        _right.pwmPeriod(ptrNotes[count]); //increment note
    }
    if(count>count_max) {
        _left.pwmPeriod(pwmDefault); //increment note
        _right.pwmPeriod(pwmDefault); //increment note
        count=0; //counter to change notes
        musicFlag=0; //flag to signal playing music
    }
}


void MotorMusic::playIronMan()
{
    ptrNotes=IronMan; //point to the Iron Man notes array
    ptrTimes=IronMan_t;//point to the Iron Man times array
    time.reset();//reset timer for music
    musicFlag=1;//flag to play music
    count_max=IronMan_count;
    init();
}
void MotorMusic::playArpeggio()
{
    ptrNotes=arpeggio; //point to the Iron Man notes array
    ptrTimes=arpeggio_t;//point to the Iron Man times array
    time.reset();//reset timer for music
    musicFlag=1;//flag to play music
    count_max=arpeggio_count;
    init();
}
void MotorMusic::playDH()
{
    ptrNotes=DH; //point to the Iron Man notes array
    ptrTimes=DH_t;//point to the Iron Man times array
    time.reset();//reset timer for music
    musicFlag=1;//flag to play music
    count_max=DH_count;
    init();
}
void MotorMusic::playLock()
{
    ptrNotes=lockSound; //point to the Iron Man notes array
    ptrTimes=lockSound_t;//point to the Iron Man times array
    time.reset();//reset timer for music
    musicFlag=1;//flag to play music
    count_max=lockSound_count;
    init();
}
void MotorMusic::playUnlock()
{
    ptrNotes=unlockSound; //point to the Iron Man notes array
    ptrTimes=unlockSound_t;//point to the Iron Man times array
    time.reset();//reset timer for music
    musicFlag=1;//flag to play music
    count_max=unlockSound_count;
    init();
}
//WTF is this? MM


