#include "mbed.h"
#include "gaitGenerator.h"
// timing variables:
// gait generation times
const float tStandingUp = 3;

const float tFirstStep = 1;
const float tStep = 0.9;//1.0;//1.2;
const float tNextStep=1;
const float tStepMod=1;
const float tFeetTogether = .5;

// blending times:
const float t_blend_home2bent = 2;
const float t_blend_home2stand = 3;
const float t_blend_home2sit = 2;
const float t_blend_step = .1;
const float t_blend_FS = .1;
const float t_blend_FTG = .1;
const float t_blend_standUp = .5;
const float t_blend_sitDown = .5;
const float backBias=0;



const float ref_stance_step[] = {
    10.0000,  9.9644,  9.9288,  9.8932,  9.8576,  9.8220,  9.7864,  9.7508,  9.7152,  9.6796,
    9.6440,  9.6085,  9.5729,  9.5373,  9.5017,  9.4661,  9.4305,  9.3949,  9.3593,  9.3237,
    9.2881,  9.2525,  9.2169,  9.1813,  9.1457,  9.1101,  9.0745,  9.0389,  9.0033,  8.9677,
    8.9321,  8.8966,  8.8610,  8.8254,  8.7898,  8.7542,  8.7186,  8.6830,  8.6474,  8.6118,
    8.5762,  8.5406,  8.5050,  8.4694,  8.4338,  8.3982,  8.3626,  8.3270,  8.2914,  8.2558,
    8.2202,  8.1846,  8.1491,  8.1135,  8.0779,  8.0423,  8.0067,  7.9711,  7.9355,  7.8999,
    7.8643,  7.8287,  7.7931,  7.7575,  7.7219,  7.6863,  7.6507,  7.6151,  7.5795,  7.5439,
    7.5083,  7.4727,  7.4372,  7.4016,  7.3660,  7.3304,  7.2948,  7.2592,  7.2236,  7.1880,
    7.1524,  7.1168,  7.0812,  7.0456,  7.0100,  6.9744,  6.9388,  6.9032,  6.8676,  6.8320,
    6.7964,  6.7608,  6.7253,  6.6897,  6.6541,  6.6185,  6.5829,  6.5473,  6.5117,  6.4761,
    6.4405,  6.4049,  6.3693,  6.3337,  6.2981,  6.2625,  6.2269,  6.1913,  6.1557,  6.1201,
    6.0845,  6.0489,  6.0133,  5.9778,  5.9422,  5.9066,  5.8710,  5.8354,  5.7998,  5.7642,
    5.7286,  5.6930,  5.6574,  5.6218,  5.5862,  5.5506,  5.5150,  5.4794,  5.4438,  5.4082,
    5.3726,  5.3370,  5.3014,  5.2659,  5.2303,  5.1947,  5.1591,  5.1235,  5.0879,  5.0523,
    5.0167,  4.9811,  4.9455,  4.9099,  4.8743,  4.8387,  4.8031,  4.7675,  4.7319,  4.6963,
    4.6607,  4.6251,  4.5895,  4.5539,  4.5184,  4.4828,  4.4472,  4.4116,  4.3760,  4.3404,
    4.3048,  4.2692,  4.2336,  4.1980,  4.1624,  4.1268,  4.0912,  4.0556,  4.0200,  3.9844,
    3.9488,  3.9132,  3.8776,  3.8420,  3.8065,  3.7709,  3.7353,  3.6997,  3.6641,  3.6285,
    3.5929,  3.5573,  3.5217,  3.4861,  3.4505,  3.4149,  3.3793,  3.3437,  3.3081,  3.2725,
    3.2369,  3.2013,  3.1657,  3.1301,  3.0945,  3.0590,  3.0234,  2.9878,  2.9522,  2.9166,
    2.8810,  2.8454,  2.8098,  2.7742,  2.7386,  2.7030,  2.6674,  2.6318,  2.5962,  2.5606,
    2.5250,  2.4894,  2.4538,  2.4182,  2.3826,  2.3471,  2.3115,  2.2759,  2.2403,  2.2047,
    2.1691,  2.1335,  2.0979,  2.0623,  2.0267,  1.9911,  1.9555,  1.9199,  1.8843,  1.8487,
    1.8131,  1.7775,  1.7419,  1.7063,  1.6707,  1.6352,  1.5996,  1.5640,  1.5284,  1.4928,
    1.4572,  1.4216,  1.3860,  1.3504,  1.3148,  1.2792,  1.2436,  1.2080,  1.1724,  1.1368,
    1.1012,  1.0656,  1.0300,  0.9944,  0.9588,  0.9232,  0.8877,  0.8521,  0.8165,  0.7809,
    0.7453,  0.7097,  0.6741,  0.6385,  0.6029,  0.5673,  0.5317,  0.4961,  0.4605,  0.4249,
    0.3893,  0.3537,  0.3181,  0.2825,  0.2469,  0.2113,  0.1758,  0.1402,  0.1046,  0.0690,
    0.0334, -0.0022, -0.0378, -0.0734, -0.1090, -0.1446, -0.1802, -0.2158, -0.2514, -0.2870,
    -0.3226, -0.3582, -0.3938, -0.4294, -0.4650, -0.5006, -0.5362, -0.5717, -0.6073, -0.6429,
    -0.6785, -0.7141, -0.7497, -0.7853, -0.8209, -0.8565, -0.8921, -0.9277, -0.9633, -0.9989,
    -1.0345, -1.0701, -1.1057, -1.1413, -1.1769, -1.2125, -1.2481, -1.2836, -1.3192, -1.3548,
    -1.3904, -1.4260, -1.4616, -1.4972, -1.5328, -1.5684, -1.6040, -1.6396, -1.6752, -1.7108,
    -1.7464, -1.7820, -1.8176, -1.8532, -1.8888, -1.9244, -1.9600, -1.9956, -2.0311, -2.0667,
    -2.1023, -2.1379, -2.1735, -2.2091, -2.2447, -2.2803, -2.3159, -2.3515, -2.3871, -2.4227,
    -2.4583, -2.4939, -2.5295, -2.5651, -2.6007, -2.6363, -2.6719, -2.7075, -2.7430, -2.7786,
    -2.8142, -2.8498, -2.8854, -2.9210, -2.9566, -2.9922, -3.0278, -3.0634, -3.0990, -3.1346,
    -3.1702, -3.2058, -3.2414, -3.2770, -3.3126, -3.3482, -3.3838, -3.4194, -3.4549, -3.4905,
    -3.5261, -3.5617, -3.5973, -3.6329, -3.6685, -3.7041, -3.7397, -3.7753, -3.8109, -3.8465,
    -3.8821, -3.9177, -3.9533, -3.9889, -4.0245, -4.0601, -4.0957, -4.1313, -4.1669, -4.2024,
    -4.2380, -4.2736, -4.3092, -4.3448, -4.3804, -4.4160, -4.4516, -4.4872, -4.5228, -4.5584,
    -4.5940, -4.6296, -4.6652, -4.7008, -4.7364, -4.7720, -4.8076, -4.8432, -4.8788, -4.9143,
    -4.9499, -4.9855, -5.0211, -5.0567, -5.0923, -5.1279, -5.1635, -5.1991, -5.2347, -5.2703,
    -5.3059, -5.3415, -5.3771, -5.4127, -5.4483, -5.4839, -5.5195, -5.5551, -5.5907, -5.6263,
    -5.6618, -5.6974, -5.7330, -5.7686, -5.8042, -5.8398, -5.8754, -5.9110, -5.9466, -5.9822,
    -6.0178, -6.0534, -6.0890, -6.1246, -6.1602, -6.1958, -6.2314, -6.2670, -6.3026, -6.3382,
    -6.3737, -6.4093, -6.4449, -6.4805, -6.5161, -6.5517, -6.5873, -6.6229, -6.6585, -6.6941,
    -6.7297, -6.7653, -6.8009, -6.8365, -6.8721, -6.9077, -6.9433, -6.9789, -7.0145, -7.0501,
    -7.0857, -7.1212, -7.1568, -7.1924, -7.2280, -7.2636, -7.2992, -7.3348, -7.3704, -7.4060,
    -7.4416, -7.4772, -7.5128, -7.5484, -7.5840, -7.6196, -7.6552, -7.6908, -7.7264, -7.7620,
    -7.7976, -7.8331, -7.8687, -7.9043, -7.9399, -7.9755, -8.0111, -8.0467, -8.0823, -8.1179,
    -8.1535, -8.1891, -8.2247, -8.2603, -8.2959, -8.3315, -8.3671, -8.4027, -8.4383, -8.4739,
    -8.5095, -8.5451, -8.5806, -8.6162, -8.6518, -8.6874, -8.7230, -8.7586, -8.7942, -8.8298,
    -8.8654, -8.9010, -8.9366, -8.9722, -9.0078, -9.0434, -9.0790, -9.1146, -9.1502, -9.1858,
    -9.2214, -9.2570, -9.2925, -9.3281, -9.3637, -9.3993, -9.4349, -9.4705, -9.5061, -9.5417,
    -9.5773, -9.6129, -9.6485, -9.6841, -9.7197, -9.7553, -9.7909, -9.8265, -9.8621, -9.8977,
    -9.9333, -9.9689,-10.0044,-10.0400,-10.0756,-10.1112,-10.1468,-10.1824,-10.2180,-10.2536,
    -10.2892,-10.3248,-10.3604,-10.3960,-10.4316,-10.4672,-10.5028,-10.5384,-10.5740,-10.6096,
    -10.6452,-10.6808,-10.7164,-10.7519,-10.7875,-10.8231,-10.8587,-10.8943,-10.9299,-10.9655,
    -11.0011,-11.0367,-11.0723,-11.1079,-11.1435,-11.1791,-11.2147,-11.2503,-11.2859,-11.3215,
    -11.3571,-11.3927,-11.4283,-11.4638,-11.4994,-11.5350,-11.5706,-11.6062,-11.6418,-11.6774,
    -11.7130,-11.7486,-11.7842,-11.8198,-11.8554,-11.8910,-11.9266,-11.9622,-11.9978,-12.0334,
    -12.0690,-12.1046,-12.1402,-12.1758,-12.2113,-12.2469,-12.2825,-12.3181,-12.3537,-12.3893,
    -12.4249,-12.4605,-12.4961,-12.5317,-12.5673,-12.6029,-12.6385,-12.6741,-12.7097,-12.7453,
    -12.7809,-12.8165,-12.8521,-12.8877,-12.9232,-12.9588,-12.9944,-13.0300,-13.0656,-13.1012,
    -13.1368,-13.1724,-13.2080,-13.2436,-13.2792,-13.3148,-13.3504,-13.3860,-13.4216,-13.4572,
    -13.4928,-13.5284,-13.5640,-13.5996,-13.6352,-13.6707,-13.7063,-13.7419,-13.7775,-13.8131,
    -13.8487,-13.8843,-13.9199,-13.9555,-13.9911,-14.0267,-14.0623,-14.0979,-14.1335,-14.1691,
    -14.2047,-14.2403,-14.2759,-14.3115,-14.3471,-14.3826,-14.4182,-14.4538,-14.4894,-14.5250,
    -14.5606,-14.5962,-14.6318,-14.6674,-14.7030,-14.7386,-14.7742,-14.8098,-14.8454,-14.8810,
    -14.9166,-14.9522,-14.9878,-15.0234,-15.0590,-15.0945,-15.1301,-15.1657,-15.2013,-15.2369,
    -15.2725,-15.3081,-15.3437,-15.3793,-15.4149,-15.4505,-15.4861,-15.5217,-15.5573,-15.5929,
    -15.6285,-15.6641,-15.6997,-15.7353,-15.7709,-15.8065,-15.8420,-15.8776,-15.9132,-15.9488,
    -15.9844,-16.0200,-16.0556,-16.0912,-16.1268,-16.1624,-16.1980,-16.2336,-16.2692,-16.3048,
    -16.3404,-16.3760,-16.4116,-16.4472,-16.4828,-16.5184,-16.5539,-16.5895,-16.6251,-16.6607,
    -16.6963,-16.7319,-16.7675,-16.8031,-16.8387,-16.8743,-16.9099,-16.9455,-16.9811,-17.0167,
    -17.0523,-17.0879,-17.1235,-17.1591,-17.1947,-17.2303,-17.2659,-17.3014,-17.3370,-17.3726,
    -17.4082,-17.4438,-17.4794,-17.5150,-17.5506,-17.5862,-17.6218,-17.6574,-17.6930,-17.7286,
    -17.7642,-17.7998,-17.8354,-17.8710,-17.9066,-17.9422,-17.9778,-18.0133,-18.0489,-18.0845,
    -18.1201,-18.1557,-18.1913,-18.2269,-18.2625,-18.2981,-18.3337,-18.3693,-18.4049,-18.4405,
    -18.4761,-18.5117,-18.5473,-18.5829,-18.6185,-18.6541,-18.6897,-18.7253,-18.7608,-18.7964,
    -18.8320,-18.8676,-18.9032,-18.9388,-18.9744,-19.0100,-19.0456,-19.0812,-19.1168,-19.1524,
    -19.1880,-19.2236,-19.2592,-19.2948,-19.3304,-19.3660,-19.4016,-19.4372,-19.4727,-19.5083,
    -19.5439,-19.5795,-19.6151,-19.6507,-19.6863,-19.7219,-19.7575,-19.7931,-19.8287,-19.8643,
    -19.8999,-19.9355,-19.9711,-20.0067,-20.0423,-20.0779,-20.1135,-20.1491,-20.1846,-20.2202,
    -20.2558,-20.2914,-20.3270,-20.3626,-20.3982,-20.4338,-20.4694,-20.5050,-20.5406,-20.5762,
    -20.6118,-20.6474,-20.6830,-20.7186,-20.7542,-20.7898,-20.8254,-20.8610,-20.8966,-20.9321,
    -20.9677,-21.0033,-21.0389,-21.0745,-21.1101,-21.1457,-21.1813,-21.2169,-21.2525,-21.2881,
    -21.3237,-21.3593,-21.3949,-21.4305,-21.4661,-21.5017,-21.5373,-21.5729,-21.6085,-21.6440,
    -21.6796,-21.7152,-21.7508,-21.7864,-21.8220,-21.8576,-21.8932,-21.9288,-21.9644,-22.0000

};
const float ref_swing_step[] = {
    -22.0000,-21.7311,-21.4622,-21.1934,-20.9245,-20.6556,-20.3867,-20.1178,-19.8490,-19.5801,
    -19.3112,-19.0423,-18.7734,-18.5046,-18.2357,-17.9668,-17.6979,-17.4290,-17.1604,-16.9047,
    -16.6489,-16.3931,-16.1374,-15.8816,-15.6258,-15.3701,-15.1143,-14.8585,-14.6028,-14.3470,
    -14.0912,-13.8355,-13.5797,-13.3240,-13.0682,-12.8124,-12.5572,-12.3145,-12.0719,-11.8292,
    -11.5866,-11.3439,-11.1013,-10.8587,-10.6160,-10.3734,-10.1307, -9.8881, -9.6454, -9.4028,
    -9.1601, -8.9175, -8.6748, -8.4322, -8.1903, -7.9608, -7.7312, -7.5017, -7.2722, -7.0427,
    -6.8131, -6.5836, -6.3541, -6.1245, -5.8950, -5.6655, -5.4359, -5.2064, -4.9769, -4.7473,
    -4.5178, -4.2883, -4.0598, -3.8434, -3.6270, -3.4105, -3.1941, -2.9777, -2.7613, -2.5449,
    -2.3285, -2.1120, -1.8956, -1.6792, -1.4628, -1.2464, -1.0300, -0.8135, -0.5971, -0.3807,
    -0.1656,  0.0377,  0.2410,  0.4443,  0.6476,  0.8509,  1.0542,  1.2575,  1.4608,  1.6641,
    1.8674,  2.0707,  2.2740,  2.4773,  2.6806,  2.8839,  3.0872,  3.2905,  3.4922,  3.6824,
    3.8726,  4.0628,  4.2529,  4.4431,  4.6333,  4.8235,  5.0137,  5.2039,  5.3940,  5.5842,
    5.7744,  5.9646,  6.1548,  6.3450,  6.5351,  6.7253,  6.9137,  7.0907,  7.2678,  7.4449,
    7.6219,  7.7990,  7.9761,  8.1532,  8.3302,  8.5073,  8.6844,  8.8614,  9.0385,  9.2156,
    9.3926,  9.5697,  9.7468,  9.9238, 10.0988, 10.2627, 10.4267, 10.5906, 10.7546, 10.9186,
    11.0825, 11.2465, 11.4104, 11.5744, 11.7383, 11.9023, 12.0662, 12.2302, 12.3941, 12.5581,
    12.7220, 12.8860, 13.0476, 13.1984, 13.3492, 13.5001, 13.6509, 13.8017, 13.9526, 14.1034,
    14.2542, 14.4051, 14.5559, 14.7067, 14.8576, 15.0084, 15.1593, 15.3101, 15.4609, 15.6118,
    15.7600, 15.8977, 16.0354, 16.1731, 16.3108, 16.4486, 16.5863, 16.7240, 16.8617, 16.9994,
    17.1372, 17.2749, 17.4126, 17.5503, 17.6880, 17.8258, 17.9635, 18.1012, 18.2360, 18.3606,
    18.4852, 18.6098, 18.7344, 18.8590, 18.9836, 19.1083, 19.2329, 19.3575, 19.4821, 19.6067,
    19.7313, 19.8559, 19.9805, 20.1051, 20.2297, 20.3543, 20.4757, 20.5872, 20.6987, 20.8102,
    20.9217, 21.0332, 21.1447, 21.2561, 21.3676, 21.4791, 21.5906, 21.7021, 21.8136, 21.9251,
    22.0366, 22.1480, 22.2595, 22.3710, 22.4791, 22.5775, 22.6758, 22.7742, 22.8726, 22.9709,
    23.0693, 23.1677, 23.2661, 23.3644, 23.4628, 23.5612, 23.6595, 23.7579, 23.8563, 23.9547,
    24.0530, 24.1514, 24.2461, 24.3313, 24.4166, 24.5019, 24.5871, 24.6724, 24.7576, 24.8429,
    24.9281, 25.0134, 25.0986, 25.1839, 25.2692, 25.3544, 25.4397, 25.5249, 25.6102, 25.6954,
    25.7767, 25.8489, 25.9210, 25.9932, 26.0653, 26.1374, 26.2096, 26.2817, 26.3539, 26.4260,
    26.4981, 26.5703, 26.6424, 26.7145, 26.7867, 26.8588, 26.9310, 27.0031, 27.0710, 27.1301,
    27.1891, 27.2481, 27.3071, 27.3662, 27.4252, 27.4842, 27.5432, 27.6022, 27.6613, 27.7203,
    27.7793, 27.8383, 27.8974, 27.9564, 28.0154, 28.0744, 28.1290, 28.1749, 28.2208, 28.2667,
    28.3126, 28.3585, 28.4044, 28.4503, 28.4962, 28.5421, 28.5881, 28.6340, 28.6799, 28.7258,
    28.7717, 28.8176, 28.8635, 28.9094, 28.9506, 28.9834, 29.0162, 29.0490, 29.0817, 29.1145,
    29.1473, 29.1801, 29.2129, 29.2457, 29.2785, 29.3113, 29.3441, 29.3769, 29.4096, 29.4424,
    29.4752, 29.5080, 29.5358, 29.5555, 29.5752, 29.5948, 29.6145, 29.6342, 29.6539, 29.6735,
    29.6932, 29.7129, 29.7326, 29.7522, 29.7719, 29.7916, 29.8113, 29.8309, 29.8506, 29.8703,
    29.8847, 29.8913, 29.8978, 29.9044, 29.9109, 29.9175, 29.9241, 29.9306, 29.9372, 29.9437,
    29.9503, 29.9568, 29.9634, 29.9700, 29.9765, 29.9831, 29.9896, 29.9962, 29.9994, 29.9981,
    29.9968, 29.9955, 29.9942, 29.9928, 29.9915, 29.9902, 29.9889, 29.9875, 29.9862, 29.9849,
    29.9836, 29.9823, 29.9809, 29.9796, 29.9783, 29.9770, 29.9745, 29.9705, 29.9665, 29.9626,
    29.9586, 29.9546, 29.9507, 29.9467, 29.9427, 29.9388, 29.9348, 29.9308, 29.9269, 29.9229,
    29.9189, 29.9150, 29.9110, 29.9070, 29.9018, 29.8952, 29.8886, 29.8820, 29.8754, 29.8688,
    29.8622, 29.8555, 29.8489, 29.8423, 29.8357, 29.8291, 29.8225, 29.8159, 29.8092, 29.8026,
    29.7960, 29.7894, 29.7815, 29.7723, 29.7630, 29.7537, 29.7445, 29.7352, 29.7260, 29.7167,
    29.7075, 29.6982, 29.6889, 29.6797, 29.6704, 29.6612, 29.6519, 29.6426, 29.6334, 29.6241,
    29.6135, 29.6016, 29.5897, 29.5778, 29.5659, 29.5540, 29.5421, 29.5302, 29.5183, 29.5064,
    29.4945, 29.4826, 29.4707, 29.4588, 29.4469, 29.4350, 29.4231, 29.4112, 29.3979, 29.3834,
    29.3688, 29.3543, 29.3397, 29.3252, 29.3106, 29.2961, 29.2815, 29.2670, 29.2524, 29.2379,
    29.2233, 29.2088, 29.1942, 29.1797, 29.1651, 29.1506, 29.1346, 29.1174, 29.1002, 29.0830,
    29.0658, 29.0486, 29.0314, 29.0142, 28.9970, 28.9798, 28.9626, 28.9455, 28.9283, 28.9111,
    28.8939, 28.8767, 28.8595, 28.8423, 28.8236, 28.8038, 28.7839, 28.7641, 28.7443, 28.7244,
    28.7046, 28.6847, 28.6649, 28.6451, 28.6252, 28.6054, 28.5855, 28.5657, 28.5459, 28.5260,
    28.5062, 28.4863, 28.4650, 28.4425, 28.4200, 28.3975, 28.3750, 28.3525, 28.3301, 28.3076,
    28.2851, 28.2626, 28.2401, 28.2176, 28.1951, 28.1727, 28.1502, 28.1277, 28.1052, 28.0827,
    28.0586, 28.0335, 28.0084, 27.9833, 27.9581, 27.9330, 27.9079, 27.8827, 27.8576, 27.8325,
    27.8073, 27.7822, 27.7571, 27.7319, 27.7068, 27.6817, 27.6566, 27.6314, 27.6047, 27.5769,
    27.5491, 27.5213, 27.4936, 27.4658, 27.4380, 27.4102, 27.3825, 27.3547, 27.3269, 27.2991,
    27.2714, 27.2436, 27.2158, 27.1880, 27.1602, 27.1325, 27.1030, 27.0726, 27.0422, 27.0117,
    26.9813, 26.9509, 26.9205, 26.8901, 26.8596, 26.8292, 26.7988, 26.7684, 26.7380, 26.7075,
    26.6771, 26.6467, 26.6163, 26.5858, 26.5537, 26.5206, 26.4875, 26.4545, 26.4214, 26.3884,
    26.3553, 26.3222, 26.2892, 26.2561, 26.2230, 26.1900, 26.1569, 26.1238, 26.0908, 26.0577,
    26.0246, 25.9916, 25.9567, 25.9210, 25.8853, 25.8496, 25.8138, 25.7781, 25.7424, 25.7067,
    25.6710, 25.6353, 25.5996, 25.5639, 25.5282, 25.4924, 25.4567, 25.4210, 25.3853, 25.3496,
    25.3120, 25.2737, 25.2353, 25.1970, 25.1586, 25.1202, 25.0819, 25.0435, 25.0052, 24.9668,
    24.9285, 24.8901, 24.8518, 24.8134, 24.7750, 24.7367, 24.6983, 24.6600, 24.6197, 24.5787,
    24.5377, 24.4967, 24.4557, 24.4147, 24.3737, 24.3327, 24.2917, 24.2507, 24.2097, 24.1687,
    24.1277, 24.0867, 24.0457, 24.0047, 23.9637, 23.9227, 23.8797, 23.8361, 23.7924, 23.7488,
    23.7051, 23.6615, 23.6178, 23.5742, 23.5305, 23.4869, 23.4432, 23.3996, 23.3559, 23.3123,
    23.2686, 23.2250, 23.1814, 23.1377, 23.0920, 23.0458, 22.9995, 22.9532, 22.9069, 22.8606,
    22.8143, 22.7680, 22.7217, 22.6754, 22.6291, 22.5828, 22.5365, 22.4902, 22.4439, 22.3977,
    22.3514, 22.3051, 22.2567, 22.2078, 22.1588, 22.1099, 22.0610, 22.0120, 21.9631, 21.9141,
    21.8652, 21.8163, 21.7673, 21.7184, 21.6695, 21.6205, 21.5716, 21.5226, 21.4737, 21.4248,
    21.3737, 21.3221, 21.2705, 21.2190, 21.1674, 21.1158, 21.0642, 21.0126, 20.9610, 20.9095,
    20.8579, 20.8063, 20.7547, 20.7031, 20.6515, 20.6000, 20.5484, 20.4968, 20.4430, 20.3888,
    20.3346, 20.2804, 20.2261, 20.1719, 20.1177, 20.0634, 20.0092, 19.9550, 19.9008, 19.8465,
    19.7923, 19.7381, 19.6838, 19.6296, 19.5754, 19.5212, 19.4647, 19.4078, 19.3510, 19.2941,
    19.2372, 19.1803, 19.1235, 19.0666, 19.0097, 18.9528, 18.8960, 18.8391, 18.7822, 18.7254,
    18.6685, 18.6116, 18.5547, 18.4979, 18.4387, 18.3792, 18.3197, 18.2601, 18.2006, 18.1411,
    18.0816, 18.0221, 17.9626, 17.9030, 17.8435, 17.7840, 17.7245, 17.6650, 17.6054, 17.5459,
    17.4864, 17.4269, 17.3650, 17.3029, 17.2407, 17.1785, 17.1164, 17.0542, 16.9920, 16.9299,
    16.8677, 16.8056, 16.7434, 16.6812, 16.6191, 16.5569, 16.4947, 16.4326, 16.3704, 16.3082,
    16.2437, 16.1789, 16.1141, 16.0493, 15.9845, 15.9196, 15.8548, 15.7900, 15.7252, 15.6604,
    15.5956, 15.5308, 15.4660, 15.4012, 15.3364, 15.2715, 15.2067, 15.1419, 15.0747, 15.0072,
    14.9398, 14.8723, 14.8049, 14.7374, 14.6700, 14.6025, 14.5350, 14.4676, 14.4001, 14.3327,
    14.2652, 14.1978, 14.1303, 14.0629, 13.9954, 13.9279, 13.8580, 13.7879, 13.7178, 13.6477,
    13.5776, 13.5075, 13.4374, 13.3673, 13.2972, 13.2271, 13.1570, 13.0869, 13.0168, 12.9467,
    12.8766, 12.8065, 12.7364, 12.6663, 12.5937, 12.5209, 12.4482, 12.3754, 12.3027, 12.2299,
    12.1572, 12.0844, 12.0117, 11.9389, 11.8662, 11.7935, 11.7207, 11.6480, 11.5752, 11.5025,
    11.4297, 11.3570, 11.2816, 11.2063, 11.1309, 11.0555, 10.9801, 10.9047, 10.8293, 10.7539,
    10.6785, 10.6031, 10.5277, 10.4523, 10.3770, 10.3016, 10.2262, 10.1508, 10.0754, 10.0000
};

const float ref_stance_step095[]= {
    7.75,7.155,6.56,5.965,5.37,4.775,4.18,3.585,2.99,2.395,1.8,1.205,0.61,0.015,-0.58,-1.175,-1.77,-2.365,-2.96,-3.555,-4.15,-4.745,-5.34,-5.935,-6.53,-7.125,-7.72,-8.315,-8.91,-9.505,-10.1,-10.695,-11.29,-11.885,-12.48,-13.075,-13.67,-14.265,-14.86,-15.455,-16.05,-16.645,-17.24,-17.835,-18.43,-19.025,-19.62,-20.215,-20.81,-21.405,-22,
};
const float ref_stance_step100[]= {
    7,6.42,5.84,5.26,4.68,4.1,3.52,2.94,2.36,1.78,1.2,0.62,0.04,-0.54,-1.12,-1.7,-2.28,-2.86,-3.44,-4.02,-4.6,-5.18,-5.76,-6.34,-6.92,-7.5,-8.08,-8.66,-9.24,-9.82,-10.4,-10.98,-11.56,-12.14,-12.72,-13.3,-13.88,-14.46,-15.04,-15.62,-16.2,-16.78,-17.36,-17.94,-18.52,-19.1,-19.68,-20.26,-20.84,-21.42,-22,
};
const float ref_stance_step105[]= {
    6.25,5.685,5.12,4.555,3.99,3.425,2.86,2.295,1.73,1.165,0.6,0.035,-0.53,-1.095,-1.66,-2.225,-2.79,-3.355,-3.92,-4.485,-5.05,-5.615,-6.18,-6.745,-7.31,-7.875,-8.44,-9.005,-9.57,-10.135,-10.7,-11.265,-11.83,-12.395,-12.96,-13.525,-14.09,-14.655,-15.22,-15.785,-16.35,-16.915,-17.48,-18.045,-18.61,-19.175,-19.74,-20.305,-20.87,-21.435,-22,
};
const float ref_stance_step110[]= {
    5.5,4.95,4.4,3.85,3.3,2.75,2.2,1.65,1.1,0.55,0,-0.55,-1.1,-1.65,-2.2,-2.75,-3.3,-3.85,-4.4,-4.95,-5.5,-6.05,-6.6,-7.15,-7.7,-8.25,-8.8,-9.35,-9.9,-10.45,-11,-11.55,-12.1,-12.65,-13.2,-13.75,-14.3,-14.85,-15.4,-15.95,-16.5,-17.05,-17.6,-18.15,-18.7,-19.25,-19.8,-20.35,-20.9,-21.45,-22,
};
const float ref_stance_step115[]= {
    4.75,4.215,3.68,3.145,2.61,2.075,1.54,1.005,0.47,-0.065,-0.6,-1.135,-1.67,-2.205,-2.74,-3.275,-3.81,-4.345,-4.88,-5.415,-5.95,-6.485,-7.02,-7.555,-8.09,-8.625,-9.16,-9.695,-10.23,-10.765,-11.3,-11.835,-12.37,-12.905,-13.44,-13.975,-14.51,-15.045,-15.58,-16.115,-16.65,-17.185,-17.72,-18.255,-18.79,-19.325,-19.86,-20.395,-20.93,-21.465,-22,
};
const float ref_stance_step120[]= {
    4,3.48,2.96,2.44,1.92,1.4,0.88,0.36,-0.16,-0.68,-1.2,-1.72,-2.24,-2.76,-3.28,-3.8,-4.32,-4.84,-5.36,-5.88,-6.4,-6.92,-7.44,-7.96,-8.48,-9,-9.52,-10.04,-10.56,-11.08,-11.6,-12.12,-12.64,-13.16,-13.68,-14.2,-14.72,-15.24,-15.76,-16.28,-16.8,-17.32,-17.84,-18.36,-18.88,-19.4,-19.92,-20.44,-20.96,-21.48,-22,
};
const float ref_stance_step125[]= {
    3.25,2.745,2.24,1.735,1.23,0.725,0.22,-0.285,-0.79,-1.295,-1.8,-2.305,-2.81,-3.315,-3.82,-4.325,-4.83,-5.335,-5.84,-6.345,-6.85,-7.355,-7.86,-8.365,-8.87,-9.375,-9.88,-10.385,-10.89,-11.395,-11.9,-12.405,-12.91,-13.415,-13.92,-14.425,-14.93,-15.435,-15.94,-16.445,-16.95,-17.455,-17.96,-18.465,-18.97,-19.475,-19.98,-20.485,-20.99,-21.495,-22,
};
const float ref_stance_step130[]= {
    2.5,2.01,1.52,1.03,0.54,0.05,-0.44,-0.93,-1.42,-1.91,-2.4,-2.89,-3.38,-3.87,-4.36,-4.85,-5.34,-5.83,-6.32,-6.81,-7.3,-7.79,-8.28,-8.77,-9.26,-9.75,-10.24,-10.73,-11.22,-11.71,-12.2,-12.69,-13.18,-13.67,-14.16,-14.65,-15.14,-15.63,-16.12,-16.61,-17.1,-17.59,-18.08,-18.57,-19.06,-19.55,-20.04,-20.53,-21.02,-21.51,-22,
};

const float ref_swing_step095[]= {
    -22,-18.75081885,-15.60644999,-12.56689342,-9.632149156,-6.802217183,-4.077097506,-1.456790123,1.058704963,3.469387755,5.775258251,7.976316453,10.07256236,12.06399597,13.95061728,15.7324263,17.40942303,18.98160746,20.44897959,21.81153943,23.06928697,24.22222222,25.27034518,26.21365583,27.0521542,27.78584026,28.41471403,28.93877551,29.35802469,29.67246158,29.88208617,29.98689846,29.98374726,29.85372535,29.59368152,29.20361578,28.68352812,28.03341855,27.25328707,26.34313367,25.30295836,24.13276114,22.832542,21.40230095,19.84203798,18.1517531,16.33144631,14.3811176,12.30076698,10.09039445,7.75,
};
const float ref_swing_step100[]= {
    -22,-18.73270053,-15.57182774,-12.51738166,-9.569362262,-6.72776956,-3.99260355,-1.363864234,1.158448389,3.57433432,5.883793557,8.086826101,10.18343195,12.17361111,14.05736358,15.83468935,17.50558843,19.07006082,20.52810651,21.87972551,23.12491782,24.26368343,25.29602235,26.22193458,27.04142012,27.75447896,28.36111111,28.86131657,29.25509533,29.5424474,29.72337278,29.79787147,29.75871435,29.5909914,29.29425079,28.86849253,28.31371661,27.62992304,26.81711182,25.87528293,24.8044364,23.6045722,22.27569036,20.81779086,19.2308737,17.51493889,15.66998642,13.6960163,11.59302852,9.361023087,7,
};
const float ref_swing_step105[]= {
    -22,-18.71423634,-15.53655701,-12.46696201,-9.505451346,-6.65202501,-3.906683005,-1.269425331,1.259748013,3.680837025,5.993841707,8.198762057,10.29559808,12.28434977,14.16501712,15.93760015,17.60209885,19.15851321,20.60684325,21.94708895,23.17925032,24.30332736,25.31932007,26.22722845,27.0270525,27.71879222,28.30244761,28.77801866,29.14550539,29.40490778,29.55622585,29.59935994,29.52255284,29.31773389,28.9849031,28.52406047,27.935206,27.21833968,26.37346153,25.40057153,24.29966969,23.07075601,21.71383049,20.22889312,18.61594392,16.87498287,15.00600998,13.00902525,10.88402867,8.631020257,6.25,
};
const float ref_swing_step110[]= {
    -22,-18.69541629,-15.50061942,-12.41560938,-9.440386176,-6.574949806,-3.819300269,-1.173437567,1.362638302,3.788927336,6.105429536,8.312144902,10.40907343,12.39621513,14.27356999,16.04113802,17.69891922,19.24691358,20.68512111,22.0135418,23.23217566,24.34102268,25.34008287,26.22935623,27.00884275,27.67854244,28.23845529,28.68858131,29.0289205,29.25947285,29.38023837,29.38983952,29.27553406,29.03422255,28.66590498,28.17058136,27.54825167,26.79891593,25.92257413,24.91922627,23.78887236,22.53151238,21.14714635,19.63577426,17.99739611,16.2320119,14.33962164,12.32022532,10.17382294,7.900414497,5.5,
};
const float ref_swing_step115[]= {
    -22,-18.67623,-15.4639959,-12.36329772,-9.374135433,-6.496509057,-3.730418586,-1.075864022,1.467154636,3.898637388,6.218584235,8.426995175,10.52387021,12.50920934,14.38301256,16.14527987,17.79601128,19.33520679,20.76286639,22.07899008,23.28357786,24.37662974,25.35814572,26.22812578,26.98656994,27.6334782,28.16885055,28.59268699,28.90498753,29.10575216,29.19498088,29.16912958,29.01792754,28.7407238,28.33751836,27.80831122,27.15310237,26.37189183,25.46467958,24.43146564,23.27224999,21.98703265,20.5758136,19.03859285,17.3753704,15.58614625,13.67092041,11.62969285,9.462463604,7.169232652,4.75,
};
const float ref_swing_step120[]= {
    -22,-18.65666667,-15.42666667,-12.31,-9.306666667,-6.416666667,-3.64,-0.976666667,1.573333333,4.01,6.333333333,8.543333333,10.64,12.62333333,14.49333333,16.25,17.89333333,19.42333333,20.84,22.14333333,23.33333333,24.41,25.37333333,26.22333333,26.96,27.58333333,28.09333333,28.49,28.77333333,28.94333333,29,28.9375,28.75,28.4375,28,27.4375,26.75,25.9375,25,23.9375,22.75,21.4375,20,18.4375,16.75,14.9375,13,10.9375,8.75,6.4375,4,
};
const float ref_swing_step125[]= {
    -22,-18.63671507,-15.38861114,-12.2556882,-9.237946241,-6.335385278,-3.548005306,-0.875806324,1.681211668,4.123048669,6.449704679,8.661179698,10.75747373,12.73858677,14.60451881,16.35526987,17.99083994,19.51122901,20.9164371,22.20646419,23.3813103,24.44097541,25.38545953,26.21476267,26.92888481,27.52782596,28.01158612,28.38016529,28.63356347,28.77178066,28.79441991,28.69521828,28.47201461,28.1248089,27.65360116,27.05839137,26.33917955,25.49596569,24.52874979,23.43753185,22.22231187,20.88308986,19.41986581,17.83263971,16.12141158,14.28618142,12.32694921,10.24371497,8.036478682,5.70524036,3.25,
};
const float ref_swing_step130[]= {
    -22,-18.61636355,-15.34980795,-12.20033319,-9.167939285,-6.252626221,-3.454394002,-0.77324263,1.790827896,4.237817576,6.56772641,8.780554399,10.87630154,12.85496784,14.71655329,16.46105789,18.08848165,19.59882456,20.99208663,22.26826785,23.42736823,24.46938776,25.39432644,26.20218428,26.89296127,27.46665741,27.92327271,28.26280716,28.48526077,28.59063353,28.57785842,28.44254878,28.18423037,27.8029032,27.29856725,26.67122255,25.92086907,25.04750683,24.05113583,22.93175606,21.68936752,20.32397021,18.83556414,17.22414931,15.4897257,13.63229334,11.6518522,9.5484023,7.321943633,4.972476199,2.5,
};

const float ref_stance_FS[] = {
    0.0000, -0.0175, -0.0350, -0.0526, -0.0701, -0.0876, -0.1051, -0.1226, -0.1401, -0.1577,
    -0.1752, -0.1927, -0.2102, -0.2277, -0.2452, -0.2628, -0.2803, -0.2978, -0.3153, -0.3328,
    -0.3504, -0.3679, -0.3854, -0.4029, -0.4204, -0.4379, -0.4555, -0.4730, -0.4905, -0.5080,
    -0.5255, -0.5430, -0.5606, -0.5781, -0.5956, -0.6131, -0.6306, -0.6481, -0.6657, -0.6832,
    -0.7007, -0.7182, -0.7357, -0.7533, -0.7708, -0.7883, -0.8058, -0.8233, -0.8408, -0.8584,
    -0.8759, -0.8934, -0.9109, -0.9284, -0.9459, -0.9635, -0.9810, -0.9985, -1.0160, -1.0335,
    -1.0511, -1.0686, -1.0861, -1.1036, -1.1211, -1.1386, -1.1562, -1.1737, -1.1912, -1.2087,
    -1.2262, -1.2437, -1.2613, -1.2788, -1.2963, -1.3138, -1.3313, -1.3488, -1.3664, -1.3839,
    -1.4014, -1.4189, -1.4364, -1.4540, -1.4715, -1.4890, -1.5065, -1.5240, -1.5415, -1.5591,
    -1.5766, -1.5941, -1.6116, -1.6291, -1.6466, -1.6642, -1.6817, -1.6992, -1.7167, -1.7342,
    -1.7518, -1.7693, -1.7869, -1.8045, -1.8220, -1.8396, -1.8572, -1.8747, -1.8923, -1.9099,
    -1.9274, -1.9450, -1.9626, -1.9801, -1.9977, -2.0153, -2.0328, -2.0504, -2.0680, -2.0855,
    -2.1031, -2.1206, -2.1381, -2.1557, -2.1732, -2.1907, -2.2082, -2.2257, -2.2432, -2.2608,
    -2.2783, -2.2958, -2.3133, -2.3308, -2.3483, -2.3659, -2.3834, -2.4009, -2.4184, -2.4359,
    -2.4535, -2.4710, -2.4885, -2.5060, -2.5235, -2.5410, -2.5586, -2.5761, -2.5936, -2.6111,
    -2.6286, -2.6461, -2.6637, -2.6812, -2.6987, -2.7162, -2.7337, -2.7513, -2.7688, -2.7863,
    -2.8038, -2.8213, -2.8388, -2.8564, -2.8739, -2.8914, -2.9089, -2.9264, -2.9439, -2.9615,
    -2.9790, -2.9965, -3.0140, -3.0315, -3.0490, -3.0666, -3.0841, -3.1016, -3.1191, -3.1366,
    -3.1542, -3.1717, -3.1892, -3.2067, -3.2242, -3.2417, -3.2593, -3.2768, -3.2943, -3.3118,
    -3.3293, -3.3468, -3.3644, -3.3819, -3.3994, -3.4169, -3.4344, -3.4520, -3.4695, -3.4870,
    -3.5045, -3.5220, -3.5395, -3.5571, -3.5746, -3.5921, -3.6096, -3.6271, -3.6446, -3.6622,
    -3.6797, -3.6972, -3.7147, -3.7322, -3.7497, -3.7673, -3.7848, -3.8023, -3.8198, -3.8373,
    -3.8549, -3.8724, -3.8899, -3.9074, -3.9249, -3.9424, -3.9600, -3.9775, -3.9950, -4.0125,
    -4.0300, -4.0475, -4.0651, -4.0826, -4.1001, -4.1176, -4.1351, -4.1527, -4.1702, -4.1877,
    -4.2052, -4.2227, -4.2402, -4.2578, -4.2753, -4.2928, -4.3103, -4.3278, -4.3453, -4.3629,
    -4.3804, -4.3979, -4.4154, -4.4329, -4.4504, -4.4680, -4.4855, -4.5030, -4.5205, -4.5380,
    -4.5556, -4.5731, -4.5906, -4.6081, -4.6256, -4.6431, -4.6607, -4.6782, -4.6957, -4.7132,
    -4.7307, -4.7482, -4.7658, -4.7833, -4.8008, -4.8183, -4.8358, -4.8534, -4.8709, -4.8884,
    -4.9059, -4.9234, -4.9409, -4.9585, -4.9760, -4.9935, -5.0110, -5.0285, -5.0460, -5.0636,
    -5.0811, -5.0986, -5.1161, -5.1336, -5.1512, -5.1687, -5.1862, -5.2037, -5.2212, -5.2387,
    -5.2563, -5.2738, -5.2914, -5.3090, -5.3265, -5.3441, -5.3617, -5.3792, -5.3968, -5.4144,
    -5.4319, -5.4495, -5.4671, -5.4846, -5.5022, -5.5198, -5.5374, -5.5549, -5.5725, -5.5901,
    -5.6076, -5.6251, -5.6426, -5.6602, -5.6777, -5.6952, -5.7127, -5.7302, -5.7477, -5.7653,
    -5.7828, -5.8003, -5.8178, -5.8353, -5.8529, -5.8704, -5.8879, -5.9054, -5.9229, -5.9404,
    -5.9580, -5.9755, -5.9930, -6.0105, -6.0280, -6.0455, -6.0631, -6.0806, -6.0981, -6.1156,
    -6.1331, -6.1506, -6.1682, -6.1857, -6.2032, -6.2207, -6.2382, -6.2558, -6.2733, -6.2908,
    -6.3083, -6.3258, -6.3433, -6.3609, -6.3784, -6.3959, -6.4134, -6.4309, -6.4484, -6.4660,
    -6.4835, -6.5010, -6.5185, -6.5360, -6.5536, -6.5711, -6.5886, -6.6061, -6.6236, -6.6411,
    -6.6587, -6.6762, -6.6937, -6.7112, -6.7287, -6.7462, -6.7638, -6.7813, -6.7988, -6.8163,
    -6.8338, -6.8513, -6.8689, -6.8864, -6.9039, -6.9214, -6.9389, -6.9565, -6.9740, -6.9915,
    -7.0090, -7.0265, -7.0440, -7.0616, -7.0791, -7.0966, -7.1141, -7.1316, -7.1491, -7.1667,
    -7.1842, -7.2017, -7.2192, -7.2367, -7.2543, -7.2718, -7.2893, -7.3068, -7.3243, -7.3418,
    -7.3594, -7.3769, -7.3944, -7.4119, -7.4294, -7.4469, -7.4645, -7.4820, -7.4995, -7.5170,
    -7.5345, -7.5521, -7.5696, -7.5871, -7.6046, -7.6221, -7.6396, -7.6572, -7.6747, -7.6922,
    -7.7097, -7.7272, -7.7447, -7.7623, -7.7798, -7.7973, -7.8148, -7.8323, -7.8498, -7.8674,
    -7.8849, -7.9024, -7.9199, -7.9374, -7.9550, -7.9725, -7.9900, -8.0075, -8.0250, -8.0425,
    -8.0601, -8.0776, -8.0951, -8.1126, -8.1301, -8.1476, -8.1652, -8.1827, -8.2002, -8.2177,
    -8.2352, -8.2528, -8.2703, -8.2878, -8.3053, -8.3228, -8.3403, -8.3579, -8.3754, -8.3929,
    -8.4104, -8.4279, -8.4454, -8.4630, -8.4805, -8.4980, -8.5155, -8.5330, -8.5505, -8.5681,
    -8.5856, -8.6031, -8.6206, -8.6381, -8.6557, -8.6732, -8.6907, -8.7082, -8.7257, -8.7432,
    -8.7608, -8.7783, -8.7958, -8.8133, -8.8308, -8.8483, -8.8659, -8.8834, -8.9009, -8.9184,
    -8.9359, -8.9535, -8.9710, -8.9885, -9.0060, -9.0235, -9.0410, -9.0586, -9.0761, -9.0936,
    -9.1111, -9.1287, -9.1463, -9.1638, -9.1814, -9.1990, -9.2165, -9.2341, -9.2517, -9.2692,
    -9.2868, -9.3044, -9.3219, -9.3395, -9.3571, -9.3746, -9.3922, -9.4098, -9.4274, -9.4449,
    -9.4625, -9.4800, -9.4975, -9.5150, -9.5325, -9.5500, -9.5676, -9.5851, -9.6026, -9.6201,
    -9.6376, -9.6552, -9.6727, -9.6902, -9.7077, -9.7252, -9.7427, -9.7603, -9.7778, -9.7953,
    -9.8128, -9.8303, -9.8478, -9.8654, -9.8829, -9.9004, -9.9179, -9.9354, -9.9529, -9.9705,
    -9.9880,-10.0055,-10.0230,-10.0405,-10.0581,-10.0756,-10.0931,-10.1106,-10.1281,-10.1456,
    -10.1632,-10.1807,-10.1982,-10.2157,-10.2332,-10.2507,-10.2683,-10.2858,-10.3033,-10.3208,
    -10.3383,-10.3559,-10.3734,-10.3909,-10.4084,-10.4259,-10.4434,-10.4610,-10.4785,-10.4960,
    -10.5135,-10.5310,-10.5485,-10.5661,-10.5836,-10.6011,-10.6186,-10.6361,-10.6537,-10.6712,
    -10.6887,-10.7062,-10.7237,-10.7412,-10.7588,-10.7763,-10.7938,-10.8113,-10.8288,-10.8463,
    -10.8639,-10.8814,-10.8989,-10.9164,-10.9339,-10.9514,-10.9690,-10.9865,-11.0040,-11.0215,
    -11.0390,-11.0566,-11.0741,-11.0916,-11.1091,-11.1266,-11.1441,-11.1617,-11.1792,-11.1967,
    -11.2142,-11.2317,-11.2492,-11.2668,-11.2843,-11.3018,-11.3193,-11.3368,-11.3544,-11.3719,
    -11.3894,-11.4069,-11.4244,-11.4419,-11.4595,-11.4770,-11.4945,-11.5120,-11.5295,-11.5470,
    -11.5646,-11.5821,-11.5996,-11.6171,-11.6346,-11.6521,-11.6697,-11.6872,-11.7047,-11.7222,
    -11.7397,-11.7573,-11.7748,-11.7923,-11.8098,-11.8273,-11.8448,-11.8624,-11.8799,-11.8974,
    -11.9149,-11.9324,-11.9499,-11.9675,-11.9850,-12.0025,-12.0200,-12.0375,-12.0551,-12.0726,
    -12.0901,-12.1076,-12.1251,-12.1426,-12.1602,-12.1777,-12.1952,-12.2127,-12.2302,-12.2477,
    -12.2653,-12.2828,-12.3003,-12.3178,-12.3353,-12.3528,-12.3704,-12.3879,-12.4054,-12.4229,
    -12.4404,-12.4580,-12.4755,-12.4930,-12.5105,-12.5280,-12.5455,-12.5631,-12.5806,-12.5981,
    -12.6156,-12.6332,-12.6508,-12.6684,-12.6859,-12.7035,-12.7211,-12.7386,-12.7562,-12.7738,
    -12.7913,-12.8089,-12.8265,-12.8440,-12.8616,-12.8792,-12.8967,-12.9143,-12.9319,-12.9494,
    -12.9670,-12.9845,-13.0020,-13.0195,-13.0370,-13.0546,-13.0721,-13.0896,-13.1071,-13.1246,
    -13.1421,-13.1597,-13.1772,-13.1947,-13.2122,-13.2297,-13.2472,-13.2648,-13.2823,-13.2998,
    -13.3173,-13.3348,-13.3523,-13.3699,-13.3874,-13.4049,-13.4224,-13.4399,-13.4575,-13.4750,
    -13.4925,-13.5100,-13.5275,-13.5450,-13.5626,-13.5801,-13.5976,-13.6151,-13.6326,-13.6501,
    -13.6677,-13.6852,-13.7027,-13.7202,-13.7377,-13.7553,-13.7728,-13.7903,-13.8078,-13.8253,
    -13.8428,-13.8604,-13.8779,-13.8954,-13.9129,-13.9304,-13.9479,-13.9655,-13.9830,-14.0005,
    -14.0180,-14.0355,-14.0530,-14.0706,-14.0881,-14.1056,-14.1231,-14.1406,-14.1582,-14.1757,
    -14.1932,-14.2107,-14.2282,-14.2457,-14.2633,-14.2808,-14.2983,-14.3158,-14.3333,-14.3508,
    -14.3684,-14.3859,-14.4034,-14.4209,-14.4384,-14.4560,-14.4735,-14.4910,-14.5085,-14.5260,
    -14.5435,-14.5611,-14.5786,-14.5961,-14.6136,-14.6311,-14.6486,-14.6662,-14.6837,-14.7012,
    -14.7187,-14.7362,-14.7537,-14.7713,-14.7888,-14.8063,-14.8238,-14.8413,-14.8589,-14.8764,
    -14.8939,-14.9114,-14.9289,-14.9464,-14.9640,-14.9815,-14.9990,-15.0165,-15.0340,-15.0515,
    -15.0691,-15.0866,-15.1041,-15.1216,-15.1391,-15.1567,-15.1742,-15.1917,-15.2092,-15.2267,
    -15.2442,-15.2618,-15.2793,-15.2968,-15.3143,-15.3318,-15.3493,-15.3669,-15.3844,-15.4019,
    -15.4194,-15.4369,-15.4545,-15.4720,-15.4895,-15.5070,-15.5245,-15.5420,-15.5596,-15.5771,
    -15.5946,-15.6121,-15.6296,-15.6471,-15.6647,-15.6822,-15.6997,-15.7172,-15.7347,-15.7522,
    -15.7698,-15.7873,-15.8048,-15.8223,-15.8398,-15.8574,-15.8749,-15.8924,-15.9099,-15.9274,
    -15.9449,-15.9625,-15.9800,-15.9975,-16.0150,-16.0325,-16.0500,-16.0676,-16.0851,-16.1026,
    -16.1202,-16.1377,-16.1553,-16.1729,-16.1904,-16.2080,-16.2256,-16.2431,-16.2607,-16.2783,
    -16.2958,-16.3134,-16.3310,-16.3485,-16.3661,-16.3837,-16.4012,-16.4188,-16.4364,-16.4539,
    -16.4715,-16.4890,-16.5065,-16.5240,-16.5415,-16.5591,-16.5766,-16.5941,-16.6116,-16.6291,
    -16.6466,-16.6642,-16.6817,-16.6992,-16.7167,-16.7342,-16.7517,-16.7693,-16.7868,-16.8043,
    -16.8218,-16.8393,-16.8569,-16.8744,-16.8919,-16.9094,-16.9269,-16.9444,-16.9620,-16.9795,
    -16.9970,-17.0145,-17.0320,-17.0495,-17.0671,-17.0846,-17.1021,-17.1196,-17.1371,-17.1546,
    -17.1722,-17.1897,-17.2072,-17.2247,-17.2422,-17.2598,-17.2773,-17.2948,-17.3123,-17.3298,
    -17.3473,-17.3649,-17.3824,-17.3999,-17.4174,-17.4349,-17.4524,-17.4700,-17.4875,-17.5050
};

const float ref_swing_FS[] = {
    0.0000,  0.0880,  0.1760,  0.2640,  0.3520,  0.4399,  0.5279,  0.6159,  0.7039,  0.7919,
    0.8799,  0.9679,  1.0559,  1.1438,  1.2318,  1.3198,  1.4078,  1.4958,  1.5838,  1.6718,
    1.7598,  1.8474,  1.9350,  2.0227,  2.1103,  2.1979,  2.2856,  2.3732,  2.4609,  2.5485,
    2.6361,  2.7238,  2.8114,  2.8990,  2.9867,  3.0743,  3.1620,  3.2496,  3.3372,  3.4249,
    3.5125,  3.5995,  3.6865,  3.7734,  3.8604,  3.9474,  4.0344,  4.1214,  4.2084,  4.2954,
    4.3823,  4.4693,  4.5563,  4.6433,  4.7303,  4.8173,  4.9043,  4.9913,  5.0782,  5.1652,
    5.2522,  5.3380,  5.4239,  5.5098,  5.5957,  5.6816,  5.7675,  5.8534,  5.9392,  6.0251,
    6.1110,  6.1969,  6.2828,  6.3687,  6.4546,  6.5404,  6.6263,  6.7122,  6.7981,  6.8840,
    6.9698,  7.0543,  7.1388,  7.2234,  7.3079,  7.3924,  7.4770,  7.5615,  7.6460,  7.7306,
    7.8151,  7.8996,  7.9842,  8.0687,  8.1532,  8.2378,  8.3223,  8.4068,  8.4914,  8.5759,
    8.6603,  8.7431,  8.8259,  8.9088,  8.9916,  9.0744,  9.1573,  9.2401,  9.3229,  9.4058,
    9.4886,  9.5714,  9.6543,  9.7371,  9.8199,  9.9028,  9.9856, 10.0684, 10.1513, 10.2341,
    10.3167, 10.3975, 10.4784, 10.5592, 10.6400, 10.7209, 10.8017, 10.8825, 10.9633, 11.0442,
    11.1250, 11.2058, 11.2867, 11.3675, 11.4483, 11.5292, 11.6100, 11.6908, 11.7717, 11.8525,
    11.9330, 12.0114, 12.0898, 12.1683, 12.2467, 12.3251, 12.4036, 12.4820, 12.5604, 12.6388,
    12.7173, 12.7957, 12.8741, 12.9525, 13.0310, 13.1094, 13.1878, 13.2663, 13.3447, 13.4231,
    13.5011, 13.5769, 13.6527, 13.7285, 13.8042, 13.8800, 13.9558, 14.0316, 14.1073, 14.1831,
    14.2589, 14.3347, 14.4104, 14.4862, 14.5620, 14.6378, 14.7135, 14.7893, 14.8651, 14.9409,
    15.0161, 15.0889, 15.1618, 15.2346, 15.3074, 15.3802, 15.4530, 15.5259, 15.5987, 15.6715,
    15.7443, 15.8172, 15.8900, 15.9628, 16.0356, 16.1085, 16.1813, 16.2541, 16.3269, 16.3997,
    16.4719, 16.5415, 16.6111, 16.6806, 16.7502, 16.8198, 16.8893, 16.9589, 17.0285, 17.0980,
    17.1676, 17.2372, 17.3067, 17.3763, 17.4459, 17.5155, 17.5850, 17.6546, 17.7242, 17.7937,
    17.8625, 17.9285, 17.9946, 18.0606, 18.1266, 18.1926, 18.2586, 18.3246, 18.3907, 18.4567,
    18.5227, 18.5887, 18.6547, 18.7207, 18.7867, 18.8528, 18.9188, 18.9848, 19.0508, 19.1168,
    19.1819, 19.2442, 19.3065, 19.3687, 19.4310, 19.4933, 19.5555, 19.6178, 19.6800, 19.7423,
    19.8046, 19.8668, 19.9291, 19.9914, 20.0536, 20.1159, 20.1781, 20.2404, 20.3027, 20.3649,
    20.4261, 20.4843, 20.5426, 20.6008, 20.6590, 20.7172, 20.7754, 20.8336, 20.8918, 20.9500,
    21.0082, 21.0664, 21.1246, 21.1828, 21.2410, 21.2993, 21.3575, 21.4157, 21.4739, 21.5321,
    21.5891, 21.6431, 21.6970, 21.7510, 21.8049, 21.8589, 21.9128, 21.9668, 22.0207, 22.0747,
    22.1286, 22.1826, 22.2366, 22.2905, 22.3445, 22.3984, 22.4524, 22.5063, 22.5603, 22.6142,
    22.6668, 22.7163, 22.7658, 22.8153, 22.8648, 22.9143, 22.9638, 23.0133, 23.0628, 23.1123,
    23.1618, 23.2113, 23.2608, 23.3103, 23.3598, 23.4093, 23.4588, 23.5083, 23.5578, 23.6073,
    23.6554, 23.7002, 23.7450, 23.7899, 23.8347, 23.8796, 23.9244, 23.9693, 24.0141, 24.0590,
    24.1038, 24.1486, 24.1935, 24.2383, 24.2832, 24.3280, 24.3729, 24.4177, 24.4626, 24.5074,
    24.5506, 24.5905, 24.6305, 24.6704, 24.7103, 24.7503, 24.7902, 24.8302, 24.8701, 24.9100,
    24.9500, 24.9899, 25.0299, 25.0698, 25.1097, 25.1497, 25.1896, 25.2296, 25.2695, 25.3094,
    25.3476, 25.3826, 25.4176, 25.4525, 25.4875, 25.5225, 25.5575, 25.5925, 25.6275, 25.6625,
    25.6974, 25.7324, 25.7674, 25.8024, 25.8374, 25.8724, 25.9074, 25.9423, 25.9773, 26.0123,
    26.0453, 26.0752, 26.1050, 26.1348, 26.1647, 26.1945, 26.2243, 26.2541, 26.2840, 26.3138,
    26.3436, 26.3735, 26.4033, 26.4331, 26.4630, 26.4928, 26.5226, 26.5524, 26.5823, 26.6121,
    26.6398, 26.6643, 26.6889, 26.7134, 26.7379, 26.7624, 26.7870, 26.8115, 26.8360, 26.8605,
    26.8851, 26.9096, 26.9341, 26.9586, 26.9832, 27.0077, 27.0322, 27.0567, 27.0813, 27.1058,
    27.1281, 27.1473, 27.1665, 27.1857, 27.2049, 27.2242, 27.2434, 27.2626, 27.2818, 27.3010,
    27.3203, 27.3395, 27.3587, 27.3779, 27.3971, 27.4164, 27.4356, 27.4548, 27.4740, 27.4932,
    27.5101, 27.5238, 27.5376, 27.5513, 27.5651, 27.5789, 27.5926, 27.6064, 27.6202, 27.6339,
    27.6477, 27.6615, 27.6752, 27.6890, 27.7027, 27.7165, 27.7303, 27.7440, 27.7578, 27.7716,
    27.7828, 27.7911, 27.7994, 27.8077, 27.8161, 27.8244, 27.8327, 27.8410, 27.8493, 27.8576,
    27.8659, 27.8742, 27.8825, 27.8908, 27.8991, 27.9074, 27.9158, 27.9241, 27.9324, 27.9407,
    27.9463, 27.9491, 27.9518, 27.9546, 27.9573, 27.9601, 27.9628, 27.9656, 27.9683, 27.9711,
    27.9738, 27.9766, 27.9794, 27.9821, 27.9849, 27.9876, 27.9904, 27.9931, 27.9959, 27.9986,
    27.9986, 27.9959, 27.9931, 27.9904, 27.9876, 27.9849, 27.9821, 27.9794, 27.9766, 27.9738,
    27.9711, 27.9683, 27.9656, 27.9628, 27.9601, 27.9573, 27.9546, 27.9518, 27.9491, 27.9463,
    27.9407, 27.9324, 27.9241, 27.9158, 27.9074, 27.8991, 27.8908, 27.8825, 27.8742, 27.8659,
    27.8576, 27.8493, 27.8410, 27.8327, 27.8244, 27.8161, 27.8077, 27.7994, 27.7911, 27.7828,
    27.7716, 27.7578, 27.7440, 27.7303, 27.7165, 27.7027, 27.6890, 27.6752, 27.6615, 27.6477,
    27.6339, 27.6202, 27.6064, 27.5926, 27.5789, 27.5651, 27.5513, 27.5376, 27.5238, 27.5101,
    27.4932, 27.4740, 27.4548, 27.4356, 27.4164, 27.3971, 27.3779, 27.3587, 27.3395, 27.3203,
    27.3010, 27.2818, 27.2626, 27.2434, 27.2242, 27.2049, 27.1857, 27.1665, 27.1473, 27.1281,
    27.1058, 27.0813, 27.0567, 27.0322, 27.0077, 26.9832, 26.9586, 26.9341, 26.9096, 26.8851,
    26.8605, 26.8360, 26.8115, 26.7870, 26.7624, 26.7379, 26.7134, 26.6889, 26.6643, 26.6398,
    26.6121, 26.5823, 26.5524, 26.5226, 26.4928, 26.4630, 26.4331, 26.4033, 26.3735, 26.3436,
    26.3138, 26.2840, 26.2541, 26.2243, 26.1945, 26.1647, 26.1348, 26.1050, 26.0752, 26.0453,
    26.0123, 25.9773, 25.9423, 25.9074, 25.8724, 25.8374, 25.8024, 25.7674, 25.7324, 25.6974,
    25.6625, 25.6275, 25.5925, 25.5575, 25.5225, 25.4875, 25.4525, 25.4176, 25.3826, 25.3476,
    25.3094, 25.2695, 25.2296, 25.1896, 25.1497, 25.1097, 25.0698, 25.0299, 24.9899, 24.9500,
    24.9100, 24.8701, 24.8302, 24.7902, 24.7503, 24.7103, 24.6704, 24.6305, 24.5905, 24.5506,
    24.5074, 24.4626, 24.4177, 24.3729, 24.3280, 24.2832, 24.2383, 24.1935, 24.1486, 24.1038,
    24.0590, 24.0141, 23.9693, 23.9244, 23.8796, 23.8347, 23.7899, 23.7450, 23.7002, 23.6554,
    23.6073, 23.5578, 23.5083, 23.4588, 23.4093, 23.3598, 23.3103, 23.2608, 23.2113, 23.1618,
    23.1123, 23.0628, 23.0133, 22.9638, 22.9143, 22.8648, 22.8153, 22.7658, 22.7163, 22.6668,
    22.6142, 22.5603, 22.5063, 22.4524, 22.3984, 22.3445, 22.2905, 22.2366, 22.1826, 22.1286,
    22.0747, 22.0207, 21.9668, 21.9128, 21.8589, 21.8049, 21.7510, 21.6970, 21.6431, 21.5891,
    21.5321, 21.4739, 21.4157, 21.3575, 21.2993, 21.2410, 21.1828, 21.1246, 21.0664, 21.0082,
    20.9500, 20.8918, 20.8336, 20.7754, 20.7172, 20.6590, 20.6008, 20.5426, 20.4843, 20.4261,
    20.3649, 20.3027, 20.2404, 20.1781, 20.1159, 20.0536, 19.9914, 19.9291, 19.8668, 19.8046,
    19.7423, 19.6800, 19.6178, 19.5555, 19.4933, 19.4310, 19.3687, 19.3065, 19.2442, 19.1819,
    19.1168, 19.0508, 18.9848, 18.9188, 18.8528, 18.7867, 18.7207, 18.6547, 18.5887, 18.5227,
    18.4567, 18.3907, 18.3246, 18.2586, 18.1926, 18.1266, 18.0606, 17.9946, 17.9285, 17.8625,
    17.7937, 17.7242, 17.6546, 17.5850, 17.5155, 17.4459, 17.3763, 17.3067, 17.2372, 17.1676,
    17.0980, 17.0285, 16.9589, 16.8893, 16.8198, 16.7502, 16.6806, 16.6111, 16.5415, 16.4719,
    16.3997, 16.3269, 16.2541, 16.1813, 16.1085, 16.0356, 15.9628, 15.8900, 15.8172, 15.7443,
    15.6715, 15.5987, 15.5259, 15.4530, 15.3802, 15.3074, 15.2346, 15.1618, 15.0889, 15.0161,
    14.9409, 14.8651, 14.7893, 14.7135, 14.6378, 14.5620, 14.4862, 14.4104, 14.3347, 14.2589,
    14.1831, 14.1073, 14.0316, 13.9558, 13.8800, 13.8042, 13.7285, 13.6527, 13.5769, 13.5011,
    13.4231, 13.3447, 13.2663, 13.1878, 13.1094, 13.0310, 12.9525, 12.8741, 12.7957, 12.7173,
    12.6388, 12.5604, 12.4820, 12.4036, 12.3251, 12.2467, 12.1683, 12.0898, 12.0114, 11.9330,
    11.8525, 11.7717, 11.6908, 11.6100, 11.5292, 11.4483, 11.3675, 11.2867, 11.2058, 11.1250,
    11.0442, 10.9633, 10.8825, 10.8017, 10.7209, 10.6400, 10.5592, 10.4784, 10.3975, 10.3167,
    10.2341, 10.1513, 10.0684,  9.9856,  9.9028,  9.8199,  9.7371,  9.6543,  9.5714,  9.4886,
    9.4058,  9.3229,  9.2401,  9.1573,  9.0744,  8.9916,  8.9088,  8.8259,  8.7431,  8.6603,
    8.5759,  8.4914,  8.4068,  8.3223,  8.2378,  8.1532,  8.0687,  7.9842,  7.8996,  7.8151,
    7.7306,  7.6460,  7.5615,  7.4770,  7.3924,  7.3079,  7.2234,  7.1388,  7.0543,  6.9698,
    6.8840,  6.7981,  6.7122,  6.6263,  6.5404,  6.4546,  6.3687,  6.2828,  6.1969,  6.1110,
    6.0251,  5.9392,  5.8534,  5.7675,  5.6816,  5.5957,  5.5098,  5.4239,  5.3380,  5.2522,
    5.1652,  5.0782,  4.9913,  4.9043,  4.8173,  4.7303,  4.6433,  4.5563,  4.4693,  4.3823,
    4.2954,  4.2084,  4.1214,  4.0344,  3.9474,  3.8604,  3.7734,  3.6865,  3.5995,  3.5125,
    3.4249,  3.3372,  3.2496,  3.1620,  3.0743,  2.9867,  2.8990,  2.8114,  2.7238,  2.6361,
    2.5485,  2.4609,  2.3732,  2.2856,  2.1979,  2.1103,  2.0227,  1.9350,  1.8474,  1.7598,
    1.6718,  1.5838,  1.4958,  1.4078,  1.3198,  1.2318,  1.1438,  1.0559,  0.9679,  0.8799,
    0.7919,  0.7039,  0.6159,  0.5279,  0.4399,  0.3520,  0.2640,  0.1760,  0.0880,  0.0000

};

const float ref_stance_FTG[] = {
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,
    0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000,  0.0000

};

const float ref_swing_FTG[] = {
    -17.5050,-17.4699,-17.4349,-17.3998,-17.3647,-17.3296,-17.2946,-17.2595,-17.2244,-17.1894,
    -17.1543,-17.1192,-17.0842,-17.0491,-17.0140,-16.9789,-16.9439,-16.9088,-16.8737,-16.8387,
    -16.8036,-16.7685,-16.7335,-16.6984,-16.6633,-16.6282,-16.5932,-16.5581,-16.5230,-16.4880,
    -16.4529,-16.4177,-16.3825,-16.3474,-16.3122,-16.2770,-16.2419,-16.2067,-16.1715,-16.1364,
    -16.1012,-16.0661,-16.0311,-15.9960,-15.9609,-15.9258,-15.8908,-15.8557,-15.8206,-15.7856,
    -15.7505,-15.7154,-15.6804,-15.6453,-15.6102,-15.5751,-15.5401,-15.5050,-15.4699,-15.4349,
    -15.3998,-15.3647,-15.3297,-15.2946,-15.2595,-15.2244,-15.1894,-15.1543,-15.1192,-15.0842,
    -15.0491,-15.0140,-14.9789,-14.9439,-14.9088,-14.8737,-14.8387,-14.8036,-14.7685,-14.7335,
    -14.6984,-14.6633,-14.6282,-14.5932,-14.5581,-14.5230,-14.4880,-14.4529,-14.4178,-14.3828,
    -14.3477,-14.3126,-14.2775,-14.2425,-14.2074,-14.1723,-14.1373,-14.1022,-14.0671,-14.0321,
    -13.9970,-13.9619,-13.9268,-13.8918,-13.8567,-13.8216,-13.7866,-13.7515,-13.7164,-13.6814,
    -13.6463,-13.6112,-13.5761,-13.5411,-13.5060,-13.4709,-13.4359,-13.4008,-13.3657,-13.3307,
    -13.2956,-13.2605,-13.2254,-13.1904,-13.1553,-13.1202,-13.0852,-13.0501,-13.0150,-12.9800,
    -12.9449,-12.9097,-12.8745,-12.8393,-12.8042,-12.7690,-12.7338,-12.6987,-12.6635,-12.6283,
    -12.5932,-12.5581,-12.5230,-12.4880,-12.4529,-12.4178,-12.3828,-12.3477,-12.3126,-12.2775,
    -12.2425,-12.2074,-12.1723,-12.1373,-12.1022,-12.0671,-12.0321,-11.9970,-11.9619,-11.9268,
    -11.8918,-11.8567,-11.8216,-11.7866,-11.7515,-11.7164,-11.6814,-11.6463,-11.6112,-11.5761,
    -11.5411,-11.5060,-11.4709,-11.4359,-11.4008,-11.3657,-11.3307,-11.2956,-11.2605,-11.2254,
    -11.1904,-11.1553,-11.1202,-11.0852,-11.0501,-11.0150,-10.9800,-10.9449,-10.9098,-10.8747,
    -10.8397,-10.8046,-10.7695,-10.7345,-10.6994,-10.6643,-10.6293,-10.5942,-10.5591,-10.5240,
    -10.4890,-10.4539,-10.4188,-10.3838,-10.3487,-10.3136,-10.2786,-10.2435,-10.2084,-10.1733,
    -10.1383,-10.1032,-10.0681,-10.0331, -9.9980, -9.9629, -9.9278, -9.8928, -9.8577, -9.8226,
    -9.7876, -9.7525, -9.7174, -9.6824, -9.6473, -9.6122, -9.5771, -9.5421, -9.5070, -9.4719,
    -9.4368, -9.4017, -9.3665, -9.3313, -9.2961, -9.2610, -9.2258, -9.1906, -9.1555, -9.1203,
    -9.0852, -9.0501, -9.0150, -8.9800, -8.9449, -8.9098, -8.8747, -8.8397, -8.8046, -8.7695,
    -8.7345, -8.6994, -8.6643, -8.6293, -8.5942, -8.5591, -8.5240, -8.4890, -8.4539, -8.4188,
    -8.3838, -8.3487, -8.3136, -8.2786, -8.2435, -8.2084, -8.1733, -8.1383, -8.1032, -8.0681,
    -8.0331, -7.9980, -7.9629, -7.9279, -7.8928, -7.8577, -7.8226, -7.7876, -7.7525, -7.7174,
    -7.6824, -7.6473, -7.6122, -7.5772, -7.5421, -7.5070, -7.4719, -7.4369, -7.4018, -7.3667,
    -7.3317, -7.2966, -7.2615, -7.2264, -7.1914, -7.1563, -7.1212, -7.0862, -7.0511, -7.0160,
    -6.9810, -6.9459, -6.9108, -6.8757, -6.8407, -6.8056, -6.7705, -6.7355, -6.7004, -6.6653,
    -6.6303, -6.5952, -6.5601, -6.5250, -6.4900, -6.4549, -6.4198, -6.3848, -6.3497, -6.3146,
    -6.2796, -6.2445, -6.2094, -6.1743, -6.1393, -6.1042, -6.0691, -6.0341, -5.9990, -5.9639,
    -5.9289, -5.8938, -5.8587, -5.8236, -5.7886, -5.7535, -5.7184, -5.6834, -5.6483, -5.6132,
    -5.5781, -5.5429, -5.5077, -5.4726, -5.4374, -5.4022, -5.3671, -5.3319, -5.2967, -5.2616,
    -5.2265, -5.1914, -5.1563, -5.1212, -5.0862, -5.0511, -5.0160, -4.9810, -4.9459, -4.9108,
    -4.8757, -4.8407, -4.8056, -4.7705, -4.7355, -4.7004, -4.6653, -4.6303, -4.5952, -4.5601,
    -4.5250, -4.4900, -4.4549, -4.4198, -4.3848, -4.3497, -4.3146, -4.2796, -4.2445, -4.2094,
    -4.1743, -4.1393, -4.1042, -4.0691, -4.0341, -3.9990, -3.9639, -3.9289, -3.8938, -3.8587,
    -3.8236, -3.7886, -3.7535, -3.7184, -3.6834, -3.6483, -3.6132, -3.5782, -3.5431, -3.5080,
    -3.4729, -3.4379, -3.4028, -3.3677, -3.3327, -3.2976, -3.2625, -3.2275, -3.1924, -3.1573,
    -3.1222, -3.0872, -3.0521, -3.0170, -2.9820, -2.9469, -2.9118, -2.8768, -2.8417, -2.8066,
    -2.7715, -2.7365, -2.7014, -2.6663, -2.6313, -2.5962, -2.5611, -2.5261, -2.4910, -2.4559,
    -2.4208, -2.3858, -2.3507, -2.3156, -2.2806, -2.2455, -2.2104, -2.1753, -2.1403, -2.1052,
    -2.0701, -2.0349, -1.9997, -1.9645, -1.9294, -1.8942, -1.8590, -1.8239, -1.7887, -1.7535,
    -1.7184, -1.6834, -1.6483, -1.6132, -1.5782, -1.5431, -1.5080, -1.4729, -1.4379, -1.4028,
    -1.3677, -1.3327, -1.2976, -1.2625, -1.2275, -1.1924, -1.1573, -1.1222, -1.0872, -1.0521,
    -1.0170, -0.9820, -0.9469, -0.9118, -0.8768, -0.8417, -0.8066, -0.7715, -0.7365, -0.7014,
    -0.6663, -0.6313, -0.5962, -0.5611, -0.5261, -0.4910, -0.4559, -0.4208, -0.3858, -0.3507,
    -0.3156, -0.2806, -0.2455, -0.2104, -0.1754, -0.1403, -0.1052, -0.0701, -0.0351,  0.0000

};

/*const float ref_sit2stand[] = {
    115.0000,114.9990,114.9981,114.9971,114.9962,114.9952,114.9943,114.9933,114.9924,114.9914,
    114.9905,114.9895,114.9886,114.9876,114.9867,114.9857,114.9848,114.9838,114.9829,114.9819,
    114.9810,114.9800,114.9791,114.9781,114.9772,114.9762,114.9753,114.9743,114.9734,114.9724,
    114.9715,114.9705,114.9696,114.9686,114.9677,114.9667,114.9658,114.9648,114.9639,114.9629,
    114.9620,114.9610,114.9601,114.9591,114.9582,114.9572,114.9563,114.9553,114.9544,114.9534,
    114.9525,114.9515,114.9506,114.9496,114.9487,114.9477,114.9468,114.9458,114.9449,114.9439,
    114.9429,114.9401,114.9373,114.9344,114.9316,114.9288,114.9259,114.9231,114.9203,114.9174,
    114.9146,114.9118,114.9089,114.9061,114.9033,114.9004,114.8976,114.8948,114.8919,114.8891,
    114.8863,114.8834,114.8806,114.8778,114.8749,114.8721,114.8693,114.8664,114.8636,114.8607,
    114.8579,114.8551,114.8522,114.8494,114.8466,114.8437,114.8409,114.8381,114.8352,114.8324,
    114.8296,114.8267,114.8239,114.8211,114.8182,114.8154,114.8126,114.8097,114.8069,114.8041,
    114.8012,114.7984,114.7956,114.7927,114.7899,114.7871,114.7842,114.7814,114.7786,114.7757,
    114.7728,114.7681,114.7634,114.7587,114.7539,114.7492,114.7445,114.7398,114.7351,114.7303,
    114.7256,114.7209,114.7162,114.7115,114.7068,114.7020,114.6973,114.6926,114.6879,114.6832,
    114.6784,114.6737,114.6690,114.6643,114.6596,114.6549,114.6501,114.6454,114.6407,114.6360,
    114.6313,114.6265,114.6218,114.6171,114.6124,114.6077,114.6030,114.5982,114.5935,114.5888,
    114.5841,114.5794,114.5746,114.5699,114.5652,114.5605,114.5558,114.5511,114.5463,114.5416,
    114.5369,114.5322,114.5275,114.5227,114.5180,114.5133,114.5086,114.5039,114.4992,114.4944,
    114.4896,114.4830,114.4764,114.4698,114.4632,114.4566,114.4500,114.4434,114.4368,114.4302,
    114.4236,114.4170,114.4104,114.4038,114.3972,114.3906,114.3840,114.3774,114.3708,114.3642,
    114.3576,114.3510,114.3444,114.3378,114.3312,114.3245,114.3179,114.3113,114.3047,114.2981,
    114.2915,114.2849,114.2783,114.2717,114.2651,114.2585,114.2519,114.2453,114.2387,114.2321,
    114.2255,114.2189,114.2123,114.2057,114.1991,114.1925,114.1859,114.1793,114.1727,114.1661,
    114.1595,114.1529,114.1463,114.1397,114.1331,114.1265,114.1199,114.1133,114.1067,114.1001,
    114.0933,114.0849,114.0764,114.0679,114.0594,114.0510,114.0425,114.0340,114.0256,114.0171,
    114.0086,114.0002,113.9917,113.9832,113.9747,113.9663,113.9578,113.9493,113.9409,113.9324,
    113.9239,113.9155,113.9070,113.8985,113.8901,113.8816,113.8731,113.8646,113.8562,113.8477,
    113.8392,113.8308,113.8223,113.8138,113.8054,113.7969,113.7884,113.7800,113.7715,113.7630,
    113.7545,113.7461,113.7376,113.7291,113.7207,113.7122,113.7037,113.6953,113.6868,113.6783,
    113.6698,113.6614,113.6529,113.6444,113.6360,113.6275,113.6190,113.6106,113.6021,113.5936,
    113.5850,113.5746,113.5643,113.5539,113.5436,113.5332,113.5228,113.5125,113.5021,113.4918,
    113.4814,113.4711,113.4607,113.4504,113.4400,113.4297,113.4193,113.4090,113.3986,113.3882,
    113.3779,113.3675,113.3572,113.3468,113.3365,113.3261,113.3158,113.3054,113.2951,113.2847,
    113.2744,113.2640,113.2537,113.2433,113.2329,113.2226,113.2122,113.2019,113.1915,113.1812,
    113.1708,113.1605,113.1501,113.1398,113.1294,113.1191,113.1087,113.0984,113.0880,113.0776,
    113.0673,113.0569,113.0466,113.0362,113.0259,113.0155,113.0052,112.9948,112.9845,112.9741,
    112.9635,112.9513,112.9391,112.9269,112.9147,112.9025,112.8903,112.8781,112.8659,112.8537,
    112.8415,112.8293,112.8171,112.8049,112.7927,112.7805,112.7683,112.7561,112.7439,112.7317,
    112.7195,112.7073,112.6950,112.6828,112.6706,112.6584,112.6462,112.6340,112.6218,112.6096,
    112.5974,112.5852,112.5730,112.5608,112.5486,112.5364,112.5242,112.5120,112.4998,112.4876,
    112.4754,112.4632,112.4510,112.4388,112.4266,112.4144,112.4021,112.3899,112.3777,112.3655,
    112.3533,112.3411,112.3289,112.3167,112.3045,112.2923,112.2801,112.2679,112.2557,112.2435,
    112.2310,112.2170,112.2030,112.1889,112.1749,112.1608,112.1468,112.1328,112.1187,112.1047,
    112.0907,112.0766,112.0626,112.0485,112.0345,112.0205,112.0064,111.9924,111.9784,111.9643,
    111.9503,111.9362,111.9222,111.9082,111.8941,111.8801,111.8660,111.8520,111.8380,111.8239,
    111.8099,111.7959,111.7818,111.7678,111.7537,111.7397,111.7257,111.7116,111.6976,111.6836,
    111.6695,111.6555,111.6414,111.6274,111.6134,111.5993,111.5853,111.5712,111.5572,111.5432,
    111.5291,111.5151,111.5011,111.4870,111.4730,111.4589,111.4449,111.4309,111.4168,111.4028,
    111.3885,111.3726,111.3567,111.3408,111.3249,111.3090,111.2931,111.2772,111.2613,111.2455,
    111.2296,111.2137,111.1978,111.1819,111.1660,111.1501,111.1342,111.1184,111.1025,111.0866,
    111.0707,111.0548,111.0389,111.0230,111.0071,110.9912,110.9754,110.9595,110.9436,110.9277,
    110.9118,110.8959,110.8800,110.8641,110.8482,110.8324,110.8165,110.8006,110.7847,110.7688,
    110.7529,110.7370,110.7211,110.7052,110.6894,110.6735,110.6576,110.6417,110.6258,110.6099,
    110.5940,110.5781,110.5622,110.5464,110.5305,110.5146,110.4987,110.4828,110.4669,110.4510,
    110.4348,110.4171,110.3994,110.3817,110.3641,110.3464,110.3287,110.3110,110.2933,110.2756,
    110.2579,110.2402,110.2225,110.2049,110.1872,110.1695,110.1518,110.1341,110.1164,110.0987,
    110.0810,110.0633,110.0457,110.0280,110.0103,109.9926,109.9749,109.9572,109.9395,109.9218,
    109.9041,109.8864,109.8688,109.8511,109.8334,109.8157,109.7980,109.7803,109.7626,109.7449,
    109.7272,109.7096,109.6919,109.6742,109.6565,109.6388,109.6211,109.6034,109.5857,109.5680,
    109.5504,109.5327,109.5150,109.4973,109.4796,109.4619,109.4442,109.4265,109.4088,109.3912,
    109.3731,109.3536,109.3341,109.3146,109.2951,109.2757,109.2562,109.2367,109.2172,109.1977,
    109.1782,109.1587,109.1392,109.1197,109.1002,109.0808,109.0613,109.0418,109.0223,109.0028,
    108.9833,108.9638,108.9443,108.9248,108.9053,108.8859,108.8664,108.8469,108.8274,108.8079,
    108.7884,108.7689,108.7494,108.7299,108.7104,108.6910,108.6715,108.6520,108.6325,108.6130,
    108.5935,108.5740,108.5545,108.5350,108.5155,108.4961,108.4766,108.4571,108.4376,108.4181,
    108.3986,108.3791,108.3596,108.3401,108.3207,108.3012,108.2817,108.2622,108.2427,108.2232,
    108.2033,108.1820,108.1608,108.1395,108.1182,108.0970,108.0757,108.0544,108.0331,108.0119,
    107.9906,107.9693,107.9480,107.9268,107.9055,107.8842,107.8629,107.8417,107.8204,107.7991,
    107.7778,107.7566,107.7353,107.7140,107.6927,107.6715,107.6502,107.6289,107.6077,107.5864,
    107.5651,107.5438,107.5226,107.5013,107.4800,107.4587,107.4375,107.4162,107.3949,107.3736,
    107.3524,107.3311,107.3098,107.2885,107.2673,107.2460,107.2247,107.2035,107.1822,107.1609,
    107.1396,107.1184,107.0971,107.0758,107.0545,107.0333,107.0120,106.9907,106.9694,106.9482,
    106.9265,106.9034,106.8804,106.8574,106.8344,106.8114,106.7883,106.7653,106.7423,106.7193,
    106.6962,106.6732,106.6502,106.6272,106.6041,106.5811,106.5581,106.5351,106.5120,106.4890,
    106.4660,106.4430,106.4199,106.3969,106.3739,106.3509,106.3278,106.3048,106.2818,106.2588,
    106.2357,106.2127,106.1897,106.1667,106.1436,106.1206,106.0976,106.0746,106.0515,106.0285,
    106.0055,105.9825,105.9595,105.9364,105.9134,105.8904,105.8674,105.8443,105.8213,105.7983,
    105.7753,105.7522,105.7292,105.7062,105.6832,105.6601,105.6371,105.6141,105.5911,105.5680,
    105.5446,105.5198,105.4950,105.4703,105.4455,105.4208,105.3960,105.3713,105.3465,105.3217,
    105.2970,105.2722,105.2475,105.2227,105.1979,105.1732,105.1484,105.1237,105.0989,105.0742,
    105.0494,105.0246,104.9999,104.9751,104.9504,104.9256,104.9008,104.8761,104.8513,104.8266,
    104.8018,104.7771,104.7523,104.7275,104.7028,104.6780,104.6533,104.6285,104.6037,104.5790,
    104.5542,104.5295,104.5047,104.4800,104.4552,104.4304,104.4057,104.3809,104.3562,104.3314,
    104.3067,104.2819,104.2571,104.2324,104.2076,104.1829,104.1581,104.1333,104.1086,104.0838,
    104.0586,104.0321,104.0056,103.9792,103.9527,103.9262,103.8997,103.8733,103.8468,103.8203,
    103.7938,103.7674,103.7409,103.7144,103.6879,103.6615,103.6350,103.6085,103.5820,103.5556,
    103.5291,103.5026,103.4761,103.4497,103.4232,103.3967,103.3702,103.3437,103.3173,103.2908,
    103.2643,103.2378,103.2114,103.1849,103.1584,103.1319,103.1055,103.0790,103.0525,103.0260,
    102.9996,102.9731,102.9466,102.9201,102.8937,102.8672,102.8407,102.8142,102.7878,102.7613,
    102.7348,102.7083,102.6819,102.6554,102.6289,102.6024,102.5760,102.5495,102.5230,102.4965,
    102.4696,102.4414,102.4132,102.3851,102.3569,102.3288,102.3006,102.2724,102.2443,102.2161,
    102.1880,102.1598,102.1316,102.1035,102.0753,102.0472,102.0190,101.9908,101.9627,101.9345,
    101.9064,101.8782,101.8500,101.8219,101.7937,101.7656,101.7374,101.7092,101.6811,101.6529,
    101.6248,101.5966,101.5685,101.5403,101.5121,101.4840,101.4558,101.4277,101.3995,101.3713,
    101.3432,101.3150,101.2869,101.2587,101.2305,101.2024,101.1742,101.1461,101.1179,101.0897,
    101.0616,101.0334,101.0053,100.9771,100.9489,100.9208,100.8926,100.8645,100.8363,100.8081,
    100.7795,100.7497,100.7198,100.6900,100.6602,100.6304,100.6006,100.5708,100.5410,100.5112,
    100.4814,100.4516,100.4217,100.3919,100.3621,100.3323,100.3025,100.2727,100.2429,100.2131,
    100.1833,100.1535,100.1236,100.0938,100.0640,100.0342,100.0044, 99.9746, 99.9448, 99.9150,
    99.8852, 99.8554, 99.8255, 99.7957, 99.7659, 99.7361, 99.7063, 99.6765, 99.6467, 99.6169,
    99.5871, 99.5573, 99.5274, 99.4976, 99.4678, 99.4380, 99.4082, 99.3784, 99.3486, 99.3188,
    99.2890, 99.2592, 99.2293, 99.1995, 99.1697, 99.1399, 99.1101, 99.0803, 99.0505, 99.0207,
    98.9903, 98.9589, 98.9274, 98.8960, 98.8645, 98.8331, 98.8016, 98.7702, 98.7388, 98.7073,
    98.6759, 98.6444, 98.6130, 98.5815, 98.5501, 98.5187, 98.4872, 98.4558, 98.4243, 98.3929,
    98.3614, 98.3300, 98.2985, 98.2671, 98.2357, 98.2042, 98.1728, 98.1413, 98.1099, 98.0784,
    98.0470, 98.0156, 97.9841, 97.9527, 97.9212, 97.8898, 97.8583, 97.8269, 97.7954, 97.7640,
    97.7326, 97.7011, 97.6697, 97.6382, 97.6068, 97.5753, 97.5439, 97.5124, 97.4810, 97.4496,
    97.4181, 97.3867, 97.3552, 97.3238, 97.2923, 97.2609, 97.2295, 97.1980, 97.1666, 97.1351,
    97.1031, 97.0701, 97.0371, 97.0040, 96.9710, 96.9380, 96.9049, 96.8719, 96.8389, 96.8059,
    96.7728, 96.7398, 96.7068, 96.6738, 96.6407, 96.6077, 96.5747, 96.5416, 96.5086, 96.4756,
    96.4426, 96.4095, 96.3765, 96.3435, 96.3104, 96.2774, 96.2444, 96.2114, 96.1783, 96.1453,
    96.1123, 96.0793, 96.0462, 96.0132, 95.9802, 95.9471, 95.9141, 95.8811, 95.8481, 95.8150,
    95.7820, 95.7490, 95.7159, 95.6829, 95.6499, 95.6169, 95.5838, 95.5508, 95.5178, 95.4848,
    95.4517, 95.4187, 95.3857, 95.3526, 95.3196, 95.2866, 95.2536, 95.2205, 95.1875, 95.1545,
    95.1208, 95.0862, 95.0516, 95.0170, 94.9824, 94.9478, 94.9132, 94.8786, 94.8440, 94.8093,
    94.7747, 94.7401, 94.7055, 94.6709, 94.6363, 94.6017, 94.5671, 94.5325, 94.4978, 94.4632,
    94.4286, 94.3940, 94.3594, 94.3248, 94.2902, 94.2556, 94.2209, 94.1863, 94.1517, 94.1171,
    94.0825, 94.0479, 94.0133, 93.9787, 93.9441, 93.9094, 93.8748, 93.8402, 93.8056, 93.7710,
    93.7364, 93.7018, 93.6672, 93.6326, 93.5979, 93.5633, 93.5287, 93.4941, 93.4595, 93.4249,
    93.3903, 93.3557, 93.3210, 93.2864, 93.2518, 93.2172, 93.1826, 93.1480, 93.1134, 93.0788,
    93.0435, 93.0074, 92.9713, 92.9352, 92.8990, 92.8629, 92.8268, 92.7906, 92.7545, 92.7184,
    92.6823, 92.6461, 92.6100, 92.5739, 92.5377, 92.5016, 92.4655, 92.4294, 92.3932, 92.3571,
    92.3210, 92.2848, 92.2487, 92.2126, 92.1765, 92.1403, 92.1042, 92.0681, 92.0319, 91.9958,
    91.9597, 91.9236, 91.8874, 91.8513, 91.8152, 91.7790, 91.7429, 91.7068, 91.6707, 91.6345,
    91.5984, 91.5623, 91.5261, 91.4900, 91.4539, 91.4178, 91.3816, 91.3455, 91.3094, 91.2732,
    91.2371, 91.2010, 91.1649, 91.1287, 91.0926, 91.0565, 91.0203, 90.9842, 90.9481, 90.9120,
    90.8752, 90.8376, 90.8000, 90.7624, 90.7248, 90.6871, 90.6495, 90.6119, 90.5743, 90.5367,
    90.4991, 90.4615, 90.4239, 90.3862, 90.3486, 90.3110, 90.2734, 90.2358, 90.1982, 90.1606,
    90.1230, 90.0853, 90.0477, 90.0101, 89.9725, 89.9349, 89.8973, 89.8597, 89.8221, 89.7844,
    89.7468, 89.7092, 89.6716, 89.6340, 89.5964, 89.5588, 89.5212, 89.4835, 89.4459, 89.4083,
    89.3707, 89.3331, 89.2955, 89.2579, 89.2203, 89.1826, 89.1450, 89.1074, 89.0698, 89.0322,
    88.9946, 88.9570, 88.9194, 88.8817, 88.8441, 88.8065, 88.7689, 88.7313, 88.6937, 88.6561,
    88.6178, 88.5787, 88.5396, 88.5006, 88.4615, 88.4224, 88.3833, 88.3442, 88.3052, 88.2661,
    88.2270, 88.1879, 88.1488, 88.1098, 88.0707, 88.0316, 87.9925, 87.9535, 87.9144, 87.8753,
    87.8362, 87.7971, 87.7581, 87.7190, 87.6799, 87.6408, 87.6017, 87.5627, 87.5236, 87.4845,
    87.4454, 87.4063, 87.3673, 87.3282, 87.2891, 87.2500, 87.2109, 87.1719, 87.1328, 87.0937,
    87.0546, 87.0155, 86.9765, 86.9374, 86.8983, 86.8592, 86.8201, 86.7811, 86.7420, 86.7029,
    86.6638, 86.6247, 86.5857, 86.5466, 86.5075, 86.4684, 86.4293, 86.3903, 86.3512, 86.3121,
    86.2724, 86.2319, 86.1913, 86.1508, 86.1103, 86.0698, 86.0293, 85.9888, 85.9483, 85.9077,
    85.8672, 85.8267, 85.7862, 85.7457, 85.7052, 85.6647, 85.6241, 85.5836, 85.5431, 85.5026,
    85.4621, 85.4216, 85.3811, 85.3406, 85.3000, 85.2595, 85.2190, 85.1785, 85.1380, 85.0975,
    85.0570, 85.0164, 84.9759, 84.9354, 84.8949, 84.8544, 84.8139, 84.7734, 84.7329, 84.6923,
    84.6518, 84.6113, 84.5708, 84.5303, 84.4898, 84.4493, 84.4087, 84.3682, 84.3277, 84.2872,
    84.2467, 84.2062, 84.1657, 84.1251, 84.0846, 84.0441, 84.0036, 83.9631, 83.9226, 83.8821,
    83.8409, 83.7990, 83.7572, 83.7153, 83.6734, 83.6316, 83.5897, 83.5479, 83.5060, 83.4641,
    83.4223, 83.3804, 83.3385, 83.2967, 83.2548, 83.2129, 83.1711, 83.1292, 83.0874, 83.0455,
    83.0036, 82.9618, 82.9199, 82.8780, 82.8362, 82.7943, 82.7524, 82.7106, 82.6687, 82.6269,
    82.5850, 82.5431, 82.5013, 82.4594, 82.4175, 82.3757, 82.3338, 82.2919, 82.2501, 82.2082,
    82.1663, 82.1245, 82.0826, 82.0408, 81.9989, 81.9570, 81.9152, 81.8733, 81.8314, 81.7896,
    81.7477, 81.7058, 81.6640, 81.6221, 81.5803, 81.5384, 81.4965, 81.4547, 81.4128, 81.3709,
    81.3284, 81.2852, 81.2420, 81.1987, 81.1555, 81.1123, 81.0691, 81.0259, 80.9827, 80.9395,
    80.8962, 80.8530, 80.8098, 80.7666, 80.7234, 80.6802, 80.6370, 80.5937, 80.5505, 80.5073,
    80.4641, 80.4209, 80.3777, 80.3345, 80.2912, 80.2480, 80.2048, 80.1616, 80.1184, 80.0752,
    80.0320, 79.9887, 79.9455, 79.9023, 79.8591, 79.8159, 79.7727, 79.7295, 79.6862, 79.6430,
    79.5998, 79.5566, 79.5134, 79.4702, 79.4270, 79.3837, 79.3405, 79.2973, 79.2541, 79.2109,
    79.1677, 79.1245, 79.0812, 79.0380, 78.9948, 78.9516, 78.9084, 78.8652, 78.8220, 78.7787,
    78.7349, 78.6903, 78.6458, 78.6013, 78.5568, 78.5123, 78.4678, 78.4232, 78.3787, 78.3342,
    78.2897, 78.2452, 78.2007, 78.1562, 78.1116, 78.0671, 78.0226, 77.9781, 77.9336, 77.8891,
    77.8446, 77.8000, 77.7555, 77.7110, 77.6665, 77.6220, 77.5775, 77.5330, 77.4884, 77.4439,
    77.3994, 77.3549, 77.3104, 77.2659, 77.2213, 77.1768, 77.1323, 77.0878, 77.0433, 76.9988,
    76.9543, 76.9097, 76.8652, 76.8207, 76.7762, 76.7317, 76.6872, 76.6427, 76.5981, 76.5536,
    76.5091, 76.4646, 76.4201, 76.3756, 76.3311, 76.2865, 76.2420, 76.1975, 76.1530, 76.1085,
    76.0633, 76.0175, 75.9718, 75.9260, 75.8802, 75.8345, 75.7887, 75.7429, 75.6972, 75.6514,
    75.6056, 75.5599, 75.5141, 75.4683, 75.4226, 75.3768, 75.3310, 75.2853, 75.2395, 75.1937,
    75.1480, 75.1022, 75.0565, 75.0107, 74.9649, 74.9192, 74.8734, 74.8276, 74.7819, 74.7361,
    74.6903, 74.6446, 74.5988, 74.5530, 74.5073, 74.4615, 74.4157, 74.3700, 74.3242, 74.2784,
    74.2327, 74.1869, 74.1411, 74.0954, 74.0496, 74.0039, 73.9581, 73.9123, 73.8666, 73.8208,
    73.7750, 73.7293, 73.6835, 73.6377, 73.5920, 73.5462, 73.5004, 73.4547, 73.4089, 73.3631,
    73.3167, 73.2697, 73.2228, 73.1758, 73.1288, 73.0819, 73.0349, 72.9879, 72.9410, 72.8940,
    72.8470, 72.8001, 72.7531, 72.7061, 72.6592, 72.6122, 72.5652, 72.5183, 72.4713, 72.4244,
    72.3774, 72.3304, 72.2835, 72.2365, 72.1895, 72.1426, 72.0956, 72.0486, 72.0017, 71.9547,
    71.9077, 71.8608, 71.8138, 71.7668, 71.7199, 71.6729, 71.6259, 71.5790, 71.5320, 71.4850,
    71.4381, 71.3911, 71.3441, 71.2972, 71.2502, 71.2032, 71.1563, 71.1093, 71.0623, 71.0154,
    70.9684, 70.9215, 70.8745, 70.8275, 70.7806, 70.7336, 70.6866, 70.6397, 70.5927, 70.5457,
    70.4981, 70.4500, 70.4019, 70.3537, 70.3056, 70.2575, 70.2094, 70.1613, 70.1132, 70.0650,
    70.0169, 69.9688, 69.9207, 69.8726, 69.8245, 69.7764, 69.7282, 69.6801, 69.6320, 69.5839,
    69.5358, 69.4877, 69.4395, 69.3914, 69.3433, 69.2952, 69.2471, 69.1990, 69.1508, 69.1027,
    69.0546, 69.0065, 68.9584, 68.9103, 68.8621, 68.8140, 68.7659, 68.7178, 68.6697, 68.6216,
    68.5735, 68.5253, 68.4772, 68.4291, 68.3810, 68.3329, 68.2848, 68.2366, 68.1885, 68.1404,
    68.0923, 68.0442, 67.9961, 67.9479, 67.8998, 67.8517, 67.8036, 67.7555, 67.7074, 67.6592,
    67.6105, 67.5612, 67.5120, 67.4628, 67.4135, 67.3643, 67.3151, 67.2658, 67.2166, 67.1674,
    67.1181, 67.0689, 67.0197, 66.9704, 66.9212, 66.8720, 66.8227, 66.7735, 66.7243, 66.6750,
    66.6258, 66.5766, 66.5273, 66.4781, 66.4289, 66.3796, 66.3304, 66.2812, 66.2319, 66.1827,
    66.1335, 66.0842, 66.0350, 65.9858, 65.9365, 65.8873, 65.8381, 65.7888, 65.7396, 65.6904,
    65.6411, 65.5919, 65.5427, 65.4934, 65.4442, 65.3950, 65.3457, 65.2965, 65.2473, 65.1980,
    65.1488, 65.0996, 65.0503, 65.0011, 64.9519, 64.9026, 64.8534, 64.8042, 64.7549, 64.7057,
    64.6558, 64.6055, 64.5552, 64.5049, 64.4546, 64.4043, 64.3540, 64.3037, 64.2534, 64.2031,
    64.1528, 64.1025, 64.0522, 64.0019, 63.9516, 63.9013, 63.8510, 63.8007, 63.7504, 63.7001,
    63.6498, 63.5995, 63.5492, 63.4989, 63.4486, 63.3983, 63.3480, 63.2977, 63.2474, 63.1971,
    63.1468, 63.0965, 63.0462, 62.9959, 62.9456, 62.8953, 62.8450, 62.7947, 62.7444, 62.6941,
    62.6438, 62.5935, 62.5432, 62.4929, 62.4426, 62.3923, 62.3420, 62.2917, 62.2414, 62.1911,
    62.1408, 62.0905, 62.0402, 61.9899, 61.9396, 61.8893, 61.8390, 61.7887, 61.7384, 61.6881,
    61.6372, 61.5858, 61.5345, 61.4832, 61.4319, 61.3806, 61.3293, 61.2779, 61.2266, 61.1753,
    61.1240, 61.0727, 61.0214, 60.9700, 60.9187, 60.8674, 60.8161, 60.7648, 60.7134, 60.6621,
    60.6108, 60.5595, 60.5082, 60.4569, 60.4055, 60.3542, 60.3029, 60.2516, 60.2003, 60.1490,
    60.0976, 60.0463, 59.9950, 59.9437, 59.8924, 59.8411, 59.7897, 59.7384, 59.6871, 59.6358,
    59.5845, 59.5332, 59.4818, 59.4305, 59.3792, 59.3279, 59.2766, 59.2253, 59.1739, 59.1226,
    59.0713, 59.0200, 58.9687, 58.9174, 58.8660, 58.8147, 58.7634, 58.7121, 58.6608, 58.6094,
    58.5575, 58.5052, 58.4529, 58.4006, 58.3484, 58.2961, 58.2438, 58.1915, 58.1392, 58.0869,
    58.0347, 57.9824, 57.9301, 57.8778, 57.8255, 57.7732, 57.7209, 57.6687, 57.6164, 57.5641,
    57.5118, 57.4595, 57.4072, 57.3550, 57.3027, 57.2504, 57.1981, 57.1458, 57.0935, 57.0413,
    56.9890, 56.9367, 56.8844, 56.8321, 56.7798, 56.7275, 56.6753, 56.6230, 56.5707, 56.5184,
    56.4661, 56.4138, 56.3616, 56.3093, 56.2570, 56.2047, 56.1524, 56.1001, 56.0479, 55.9956,
    55.9433, 55.8910, 55.8387, 55.7864, 55.7342, 55.6819, 55.6296, 55.5773, 55.5250, 55.4727,
    55.4198, 55.3667, 55.3135, 55.2603, 55.2071, 55.1539, 55.1007, 55.0475, 54.9944, 54.9412,
    54.8880, 54.8348, 54.7816, 54.7284, 54.6753, 54.6221, 54.5689, 54.5157, 54.4625, 54.4093,
    54.3561, 54.3030, 54.2498, 54.1966, 54.1434, 54.0902, 54.0370, 53.9839, 53.9307, 53.8775,
    53.8243, 53.7711, 53.7179, 53.6647, 53.6116, 53.5584, 53.5052, 53.4520, 53.3988, 53.3456,
    53.2925, 53.2393, 53.1861, 53.1329, 53.0797, 53.0265, 52.9734, 52.9202, 52.8670, 52.8138,
    52.7606, 52.7074, 52.6542, 52.6011, 52.5479, 52.4947, 52.4415, 52.3883, 52.3351, 52.2820,
    52.2282, 52.1741, 52.1201, 52.0660, 52.0120, 51.9579, 51.9039, 51.8498, 51.7958, 51.7417,
    51.6877, 51.6336, 51.5795, 51.5255, 51.4714, 51.4174, 51.3633, 51.3093, 51.2552, 51.2012,
    51.1471, 51.0931, 51.0390, 50.9850, 50.9309, 50.8769, 50.8228, 50.7688, 50.7147, 50.6607,
    50.6066, 50.5526, 50.4985, 50.4445, 50.3904, 50.3364, 50.2823, 50.2283, 50.1742, 50.1202,
    50.0661, 50.0121, 49.9580, 49.9040, 49.8499, 49.7959, 49.7418, 49.6878, 49.6337, 49.5796,
    49.5256, 49.4715, 49.4175, 49.3634, 49.3094, 49.2553, 49.2013, 49.1472, 49.0932, 49.0391,
    48.9845, 48.9297, 48.8748, 48.8200, 48.7651, 48.7102, 48.6554, 48.6005, 48.5457, 48.4908,
    48.4360, 48.3811, 48.3263, 48.2714, 48.2166, 48.1617, 48.1069, 48.0520, 47.9972, 47.9423,
    47.8875, 47.8326, 47.7778, 47.7229, 47.6681, 47.6132, 47.5584, 47.5035, 47.4487, 47.3938,
    47.3390, 47.2841, 47.2293, 47.1744, 47.1196, 47.0647, 47.0098, 46.9550, 46.9001, 46.8453,
    46.7904, 46.7356, 46.6807, 46.6259, 46.5710, 46.5162, 46.4613, 46.4065, 46.3516, 46.2968,
    46.2419, 46.1871, 46.1322, 46.0774, 46.0225, 45.9677, 45.9128, 45.8580, 45.8031, 45.7483,
    45.6929, 45.6373, 45.5817, 45.5260, 45.4704, 45.4148, 45.3592, 45.3036, 45.2480, 45.1924,
    45.1368, 45.0812, 45.0256, 44.9700, 44.9144, 44.8588, 44.8032, 44.7476, 44.6920, 44.6364,
    44.5808, 44.5252, 44.4696, 44.4140, 44.3584, 44.3028, 44.2472, 44.1916, 44.1360, 44.0804,
    44.0248, 43.9692, 43.9136, 43.8580, 43.8024, 43.7468, 43.6912, 43.6356, 43.5800, 43.5244,
    43.4688, 43.4132, 43.3576, 43.3020, 43.2464, 43.1908, 43.1352, 43.0796, 43.0240, 42.9684,
    42.9128, 42.8572, 42.8016, 42.7460, 42.6904, 42.6348, 42.5792, 42.5235, 42.4679, 42.4123,
    42.3562, 42.2999, 42.2436, 42.1873, 42.1310, 42.0747, 42.0184, 41.9621, 41.9058, 41.8495,
    41.7932, 41.7369, 41.6806, 41.6243, 41.5680, 41.5117, 41.4554, 41.3991, 41.3428, 41.2865,
    41.2302, 41.1739, 41.1176, 41.0613, 41.0050, 40.9487, 40.8924, 40.8361, 40.7798, 40.7234,
    40.6671, 40.6108, 40.5545, 40.4982, 40.4419, 40.3856, 40.3293, 40.2730, 40.2167, 40.1604,
    40.1041, 40.0478, 39.9915, 39.9352, 39.8789, 39.8226, 39.7663, 39.7100, 39.6537, 39.5974,
    39.5411, 39.4848, 39.4285, 39.3722, 39.3159, 39.2596, 39.2033, 39.1470, 39.0907, 39.0344,
    38.9776, 38.9207, 38.8637, 38.8068, 38.7498, 38.6929, 38.6360, 38.5790, 38.5221, 38.4652,
    38.4082, 38.3513, 38.2944, 38.2374, 38.1805, 38.1236, 38.0666, 38.0097, 37.9527, 37.8958,
    37.8389, 37.7819, 37.7250, 37.6681, 37.6111, 37.5542, 37.4973, 37.4403, 37.3834, 37.3265,
    37.2695, 37.2126, 37.1556, 37.0987, 37.0418, 36.9848, 36.9279, 36.8710, 36.8140, 36.7571,
    36.7002, 36.6432, 36.5863, 36.5294, 36.4724, 36.4155, 36.3586, 36.3016, 36.2447, 36.1877,
    36.1308, 36.0739, 36.0169, 35.9600, 35.9031, 35.8461, 35.7892, 35.7323, 35.6753, 35.6184,
    35.5610, 35.5034, 35.4459, 35.3884, 35.3308, 35.2733, 35.2158, 35.1582, 35.1007, 35.0431,
    34.9856, 34.9281, 34.8705, 34.8130, 34.7555, 34.6979, 34.6404, 34.5829, 34.5253, 34.4678,
    34.4103, 34.3527, 34.2952, 34.2376, 34.1801, 34.1226, 34.0650, 34.0075, 33.9500, 33.8924,
    33.8349, 33.7774, 33.7198, 33.6623, 33.6048, 33.5472, 33.4897, 33.4321, 33.3746, 33.3171,
    33.2595, 33.2020, 33.1445, 33.0869, 33.0294, 32.9719, 32.9143, 32.8568, 32.7993, 32.7417,
    32.6842, 32.6266, 32.5691, 32.5116, 32.4540, 32.3965, 32.3390, 32.2814, 32.2239, 32.1664,
    32.1084, 32.0503, 31.9923, 31.9342, 31.8762, 31.8181, 31.7601, 31.7020, 31.6440, 31.5859,
    31.5279, 31.4698, 31.4118, 31.3537, 31.2957, 31.2376, 31.1796, 31.1215, 31.0634, 31.0054,
    30.9473, 30.8893, 30.8312, 30.7732, 30.7151, 30.6571, 30.5990, 30.5410, 30.4829, 30.4249,
    30.3668, 30.3088, 30.2507, 30.1927, 30.1346, 30.0766, 30.0185, 29.9604, 29.9024, 29.8443,
    29.7863, 29.7282, 29.6702, 29.6121, 29.5541, 29.4960, 29.4380, 29.3799, 29.3219, 29.2638,
    29.2058, 29.1477, 29.0897, 29.0316, 28.9736, 28.9155, 28.8574, 28.7994, 28.7413, 28.6833,
    28.6248, 28.5663, 28.5078, 28.4492, 28.3907, 28.3321, 28.2736, 28.2151, 28.1565, 28.0980,
    28.0395, 27.9809, 27.9224, 27.8639, 27.8053, 27.7468, 27.6883, 27.6297, 27.5712, 27.5126,
    27.4541, 27.3956, 27.3370, 27.2785, 27.2200, 27.1614, 27.1029, 27.0444, 26.9858, 26.9273,
    26.8687, 26.8102, 26.7517, 26.6931, 26.6346, 26.5761, 26.5175, 26.4590, 26.4005, 26.3419,
    26.2834, 26.2248, 26.1663, 26.1078, 26.0492, 25.9907, 25.9322, 25.8736, 25.8151, 25.7566,
    25.6980, 25.6395, 25.5809, 25.5224, 25.4639, 25.4053, 25.3468, 25.2883, 25.2297, 25.1712,
    25.1123, 25.0534, 24.9944, 24.9355, 24.8766, 24.8176, 24.7587, 24.6998, 24.6408, 24.5819,
    24.5230, 24.4640, 24.4051, 24.3461, 24.2872, 24.2283, 24.1693, 24.1104, 24.0515, 23.9925,
    23.9336, 23.8747, 23.8157, 23.7568, 23.6978, 23.6389, 23.5800, 23.5210, 23.4621, 23.4032,
    23.3442, 23.2853, 23.2264, 23.1674, 23.1085, 23.0495, 22.9906, 22.9317, 22.8727, 22.8138,
    22.7549, 22.6959, 22.6370, 22.5781, 22.5191, 22.4602, 22.4012, 22.3423, 22.2834, 22.2244,
    22.1655, 22.1066, 22.0476, 21.9887, 21.9298, 21.8708, 21.8119, 21.7529, 21.6940, 21.6351,
    21.5758, 21.5165, 21.4572, 21.3979, 21.3386, 21.2793, 21.2200, 21.1607, 21.1014, 21.0421,
    20.9828, 20.9235, 20.8642, 20.8049, 20.7456, 20.6863, 20.6270, 20.5677, 20.5084, 20.4491,
    20.3898, 20.3304, 20.2711, 20.2118, 20.1525, 20.0932, 20.0339, 19.9746, 19.9153, 19.8560,
    19.7967, 19.7374, 19.6781, 19.6188, 19.5595, 19.5002, 19.4409, 19.3816, 19.3223, 19.2630,
    19.2037, 19.1444, 19.0851, 19.0258, 18.9665, 18.9072, 18.8479, 18.7886, 18.7293, 18.6700,
    18.6107, 18.5514, 18.4921, 18.4327, 18.3734, 18.3141, 18.2548, 18.1955, 18.1362, 18.0769,
    18.0174, 17.9578, 17.8982, 17.8386, 17.7790, 17.7194, 17.6599, 17.6003, 17.5407, 17.4811,
    17.4215, 17.3619, 17.3023, 17.2427, 17.1832, 17.1236, 17.0640, 17.0044, 16.9448, 16.8852,
    16.8256, 16.7661, 16.7065, 16.6469, 16.5873, 16.5277, 16.4681, 16.4085, 16.3489, 16.2894,
    16.2298, 16.1702, 16.1106, 16.0510, 15.9914, 15.9318, 15.8723, 15.8127, 15.7531, 15.6935,
    15.6339, 15.5743, 15.5147, 15.4552, 15.3956, 15.3360, 15.2764, 15.2168, 15.1572, 15.0976,
    15.0380, 14.9785, 14.9189, 14.8593, 14.7997, 14.7401, 14.6805, 14.6209, 14.5614, 14.5018,
    14.4420, 14.3821, 14.3223, 14.2624, 14.2026, 14.1428, 14.0829, 14.0231, 13.9633, 13.9034,
    13.8436, 13.7837, 13.7239, 13.6641, 13.6042, 13.5444, 13.4846, 13.4247, 13.3649, 13.3051,
    13.2452, 13.1854, 13.1255, 13.0657, 13.0059, 12.9460, 12.8862, 12.8264, 12.7665, 12.7067,
    12.6469, 12.5870, 12.5272, 12.4673, 12.4075, 12.3477, 12.2878, 12.2280, 12.1682, 12.1083,
    12.0485, 11.9886, 11.9288, 11.8690, 11.8091, 11.7493, 11.6895, 11.6296, 11.5698, 11.5100,
    11.4501, 11.3903, 11.3304, 11.2706, 11.2108, 11.1509, 11.0911, 11.0313, 10.9714, 10.9116,
    10.8516, 10.7916, 10.7316, 10.6716, 10.6116, 10.5516, 10.4916, 10.4316, 10.3716, 10.3116,
    10.2516, 10.1916, 10.1316, 10.0716, 10.0116,  9.9515,  9.8915,  9.8315,  9.7715,  9.7115,
    9.6515,  9.5915,  9.5315,  9.4715,  9.4115,  9.3515,  9.2915,  9.2315,  9.1715,  9.1115,
    9.0515,  8.9915,  8.9315,  8.8715,  8.8115,  8.7515,  8.6915,  8.6315,  8.5715,  8.5115,
    8.4515,  8.3915,  8.3315,  8.2715,  8.2115,  8.1514,  8.0914,  8.0314,  7.9714,  7.9114,
    7.8514,  7.7914,  7.7314,  7.6714,  7.6114,  7.5514,  7.4914,  7.4314,  7.3714,  7.3114,
    7.2513,  7.1911,  7.1310,  7.0709,  7.0107,  6.9506,  6.8904,  6.8303,  6.7702,  6.7100,
    6.6499,  6.5898,  6.5296,  6.4695,  6.4094,  6.3492,  6.2891,  6.2289,  6.1688,  6.1087,
    6.0485,  5.9884,  5.9283,  5.8681,  5.8080,  5.7479,  5.6877,  5.6276,  5.5674,  5.5073,
    5.4472,  5.3870,  5.3269,  5.2668,  5.2066,  5.1465,  5.0863,  5.0262,  4.9661,  4.9059,
    4.8458,  4.7857,  4.7255,  4.6654,  4.6053,  4.5451,  4.4850,  4.4248,  4.3647,  4.3046,
    4.2444,  4.1843,  4.1242,  4.0640,  4.0039,  3.9437,  3.8836,  3.8235,  3.7633,  3.7032,
    3.6430,  3.5828,  3.5226,  3.4625,  3.4023,  3.3421,  3.2819,  3.2217,  3.1615,  3.1013,
    3.0411,  2.9810,  2.9208,  2.8606,  2.8004,  2.7402,  2.6800,  2.6198,  2.5597,  2.4995,
    2.4393,  2.3791,  2.3189,  2.2587,  2.1985,  2.1383,  2.0782,  2.0180,  1.9578,  1.8976,
    1.8374,  1.7772,  1.7170,  1.6569,  1.5967,  1.5365,  1.4763,  1.4161,  1.3559,  1.2957,
    1.2355,  1.1754,  1.1152,  1.0550,  0.9948,  0.9346,  0.8744,  0.8142,  0.7541,  0.6939,
    0.6337,  0.5735,  0.5133,  0.4531,  0.3929,  0.3327,  0.2726,  0.2124,  0.1522,  0.0920
};*/


const float ref_stand2sit[] = {

    0.0000,  0.0225,  0.0450,  0.0675,  0.0900,  0.1125,  0.1350,  0.1575,  0.1800,  0.2026,
    0.2251,  0.2476,  0.2701,  0.2926,  0.3151,  0.3376,  0.3601,  0.3826,  0.4051,  0.4276,
    0.4501,  0.4726,  0.4951,  0.5176,  0.5401,  0.5626,  0.5851,  0.6077,  0.6302,  0.6527,
    0.6752,  0.6977,  0.7202,  0.7427,  0.7652,  0.7877,  0.8102,  0.8327,  0.8552,  0.8777,
    0.9002,  0.9227,  0.9452,  0.9677,  0.9902,  1.0128,  1.0353,  1.0578,  1.0803,  1.1028,
    1.1253,  1.1478,  1.1703,  1.1928,  1.2153,  1.2378,  1.2603,  1.2828,  1.3053,  1.3278,
    1.3503,  1.3728,  1.3953,  1.4179,  1.4404,  1.4629,  1.4854,  1.5079,  1.5304,  1.5529,
    1.5754,  1.5979,  1.6204,  1.6429,  1.6654,  1.6879,  1.7104,  1.7329,  1.7554,  1.7779,
    1.8005,  1.8230,  1.8455,  1.8680,  1.8905,  1.9130,  1.9355,  1.9580,  1.9805,  2.0030,
    2.0255,  2.0480,  2.0705,  2.0930,  2.1155,  2.1380,  2.1605,  2.1830,  2.2056,  2.2281,
    2.2506,  2.2731,  2.2956,  2.3181,  2.3406,  2.3631,  2.3856,  2.4081,  2.4306,  2.4531,
    2.4756,  2.4981,  2.5206,  2.5431,  2.5656,  2.5881,  2.6107,  2.6332,  2.6557,  2.6782,
    2.7007,  2.7232,  2.7457,  2.7682,  2.7907,  2.8132,  2.8357,  2.8582,  2.8807,  2.9032,
    2.9257,  2.9482,  2.9707,  2.9932,  3.0158,  3.0383,  3.0608,  3.0833,  3.1058,  3.1283,
    3.1508,  3.1733,  3.1958,  3.2183,  3.2408,  3.2633,  3.2858,  3.3083,  3.3308,  3.3533,
    3.3758,  3.3983,  3.4209,  3.4434,  3.4659,  3.4884,  3.5109,  3.5334,  3.5559,  3.5784,
    3.6009,  3.6234,  3.6459,  3.6684,  3.6909,  3.7134,  3.7359,  3.7584,  3.7809,  3.8035,
    3.8260,  3.8485,  3.8710,  3.8935,  3.9160,  3.9385,  3.9610,  3.9835,  4.0060,  4.0285,
    4.0510,  4.0735,  4.0960,  4.1185,  4.1410,  4.1635,  4.1860,  4.2086,  4.2311,  4.2536,
    4.2761,  4.2986,  4.3211,  4.3436,  4.3661,  4.3886,  4.4111,  4.4336,  4.4561,  4.4786,
    4.5011,  4.5236,  4.5461,  4.5686,  4.5911,  4.6137,  4.6362,  4.6587,  4.6812,  4.7037,
    4.7262,  4.7487,  4.7712,  4.7937,  4.8162,  4.8387,  4.8612,  4.8837,  4.9062,  4.9287,
    4.9512,  4.9737,  4.9962,  5.0188,  5.0413,  5.0638,  5.0863,  5.1088,  5.1313,  5.1538,
    5.1763,  5.1988,  5.2213,  5.2438,  5.2663,  5.2888,  5.3113,  5.3338,  5.3563,  5.3788,
    5.4014,  5.4239,  5.4464,  5.4689,  5.4914,  5.5139,  5.5364,  5.5589,  5.5814,  5.6039,
    5.6264,  5.6489,  5.6714,  5.6939,  5.7164,  5.7389,  5.7614,  5.7839,  5.8065,  5.8290,
    5.8515,  5.8740,  5.8965,  5.9190,  5.9415,  5.9640,  5.9865,  6.0090,  6.0315,  6.0540,
    6.0765,  6.0990,  6.1215,  6.1440,  6.1665,  6.1890,  6.2116,  6.2341,  6.2566,  6.2791,
    6.3016,  6.3241,  6.3466,  6.3691,  6.3916,  6.4141,  6.4366,  6.4591,  6.4816,  6.5041,
    6.5266,  6.5491,  6.5716,  6.5941,  6.6167,  6.6392,  6.6617,  6.6842,  6.7067,  6.7292,
    6.7517,  6.7742,  6.7967,  6.8192,  6.8417,  6.8642,  6.8867,  6.9092,  6.9317,  6.9542,
    6.9767,  6.9992,  7.0218,  7.0443,  7.0668,  7.0893,  7.1118,  7.1343,  7.1568,  7.1793,
    7.2018,  7.2243,  7.2468,  7.2693,  7.2918,  7.3143,  7.3368,  7.3593,  7.3818,  7.4044,
    7.4269,  7.4494,  7.4719,  7.4944,  7.5169,  7.5394,  7.5619,  7.5844,  7.6069,  7.6294,
    7.6519,  7.6744,  7.6969,  7.7194,  7.7419,  7.7644,  7.7869,  7.8095,  7.8320,  7.8545,
    7.8770,  7.8995,  7.9220,  7.9445,  7.9670,  7.9895,  8.0120,  8.0345,  8.0570,  8.0795,
    8.1020,  8.1245,  8.1470,  8.1695,  8.1920,  8.2146,  8.2371,  8.2596,  8.2821,  8.3046,
    8.3271,  8.3496,  8.3721,  8.3946,  8.4171,  8.4396,  8.4621,  8.4846,  8.5071,  8.5296,
    8.5521,  8.5746,  8.5971,  8.6197,  8.6422,  8.6647,  8.6872,  8.7097,  8.7322,  8.7547,
    8.7772,  8.7997,  8.8222,  8.8447,  8.8672,  8.8897,  8.9122,  8.9347,  8.9572,  8.9797,
    9.0023,  9.0248,  9.0473,  9.0698,  9.0923,  9.1148,  9.1373,  9.1598,  9.1823,  9.2048,
    9.2273,  9.2498,  9.2723,  9.2948,  9.3173,  9.3398,  9.3623,  9.3848,  9.4074,  9.4299,
    9.4524,  9.4749,  9.4974,  9.5199,  9.5424,  9.5649,  9.5874,  9.6099,  9.6324,  9.6549,
    9.6774,  9.6999,  9.7224,  9.7449,  9.7674,  9.7899,  9.8125,  9.8350,  9.8575,  9.8800,
    9.9025,  9.9250,  9.9475,  9.9700,  9.9925, 10.0150, 10.0375, 10.0600, 10.0825, 10.1050,
    10.1275, 10.1500, 10.1725, 10.1950, 10.2176, 10.2401, 10.2626, 10.2851, 10.3076, 10.3301,
    10.3526, 10.3751, 10.3976, 10.4201, 10.4426, 10.4651, 10.4876, 10.5101, 10.5326, 10.5551,
    10.5776, 10.6002, 10.6227, 10.6452, 10.6677, 10.6902, 10.7127, 10.7352, 10.7577, 10.7802,
    10.8027, 10.8252, 10.8477, 10.8702, 10.8927, 10.9152, 10.9377, 10.9602, 10.9827, 11.0053,
    11.0278, 11.0503, 11.0728, 11.0953, 11.1178, 11.1403, 11.1628, 11.1853, 11.2078, 11.2303,
    11.2528, 11.2753, 11.2978, 11.3203, 11.3428, 11.3653, 11.3878, 11.4104, 11.4329, 11.4554,
    11.4779, 11.5004, 11.5229, 11.5454, 11.5679, 11.5904, 11.6129, 11.6354, 11.6579, 11.6804,
    11.7029, 11.7254, 11.7479, 11.7704, 11.7929, 11.8155, 11.8380, 11.8605, 11.8830, 11.9055,
    11.9280, 11.9505, 11.9730, 11.9955, 12.0180, 12.0405, 12.0630, 12.0855, 12.1080, 12.1305,
    12.1530, 12.1755, 12.1980, 12.2206, 12.2431, 12.2656, 12.2881, 12.3106, 12.3331, 12.3556,
    12.3781, 12.4006, 12.4231, 12.4456, 12.4681, 12.4906, 12.5131, 12.5356, 12.5581, 12.5806,
    12.6032, 12.6257, 12.6482, 12.6707, 12.6932, 12.7157, 12.7382, 12.7607, 12.7832, 12.8057,
    12.8282, 12.8507, 12.8732, 12.8957, 12.9182, 12.9407, 12.9632, 12.9857, 13.0083, 13.0308,
    13.0533, 13.0758, 13.0983, 13.1208, 13.1433, 13.1658, 13.1883, 13.2108, 13.2333, 13.2558,
    13.2783, 13.3008, 13.3233, 13.3458, 13.3683, 13.3908, 13.4134, 13.4359, 13.4584, 13.4809,
    13.5034, 13.5259, 13.5484, 13.5709, 13.5934, 13.6159, 13.6384, 13.6609, 13.6834, 13.7059,
    13.7284, 13.7509, 13.7734, 13.7959, 13.8185, 13.8410, 13.8635, 13.8860, 13.9085, 13.9310,
    13.9535, 13.9760, 13.9985, 14.0210, 14.0435, 14.0660, 14.0885, 14.1110, 14.1335, 14.1560,
    14.1785, 14.2011, 14.2236, 14.2461, 14.2686, 14.2911, 14.3136, 14.3361, 14.3586, 14.3811,
    14.4036, 14.4261, 14.4486, 14.4711, 14.4936, 14.5161, 14.5386, 14.5611, 14.5836, 14.6062,
    14.6287, 14.6512, 14.6737, 14.6962, 14.7187, 14.7412, 14.7637, 14.7862, 14.8087, 14.8312,
    14.8537, 14.8762, 14.8987, 14.9212, 14.9437, 14.9662, 14.9887, 15.0113, 15.0338, 15.0563,
    15.0788, 15.1013, 15.1238, 15.1463, 15.1688, 15.1913, 15.2138, 15.2363, 15.2588, 15.2813,
    15.3038, 15.3263, 15.3488, 15.3713, 15.3938, 15.4164, 15.4389, 15.4614, 15.4839, 15.5064,
    15.5289, 15.5514, 15.5739, 15.5964, 15.6189, 15.6414, 15.6639, 15.6864, 15.7089, 15.7314,
    15.7539, 15.7764, 15.7989, 15.8215, 15.8440, 15.8665, 15.8890, 15.9115, 15.9340, 15.9565,
    15.9790, 16.0015, 16.0240, 16.0465, 16.0690, 16.0915, 16.1140, 16.1365, 16.1590, 16.1815,
    16.2041, 16.2266, 16.2491, 16.2716, 16.2941, 16.3166, 16.3391, 16.3616, 16.3841, 16.4066,
    16.4291, 16.4516, 16.4741, 16.4966, 16.5191, 16.5416, 16.5641, 16.5866, 16.6092, 16.6317,
    16.6542, 16.6767, 16.6992, 16.7217, 16.7442, 16.7667, 16.7892, 16.8117, 16.8342, 16.8567,
    16.8792, 16.9017, 16.9242, 16.9467, 16.9692, 16.9917, 17.0143, 17.0368, 17.0593, 17.0818,
    17.1043, 17.1268, 17.1493, 17.1718, 17.1943, 17.2168, 17.2393, 17.2618, 17.2843, 17.3068,
    17.3293, 17.3518, 17.3743, 17.3968, 17.4194, 17.4419, 17.4644, 17.4869, 17.5094, 17.5319,
    17.5544, 17.5769, 17.5994, 17.6219, 17.6444, 17.6669, 17.6894, 17.7119, 17.7344, 17.7569,
    17.7794, 17.8020, 17.8245, 17.8470, 17.8695, 17.8920, 17.9145, 17.9370, 17.9595, 17.9820,
    18.0045, 18.0270, 18.0495, 18.0720, 18.0945, 18.1170, 18.1395, 18.1620, 18.1845, 18.2071,
    18.2296, 18.2521, 18.2746, 18.2971, 18.3196, 18.3421, 18.3646, 18.3871, 18.4096, 18.4321,
    18.4546, 18.4771, 18.4996, 18.5221, 18.5446, 18.5671, 18.5896, 18.6122, 18.6347, 18.6572,
    18.6797, 18.7022, 18.7247, 18.7472, 18.7697, 18.7922, 18.8147, 18.8372, 18.8597, 18.8822,
    18.9047, 18.9272, 18.9497, 18.9722, 18.9947, 19.0173, 19.0398, 19.0623, 19.0848, 19.1073,
    19.1298, 19.1523, 19.1748, 19.1973, 19.2198, 19.2423, 19.2648, 19.2873, 19.3098, 19.3323,
    19.3548, 19.3773, 19.3998, 19.4224, 19.4449, 19.4674, 19.4899, 19.5124, 19.5349, 19.5574,
    19.5799, 19.6024, 19.6249, 19.6474, 19.6699, 19.6924, 19.7149, 19.7374, 19.7599, 19.7824,
    19.8050, 19.8275, 19.8500, 19.8725, 19.8950, 19.9175, 19.9400, 19.9625, 19.9850, 20.0075,
    20.0300, 20.0525, 20.0750, 20.0975, 20.1200, 20.1425, 20.1650, 20.1875, 20.2101, 20.2326,
    20.2551, 20.2776, 20.3001, 20.3226, 20.3451, 20.3676, 20.3901, 20.4126, 20.4351, 20.4576,
    20.4801, 20.5026, 20.5251, 20.5476, 20.5701, 20.5926, 20.6152, 20.6377, 20.6602, 20.6827,
    20.7052, 20.7277, 20.7502, 20.7727, 20.7952, 20.8177, 20.8402, 20.8627, 20.8852, 20.9077,
    20.9302, 20.9527, 20.9752, 20.9977, 21.0203, 21.0428, 21.0653, 21.0878, 21.1103, 21.1328,
    21.1553, 21.1778, 21.2003, 21.2228, 21.2453, 21.2678, 21.2903, 21.3128, 21.3353, 21.3578,
    21.3803, 21.4029, 21.4254, 21.4479, 21.4704, 21.4929, 21.5154, 21.5379, 21.5604, 21.5829,
    21.6054, 21.6279, 21.6504, 21.6729, 21.6954, 21.7179, 21.7404, 21.7629, 21.7854, 21.8080,
    21.8305, 21.8530, 21.8755, 21.8980, 21.9205, 21.9430, 21.9655, 21.9880, 22.0105, 22.0330,
    22.0555, 22.0780, 22.1005, 22.1230, 22.1455, 22.1680, 22.1905, 22.2131, 22.2356, 22.2581,
    22.2806, 22.3031, 22.3256, 22.3481, 22.3706, 22.3931, 22.4156, 22.4381, 22.4606, 22.4831,
    22.5056, 22.5281, 22.5506, 22.5731, 22.5956, 22.6182, 22.6407, 22.6632, 22.6857, 22.7082,
    22.7307, 22.7532, 22.7757, 22.7982, 22.8207, 22.8432, 22.8657, 22.8882, 22.9107, 22.9332,
    22.9557, 22.9782, 23.0008, 23.0233, 23.0458, 23.0683, 23.0908, 23.1133, 23.1358, 23.1583,
    23.1808, 23.2033, 23.2258, 23.2483, 23.2708, 23.2933, 23.3158, 23.3383, 23.3608, 23.3833,
    23.4059, 23.4284, 23.4509, 23.4734, 23.4959, 23.5184, 23.5409, 23.5634, 23.5859, 23.6084,
    23.6309, 23.6534, 23.6759, 23.6984, 23.7209, 23.7434, 23.7659, 23.7884, 23.8110, 23.8335,
    23.8560, 23.8785, 23.9010, 23.9235, 23.9460, 23.9685, 23.9910, 24.0135, 24.0360, 24.0585,
    24.0810, 24.1035, 24.1260, 24.1485, 24.1710, 24.1935, 24.2161, 24.2386, 24.2611, 24.2836,
    24.3061, 24.3286, 24.3511, 24.3736, 24.3961, 24.4186, 24.4411, 24.4636, 24.4861, 24.5086,
    24.5311, 24.5536, 24.5761, 24.5986, 24.6212, 24.6437, 24.6662, 24.6887, 24.7112, 24.7337,
    24.7562, 24.7787, 24.8012, 24.8237, 24.8462, 24.8687, 24.8912, 24.9137, 24.9362, 24.9587,
    24.9812, 25.0038, 25.0263, 25.0488, 25.0713, 25.0938, 25.1163, 25.1388, 25.1613, 25.1838,
    25.2063, 25.2288, 25.2513, 25.2738, 25.2963, 25.3188, 25.3413, 25.3638, 25.3863, 25.4089,
    25.4314, 25.4539, 25.4764, 25.4989, 25.5214, 25.5439, 25.5664, 25.5889, 25.6114, 25.6339,
    25.6564, 25.6789, 25.7014, 25.7239, 25.7464, 25.7689, 25.7914, 25.8140, 25.8365, 25.8590,
    25.8815, 25.9040, 25.9265, 25.9490, 25.9715, 25.9940, 26.0165, 26.0390, 26.0615, 26.0840,
    26.1065, 26.1290, 26.1515, 26.1740, 26.1965, 26.2191, 26.2416, 26.2641, 26.2866, 26.3091,
    26.3316, 26.3541, 26.3766, 26.3991, 26.4216, 26.4441, 26.4666, 26.4891, 26.5116, 26.5341,
    26.5566, 26.5791, 26.6017, 26.6242, 26.6467, 26.6692, 26.6917, 26.7142, 26.7367, 26.7592,
    26.7817, 26.8042, 26.8267, 26.8492, 26.8717, 26.8942, 26.9167, 26.9392, 26.9617, 26.9842,
    27.0068, 27.0293, 27.0518, 27.0743, 27.0968, 27.1193, 27.1418, 27.1643, 27.1868, 27.2093,
    27.2318, 27.2543, 27.2768, 27.2993, 27.3218, 27.3443, 27.3668, 27.3893, 27.4119, 27.4344,
    27.4569, 27.4794, 27.5019, 27.5244, 27.5469, 27.5694, 27.5919, 27.6144, 27.6369, 27.6594,
    27.6819, 27.7044, 27.7269, 27.7494, 27.7719, 27.7944, 27.8170, 27.8395, 27.8620, 27.8845,
    27.9070, 27.9295, 27.9520, 27.9745, 27.9970, 28.0195, 28.0420, 28.0645, 28.0870, 28.1095,
    28.1320, 28.1545, 28.1770, 28.1995, 28.2221, 28.2446, 28.2671, 28.2896, 28.3121, 28.3346,
    28.3571, 28.3796, 28.4021, 28.4246, 28.4471, 28.4696, 28.4921, 28.5146, 28.5371, 28.5596,
    28.5821, 28.6047, 28.6272, 28.6497, 28.6722, 28.6947, 28.7172, 28.7397, 28.7622, 28.7847,
    28.8072, 28.8297, 28.8522, 28.8747, 28.8972, 28.9197, 28.9422, 28.9647, 28.9872, 29.0098,
    29.0323, 29.0548, 29.0773, 29.0998, 29.1223, 29.1448, 29.1673, 29.1898, 29.2123, 29.2348,
    29.2573, 29.2798, 29.3023, 29.3248, 29.3473, 29.3698, 29.3923, 29.4149, 29.4374, 29.4599,
    29.4824, 29.5049, 29.5274, 29.5499, 29.5724, 29.5949, 29.6174, 29.6399, 29.6624, 29.6849,
    29.7074, 29.7299, 29.7524, 29.7749, 29.7974, 29.8200, 29.8425, 29.8650, 29.8875, 29.9100,
    29.9325, 29.9550, 29.9775, 30.0000, 30.0225, 30.0450, 30.0675, 30.0900, 30.1125, 30.1350,
    30.1575, 30.1800, 30.2026, 30.2251, 30.2476, 30.2701, 30.2926, 30.3151, 30.3376, 30.3601,
    30.3826, 30.4051, 30.4276, 30.4501, 30.4726, 30.4951, 30.5176, 30.5401, 30.5626, 30.5851,
    30.6077, 30.6302, 30.6527, 30.6752, 30.6977, 30.7202, 30.7427, 30.7652, 30.7877, 30.8102,
    30.8327, 30.8552, 30.8777, 30.9002, 30.9227, 30.9452, 30.9677, 30.9902, 31.0128, 31.0353,
    31.0578, 31.0803, 31.1028, 31.1253, 31.1478, 31.1703, 31.1928, 31.2153, 31.2378, 31.2603,
    31.2828, 31.3053, 31.3278, 31.3503, 31.3728, 31.3953, 31.4179, 31.4404, 31.4629, 31.4854,
    31.5079, 31.5304, 31.5529, 31.5754, 31.5979, 31.6204, 31.6429, 31.6654, 31.6879, 31.7104,
    31.7329, 31.7554, 31.7779, 31.8005, 31.8230, 31.8455, 31.8680, 31.8905, 31.9130, 31.9355,
    31.9580, 31.9805, 32.0030, 32.0255, 32.0480, 32.0705, 32.0930, 32.1155, 32.1380, 32.1605,
    32.1830, 32.2056, 32.2281, 32.2506, 32.2731, 32.2956, 32.3181, 32.3406, 32.3631, 32.3856,
    32.4081, 32.4306, 32.4531, 32.4756, 32.4981, 32.5206, 32.5431, 32.5656, 32.5881, 32.6107,
    32.6332, 32.6557, 32.6782, 32.7007, 32.7232, 32.7457, 32.7682, 32.7907, 32.8132, 32.8357,
    32.8582, 32.8807, 32.9032, 32.9257, 32.9482, 32.9707, 32.9932, 33.0158, 33.0383, 33.0608,
    33.0833, 33.1058, 33.1283, 33.1508, 33.1733, 33.1958, 33.2183, 33.2408, 33.2633, 33.2858,
    33.3083, 33.3308, 33.3533, 33.3758, 33.3983, 33.4209, 33.4434, 33.4659, 33.4884, 33.5109,
    33.5334, 33.5559, 33.5784, 33.6009, 33.6234, 33.6459, 33.6684, 33.6909, 33.7134, 33.7359,
    33.7584, 33.7809, 33.8035, 33.8260, 33.8485, 33.8710, 33.8935, 33.9160, 33.9385, 33.9610,
    33.9835, 34.0060, 34.0285, 34.0510, 34.0735, 34.0960, 34.1185, 34.1410, 34.1635, 34.1860,
    34.2086, 34.2311, 34.2536, 34.2761, 34.2986, 34.3211, 34.3436, 34.3661, 34.3886, 34.4111,
    34.4336, 34.4561, 34.4786, 34.5011, 34.5236, 34.5461, 34.5686, 34.5911, 34.6137, 34.6362,
    34.6587, 34.6812, 34.7037, 34.7262, 34.7487, 34.7712, 34.7937, 34.8162, 34.8387, 34.8612,
    34.8837, 34.9062, 34.9287, 34.9512, 34.9737, 34.9962, 35.0188, 35.0413, 35.0638, 35.0863,
    35.1088, 35.1313, 35.1538, 35.1763, 35.1988, 35.2213, 35.2438, 35.2663, 35.2888, 35.3113,
    35.3338, 35.3563, 35.3788, 35.4014, 35.4239, 35.4464, 35.4689, 35.4914, 35.5139, 35.5364,
    35.5589, 35.5814, 35.6039, 35.6264, 35.6489, 35.6714, 35.6939, 35.7164, 35.7389, 35.7614,
    35.7839, 35.8065, 35.8290, 35.8515, 35.8740, 35.8965, 35.9190, 35.9415, 35.9640, 35.9865,
    36.0090, 36.0315, 36.0540, 36.0765, 36.0990, 36.1215, 36.1440, 36.1665, 36.1890, 36.2116,
    36.2341, 36.2566, 36.2791, 36.3016, 36.3241, 36.3466, 36.3691, 36.3916, 36.4141, 36.4366,
    36.4591, 36.4816, 36.5041, 36.5266, 36.5491, 36.5716, 36.5941, 36.6167, 36.6392, 36.6617,
    36.6842, 36.7067, 36.7292, 36.7517, 36.7742, 36.7967, 36.8192, 36.8417, 36.8642, 36.8867,
    36.9092, 36.9317, 36.9542, 36.9767, 36.9992, 37.0218, 37.0443, 37.0668, 37.0893, 37.1118,
    37.1343, 37.1568, 37.1793, 37.2018, 37.2243, 37.2468, 37.2693, 37.2918, 37.3143, 37.3368,
    37.3593, 37.3818, 37.4044, 37.4269, 37.4494, 37.4719, 37.4944, 37.5169, 37.5394, 37.5619,
    37.5844, 37.6069, 37.6294, 37.6519, 37.6744, 37.6969, 37.7194, 37.7419, 37.7644, 37.7869,
    37.8095, 37.8320, 37.8545, 37.8770, 37.8995, 37.9220, 37.9445, 37.9670, 37.9895, 38.0120,
    38.0345, 38.0570, 38.0795, 38.1020, 38.1245, 38.1470, 38.1695, 38.1920, 38.2146, 38.2371,
    38.2596, 38.2821, 38.3046, 38.3271, 38.3496, 38.3721, 38.3946, 38.4171, 38.4396, 38.4621,
    38.4846, 38.5071, 38.5296, 38.5521, 38.5746, 38.5971, 38.6197, 38.6422, 38.6647, 38.6872,
    38.7097, 38.7322, 38.7547, 38.7772, 38.7997, 38.8222, 38.8447, 38.8672, 38.8897, 38.9122,
    38.9347, 38.9572, 38.9797, 39.0023, 39.0248, 39.0473, 39.0698, 39.0923, 39.1148, 39.1373,
    39.1598, 39.1823, 39.2048, 39.2273, 39.2498, 39.2723, 39.2948, 39.3173, 39.3398, 39.3623,
    39.3848, 39.4074, 39.4299, 39.4524, 39.4749, 39.4974, 39.5199, 39.5424, 39.5649, 39.5874,
    39.6099, 39.6324, 39.6549, 39.6774, 39.6999, 39.7224, 39.7449, 39.7674, 39.7899, 39.8125,
    39.8350, 39.8575, 39.8800, 39.9025, 39.9250, 39.9475, 39.9700, 39.9925, 40.0150, 40.0375,
    40.0600, 40.0825, 40.1050, 40.1275, 40.1500, 40.1725, 40.1950, 40.2176, 40.2401, 40.2626,
    40.2851, 40.3076, 40.3301, 40.3526, 40.3751, 40.3976, 40.4201, 40.4426, 40.4651, 40.4876,
    40.5101, 40.5326, 40.5551, 40.5776, 40.6002, 40.6227, 40.6452, 40.6677, 40.6902, 40.7127,
    40.7352, 40.7577, 40.7802, 40.8027, 40.8252, 40.8477, 40.8702, 40.8927, 40.9152, 40.9377,
    40.9602, 40.9827, 41.0053, 41.0278, 41.0503, 41.0728, 41.0953, 41.1178, 41.1403, 41.1628,
    41.1853, 41.2078, 41.2303, 41.2528, 41.2753, 41.2978, 41.3203, 41.3428, 41.3653, 41.3878,
    41.4104, 41.4329, 41.4554, 41.4779, 41.5004, 41.5229, 41.5454, 41.5679, 41.5904, 41.6129,
    41.6354, 41.6579, 41.6804, 41.7029, 41.7254, 41.7479, 41.7704, 41.7929, 41.8155, 41.8380,
    41.8605, 41.8830, 41.9055, 41.9280, 41.9505, 41.9730, 41.9955, 42.0180, 42.0405, 42.0630,
    42.0855, 42.1080, 42.1305, 42.1530, 42.1755, 42.1980, 42.2206, 42.2431, 42.2656, 42.2881,
    42.3106, 42.3331, 42.3556, 42.3781, 42.4006, 42.4231, 42.4456, 42.4681, 42.4906, 42.5131,
    42.5356, 42.5581, 42.5806, 42.6032, 42.6257, 42.6482, 42.6707, 42.6932, 42.7157, 42.7382,
    42.7607, 42.7832, 42.8057, 42.8282, 42.8507, 42.8732, 42.8957, 42.9182, 42.9407, 42.9632,
    42.9857, 43.0083, 43.0308, 43.0533, 43.0758, 43.0983, 43.1208, 43.1433, 43.1658, 43.1883,
    43.2108, 43.2333, 43.2558, 43.2783, 43.3008, 43.3233, 43.3458, 43.3683, 43.3908, 43.4134,
    43.4359, 43.4584, 43.4809, 43.5034, 43.5259, 43.5484, 43.5709, 43.5934, 43.6159, 43.6384,
    43.6609, 43.6834, 43.7059, 43.7284, 43.7509, 43.7734, 43.7959, 43.8185, 43.8410, 43.8635,
    43.8860, 43.9085, 43.9310, 43.9535, 43.9760, 43.9985, 44.0210, 44.0435, 44.0660, 44.0885,
    44.1110, 44.1335, 44.1560, 44.1785, 44.2011, 44.2236, 44.2461, 44.2686, 44.2911, 44.3136,
    44.3361, 44.3586, 44.3811, 44.4036, 44.4261, 44.4486, 44.4711, 44.4936, 44.5161, 44.5386,
    44.5611, 44.5836, 44.6062, 44.6287, 44.6512, 44.6737, 44.6962, 44.7187, 44.7412, 44.7637,
    44.7862, 44.8087, 44.8312, 44.8537, 44.8762, 44.8987, 44.9212, 44.9437, 44.9662, 44.9887,
    45.0113, 45.0338, 45.0563, 45.0788, 45.1013, 45.1238, 45.1463, 45.1688, 45.1913, 45.2138,
    45.2363, 45.2588, 45.2813, 45.3038, 45.3263, 45.3488, 45.3713, 45.3938, 45.4164, 45.4389,
    45.4614, 45.4839, 45.5064, 45.5289, 45.5514, 45.5739, 45.5964, 45.6189, 45.6414, 45.6639,
    45.6864, 45.7089, 45.7314, 45.7539, 45.7764, 45.7989, 45.8215, 45.8440, 45.8665, 45.8890,
    45.9115, 45.9340, 45.9565, 45.9790, 46.0015, 46.0240, 46.0465, 46.0690, 46.0915, 46.1140,
    46.1365, 46.1590, 46.1815, 46.2041, 46.2266, 46.2491, 46.2716, 46.2941, 46.3166, 46.3391,
    46.3616, 46.3841, 46.4066, 46.4291, 46.4516, 46.4741, 46.4966, 46.5191, 46.5416, 46.5641,
    46.5866, 46.6092, 46.6317, 46.6542, 46.6767, 46.6992, 46.7217, 46.7442, 46.7667, 46.7892,
    46.8117, 46.8342, 46.8567, 46.8792, 46.9017, 46.9242, 46.9467, 46.9692, 46.9917, 47.0143,
    47.0368, 47.0593, 47.0818, 47.1043, 47.1268, 47.1493, 47.1718, 47.1943, 47.2168, 47.2393,
    47.2618, 47.2843, 47.3068, 47.3293, 47.3518, 47.3743, 47.3968, 47.4194, 47.4419, 47.4644,
    47.4869, 47.5094, 47.5319, 47.5544, 47.5769, 47.5994, 47.6219, 47.6444, 47.6669, 47.6894,
    47.7119, 47.7344, 47.7569, 47.7794, 47.8020, 47.8245, 47.8470, 47.8695, 47.8920, 47.9145,
    47.9370, 47.9595, 47.9820, 48.0045, 48.0270, 48.0495, 48.0720, 48.0945, 48.1170, 48.1395,
    48.1620, 48.1845, 48.2071, 48.2296, 48.2521, 48.2746, 48.2971, 48.3196, 48.3421, 48.3646,
    48.3871, 48.4096, 48.4321, 48.4546, 48.4771, 48.4996, 48.5221, 48.5446, 48.5671, 48.5896,
    48.6122, 48.6347, 48.6572, 48.6797, 48.7022, 48.7247, 48.7472, 48.7697, 48.7922, 48.8147,
    48.8372, 48.8597, 48.8822, 48.9047, 48.9272, 48.9497, 48.9722, 48.9947, 49.0173, 49.0398,
    49.0623, 49.0848, 49.1073, 49.1298, 49.1523, 49.1748, 49.1973, 49.2198, 49.2423, 49.2648,
    49.2873, 49.3098, 49.3323, 49.3548, 49.3773, 49.3998, 49.4224, 49.4449, 49.4674, 49.4899,
    49.5124, 49.5349, 49.5574, 49.5799, 49.6024, 49.6249, 49.6474, 49.6699, 49.6924, 49.7149,
    49.7374, 49.7599, 49.7824, 49.8050, 49.8275, 49.8500, 49.8725, 49.8950, 49.9175, 49.9400,
    49.9625, 49.9850, 50.0075, 50.0300, 50.0525, 50.0750, 50.0975, 50.1200, 50.1425, 50.1650,
    50.1875, 50.2101, 50.2326, 50.2551, 50.2776, 50.3001, 50.3226, 50.3451, 50.3676, 50.3901,
    50.4126, 50.4351, 50.4576, 50.4801, 50.5026, 50.5251, 50.5476, 50.5701, 50.5926, 50.6152,
    50.6377, 50.6602, 50.6827, 50.7052, 50.7277, 50.7502, 50.7727, 50.7952, 50.8177, 50.8402,
    50.8627, 50.8852, 50.9077, 50.9302, 50.9527, 50.9752, 50.9977, 51.0203, 51.0428, 51.0653,
    51.0878, 51.1103, 51.1328, 51.1553, 51.1778, 51.2003, 51.2228, 51.2453, 51.2678, 51.2903,
    51.3128, 51.3353, 51.3578, 51.3803, 51.4029, 51.4254, 51.4479, 51.4704, 51.4929, 51.5154,
    51.5379, 51.5604, 51.5829, 51.6054, 51.6279, 51.6504, 51.6729, 51.6954, 51.7179, 51.7404,
    51.7629, 51.7854, 51.8080, 51.8305, 51.8530, 51.8755, 51.8980, 51.9205, 51.9430, 51.9655,
    51.9880, 52.0105, 52.0330, 52.0555, 52.0780, 52.1005, 52.1230, 52.1455, 52.1680, 52.1905,
    52.2131, 52.2356, 52.2581, 52.2806, 52.3031, 52.3256, 52.3481, 52.3706, 52.3931, 52.4156,
    52.4381, 52.4606, 52.4831, 52.5056, 52.5281, 52.5506, 52.5731, 52.5956, 52.6182, 52.6407,
    52.6632, 52.6857, 52.7082, 52.7307, 52.7532, 52.7757, 52.7982, 52.8207, 52.8432, 52.8657,
    52.8882, 52.9107, 52.9332, 52.9557, 52.9782, 53.0008, 53.0233, 53.0458, 53.0683, 53.0908,
    53.1133, 53.1358, 53.1583, 53.1808, 53.2033, 53.2258, 53.2483, 53.2708, 53.2933, 53.3158,
    53.3383, 53.3608, 53.3833, 53.4059, 53.4284, 53.4509, 53.4734, 53.4959, 53.5184, 53.5409,
    53.5634, 53.5859, 53.6084, 53.6309, 53.6534, 53.6759, 53.6984, 53.7209, 53.7434, 53.7659,
    53.7884, 53.8110, 53.8335, 53.8560, 53.8785, 53.9010, 53.9235, 53.9460, 53.9685, 53.9910,
    54.0135, 54.0360, 54.0585, 54.0810, 54.1035, 54.1260, 54.1485, 54.1710, 54.1935, 54.2161,
    54.2386, 54.2611, 54.2836, 54.3061, 54.3286, 54.3511, 54.3736, 54.3961, 54.4186, 54.4411,
    54.4636, 54.4861, 54.5086, 54.5311, 54.5536, 54.5761, 54.5986, 54.6212, 54.6437, 54.6662,
    54.6887, 54.7112, 54.7337, 54.7562, 54.7787, 54.8012, 54.8237, 54.8462, 54.8687, 54.8912,
    54.9137, 54.9362, 54.9587, 54.9812, 55.0038, 55.0263, 55.0488, 55.0713, 55.0938, 55.1163,
    55.1388, 55.1613, 55.1838, 55.2063, 55.2288, 55.2513, 55.2738, 55.2963, 55.3188, 55.3413,
    55.3638, 55.3863, 55.4089, 55.4314, 55.4539, 55.4764, 55.4989, 55.5214, 55.5439, 55.5664,
    55.5889, 55.6114, 55.6339, 55.6564, 55.6789, 55.7014, 55.7239, 55.7464, 55.7689, 55.7914,
    55.8140, 55.8365, 55.8590, 55.8815, 55.9040, 55.9265, 55.9490, 55.9715, 55.9940, 56.0165,
    56.0390, 56.0615, 56.0840, 56.1065, 56.1290, 56.1515, 56.1740, 56.1965, 56.2191, 56.2416,
    56.2641, 56.2866, 56.3091, 56.3316, 56.3541, 56.3766, 56.3991, 56.4216, 56.4441, 56.4666,
    56.4891, 56.5116, 56.5341, 56.5566, 56.5791, 56.6017, 56.6242, 56.6467, 56.6692, 56.6917,
    56.7142, 56.7367, 56.7592, 56.7817, 56.8042, 56.8267, 56.8492, 56.8717, 56.8942, 56.9167,
    56.9392, 56.9617, 56.9842, 57.0068, 57.0293, 57.0518, 57.0743, 57.0968, 57.1193, 57.1418,
    57.1643, 57.1868, 57.2093, 57.2318, 57.2543, 57.2768, 57.2993, 57.3218, 57.3443, 57.3668,
    57.3893, 57.4119, 57.4344, 57.4569, 57.4794, 57.5019, 57.5244, 57.5469, 57.5694, 57.5919,
    57.6144, 57.6369, 57.6594, 57.6819, 57.7044, 57.7269, 57.7494, 57.7719, 57.7944, 57.8170,
    57.8395, 57.8620, 57.8845, 57.9070, 57.9295, 57.9520, 57.9745, 57.9970, 58.0195, 58.0420,
    58.0645, 58.0870, 58.1095, 58.1320, 58.1545, 58.1770, 58.1995, 58.2221, 58.2446, 58.2671,
    58.2896, 58.3121, 58.3346, 58.3571, 58.3796, 58.4021, 58.4246, 58.4471, 58.4696, 58.4921,
    58.5146, 58.5371, 58.5596, 58.5821, 58.6047, 58.6272, 58.6497, 58.6722, 58.6947, 58.7172,
    58.7397, 58.7622, 58.7847, 58.8072, 58.8297, 58.8522, 58.8747, 58.8972, 58.9197, 58.9422,
    58.9647, 58.9872, 59.0098, 59.0323, 59.0548, 59.0773, 59.0998, 59.1223, 59.1448, 59.1673,
    59.1898, 59.2123, 59.2348, 59.2573, 59.2798, 59.3023, 59.3248, 59.3473, 59.3698, 59.3923,
    59.4149, 59.4374, 59.4599, 59.4824, 59.5049, 59.5274, 59.5499, 59.5724, 59.5949, 59.6174,
    59.6399, 59.6624, 59.6849, 59.7074, 59.7299, 59.7524, 59.7749, 59.7974, 59.8200, 59.8425,
    59.8650, 59.8875, 59.9100, 59.9325, 59.9550, 59.9775, 60.0000, 60.0225, 60.0450, 60.0675,
    60.0900, 60.1125, 60.1350, 60.1575, 60.1800, 60.2026, 60.2251, 60.2476, 60.2701, 60.2926,
    60.3151, 60.3376, 60.3601, 60.3826, 60.4051, 60.4276, 60.4501, 60.4726, 60.4951, 60.5176,
    60.5401, 60.5626, 60.5851, 60.6077, 60.6302, 60.6527, 60.6752, 60.6977, 60.7202, 60.7427,
    60.7652, 60.7877, 60.8102, 60.8327, 60.8552, 60.8777, 60.9002, 60.9227, 60.9452, 60.9677,
    60.9902, 61.0128, 61.0353, 61.0578, 61.0803, 61.1028, 61.1253, 61.1478, 61.1703, 61.1928,
    61.2153, 61.2378, 61.2603, 61.2828, 61.3053, 61.3278, 61.3503, 61.3728, 61.3953, 61.4179,
    61.4404, 61.4629, 61.4854, 61.5079, 61.5304, 61.5529, 61.5754, 61.5979, 61.6204, 61.6429,
    61.6654, 61.6879, 61.7104, 61.7329, 61.7554, 61.7779, 61.8005, 61.8230, 61.8455, 61.8680,
    61.8905, 61.9130, 61.9355, 61.9580, 61.9805, 62.0030, 62.0255, 62.0480, 62.0705, 62.0930,
    62.1155, 62.1380, 62.1605, 62.1830, 62.2056, 62.2281, 62.2506, 62.2731, 62.2956, 62.3181,
    62.3406, 62.3631, 62.3856, 62.4081, 62.4306, 62.4531, 62.4756, 62.4981, 62.5206, 62.5431,
    62.5656, 62.5881, 62.6107, 62.6332, 62.6557, 62.6782, 62.7007, 62.7232, 62.7457, 62.7682,
    62.7907, 62.8132, 62.8357, 62.8582, 62.8807, 62.9032, 62.9257, 62.9482, 62.9707, 62.9932,
    63.0158, 63.0383, 63.0608, 63.0833, 63.1058, 63.1283, 63.1508, 63.1733, 63.1958, 63.2183,
    63.2408, 63.2633, 63.2858, 63.3083, 63.3308, 63.3533, 63.3758, 63.3983, 63.4209, 63.4434,
    63.4659, 63.4884, 63.5109, 63.5334, 63.5559, 63.5784, 63.6009, 63.6234, 63.6459, 63.6684,
    63.6909, 63.7134, 63.7359, 63.7584, 63.7809, 63.8035, 63.8260, 63.8485, 63.8710, 63.8935,
    63.9160, 63.9385, 63.9610, 63.9835, 64.0060, 64.0285, 64.0510, 64.0735, 64.0960, 64.1185,
    64.1410, 64.1635, 64.1860, 64.2086, 64.2311, 64.2536, 64.2761, 64.2986, 64.3211, 64.3436,
    64.3661, 64.3886, 64.4111, 64.4336, 64.4561, 64.4786, 64.5011, 64.5236, 64.5461, 64.5686,
    64.5911, 64.6137, 64.6362, 64.6587, 64.6812, 64.7037, 64.7262, 64.7487, 64.7712, 64.7937,
    64.8162, 64.8387, 64.8612, 64.8837, 64.9062, 64.9287, 64.9512, 64.9737, 64.9962, 65.0188,
    65.0413, 65.0638, 65.0863, 65.1088, 65.1313, 65.1538, 65.1763, 65.1988, 65.2213, 65.2438,
    65.2663, 65.2888, 65.3113, 65.3338, 65.3563, 65.3788, 65.4014, 65.4239, 65.4464, 65.4689,
    65.4914, 65.5139, 65.5364, 65.5589, 65.5814, 65.6039, 65.6264, 65.6489, 65.6714, 65.6939,
    65.7164, 65.7389, 65.7614, 65.7839, 65.8065, 65.8290, 65.8515, 65.8740, 65.8965, 65.9190,
    65.9415, 65.9640, 65.9865, 66.0090, 66.0315, 66.0540, 66.0765, 66.0990, 66.1215, 66.1440,
    66.1665, 66.1890, 66.2116, 66.2341, 66.2566, 66.2791, 66.3016, 66.3241, 66.3466, 66.3691,
    66.3916, 66.4141, 66.4366, 66.4591, 66.4816, 66.5041, 66.5266, 66.5491, 66.5716, 66.5941,
    66.6167, 66.6392, 66.6617, 66.6842, 66.7067, 66.7292, 66.7517, 66.7742, 66.7967, 66.8192,
    66.8417, 66.8642, 66.8867, 66.9092, 66.9317, 66.9542, 66.9767, 66.9992, 67.0218, 67.0443,
    67.0668, 67.0893, 67.1118, 67.1343, 67.1568, 67.1793, 67.2018, 67.2243, 67.2468, 67.2693,
    67.2918, 67.3143, 67.3368, 67.3593, 67.3818, 67.4044, 67.4269, 67.4494, 67.4719, 67.4944,
    67.5169, 67.5394, 67.5619, 67.5844, 67.6069, 67.6294, 67.6519, 67.6744, 67.6969, 67.7194,
    67.7419, 67.7644, 67.7869, 67.8095, 67.8320, 67.8545, 67.8770, 67.8995, 67.9220, 67.9445,
    67.9670, 67.9895, 68.0120, 68.0345, 68.0570, 68.0795, 68.1020, 68.1245, 68.1470, 68.1695,
    68.1920, 68.2146, 68.2371, 68.2596, 68.2821, 68.3046, 68.3271, 68.3496, 68.3721, 68.3946,
    68.4171, 68.4396, 68.4621, 68.4846, 68.5071, 68.5296, 68.5521, 68.5746, 68.5971, 68.6197,
    68.6422, 68.6647, 68.6872, 68.7097, 68.7322, 68.7547, 68.7772, 68.7997, 68.8222, 68.8447,
    68.8672, 68.8897, 68.9122, 68.9347, 68.9572, 68.9797, 69.0023, 69.0248, 69.0473, 69.0698,
    69.0923, 69.1148, 69.1373, 69.1598, 69.1823, 69.2048, 69.2273, 69.2498, 69.2723, 69.2948,
    69.3173, 69.3398, 69.3623, 69.3848, 69.4074, 69.4299, 69.4524, 69.4749, 69.4974, 69.5199,
    69.5424, 69.5649, 69.5874, 69.6099, 69.6324, 69.6549, 69.6774, 69.6999, 69.7224, 69.7449,
    69.7674, 69.7899, 69.8125, 69.8350, 69.8575, 69.8800, 69.9025, 69.9250, 69.9475, 69.9700,
    69.9925, 70.0150, 70.0375, 70.0600, 70.0825, 70.1050, 70.1275, 70.1500, 70.1725, 70.1950,
    70.2176, 70.2401, 70.2626, 70.2851, 70.3076, 70.3301, 70.3526, 70.3751, 70.3976, 70.4201,
    70.4426, 70.4651, 70.4876, 70.5101, 70.5326, 70.5551, 70.5776, 70.6002, 70.6227, 70.6452,
    70.6677, 70.6902, 70.7127, 70.7352, 70.7577, 70.7802, 70.8027, 70.8252, 70.8477, 70.8702,
    70.8927, 70.9152, 70.9377, 70.9602, 70.9827, 71.0053, 71.0278, 71.0503, 71.0728, 71.0953,
    71.1178, 71.1403, 71.1628, 71.1853, 71.2078, 71.2303, 71.2528, 71.2753, 71.2978, 71.3203,
    71.3428, 71.3653, 71.3878, 71.4104, 71.4329, 71.4554, 71.4779, 71.5004, 71.5229, 71.5454,
    71.5679, 71.5904, 71.6129, 71.6354, 71.6579, 71.6804, 71.7029, 71.7254, 71.7479, 71.7704,
    71.7929, 71.8155, 71.8380, 71.8605, 71.8830, 71.9055, 71.9280, 71.9505, 71.9730, 71.9955,
    72.0180, 72.0405, 72.0630, 72.0855, 72.1080, 72.1305, 72.1530, 72.1755, 72.1980, 72.2206,
    72.2431, 72.2656, 72.2881, 72.3106, 72.3331, 72.3556, 72.3781, 72.4006, 72.4231, 72.4456,
    72.4681, 72.4906, 72.5131, 72.5356, 72.5581, 72.5806, 72.6032, 72.6257, 72.6482, 72.6707,
    72.6932, 72.7157, 72.7382, 72.7607, 72.7832, 72.8057, 72.8282, 72.8507, 72.8732, 72.8957,
    72.9182, 72.9407, 72.9632, 72.9857, 73.0083, 73.0308, 73.0533, 73.0758, 73.0983, 73.1208,
    73.1433, 73.1658, 73.1883, 73.2108, 73.2333, 73.2558, 73.2783, 73.3008, 73.3233, 73.3458,
    73.3683, 73.3908, 73.4134, 73.4359, 73.4584, 73.4809, 73.5034, 73.5259, 73.5484, 73.5709,
    73.5934, 73.6159, 73.6384, 73.6609, 73.6834, 73.7059, 73.7284, 73.7509, 73.7734, 73.7959,
    73.8185, 73.8410, 73.8635, 73.8860, 73.9085, 73.9310, 73.9535, 73.9760, 73.9985, 74.0210,
    74.0435, 74.0660, 74.0885, 74.1110, 74.1335, 74.1560, 74.1785, 74.2011, 74.2236, 74.2461,
    74.2686, 74.2911, 74.3136, 74.3361, 74.3586, 74.3811, 74.4036, 74.4261, 74.4486, 74.4711,
    74.4936, 74.5161, 74.5386, 74.5611, 74.5836, 74.6062, 74.6287, 74.6512, 74.6737, 74.6962,
    74.7187, 74.7412, 74.7637, 74.7862, 74.8087, 74.8312, 74.8537, 74.8762, 74.8987, 74.9212,
    74.9437, 74.9662, 74.9887, 75.0113, 75.0338, 75.0563, 75.0788, 75.1013, 75.1238, 75.1463,
    75.1688, 75.1913, 75.2138, 75.2363, 75.2588, 75.2813, 75.3038, 75.3263, 75.3488, 75.3713,
    75.3938, 75.4164, 75.4389, 75.4614, 75.4839, 75.5064, 75.5289, 75.5514, 75.5739, 75.5964,
    75.6189, 75.6414, 75.6639, 75.6864, 75.7089, 75.7314, 75.7539, 75.7764, 75.7989, 75.8215,
    75.8440, 75.8665, 75.8890, 75.9115, 75.9340, 75.9565, 75.9790, 76.0015, 76.0240, 76.0465,
    76.0690, 76.0915, 76.1140, 76.1365, 76.1590, 76.1815, 76.2041, 76.2266, 76.2491, 76.2716,
    76.2941, 76.3166, 76.3391, 76.3616, 76.3841, 76.4066, 76.4291, 76.4516, 76.4741, 76.4966,
    76.5191, 76.5416, 76.5641, 76.5866, 76.6092, 76.6317, 76.6542, 76.6767, 76.6992, 76.7217,
    76.7442, 76.7667, 76.7892, 76.8117, 76.8342, 76.8567, 76.8792, 76.9017, 76.9242, 76.9467,
    76.9692, 76.9917, 77.0143, 77.0368, 77.0593, 77.0818, 77.1043, 77.1268, 77.1493, 77.1718,
    77.1943, 77.2168, 77.2393, 77.2618, 77.2843, 77.3068, 77.3293, 77.3518, 77.3743, 77.3968,
    77.4172, 77.4372, 77.4572, 77.4772, 77.4972, 77.5172, 77.5372, 77.5572, 77.5772, 77.5972,
    77.6173, 77.6373, 77.6573, 77.6773, 77.6973, 77.7173, 77.7373, 77.7573, 77.7773, 77.7973,
    77.8173, 77.8373, 77.8573, 77.8773, 77.8973, 77.9173, 77.9373, 77.9573, 77.9773, 77.9973,
    78.0174, 78.0374, 78.0574, 78.0774, 78.0974, 78.1174, 78.1374, 78.1574, 78.1774, 78.1974,
    78.2174, 78.2374, 78.2574, 78.2774, 78.2974, 78.3174, 78.3374, 78.3574, 78.3774, 78.3974,
    78.4175, 78.4375, 78.4575, 78.4775, 78.4975, 78.5175, 78.5375, 78.5575, 78.5775, 78.5975,
    78.6175, 78.6375, 78.6575, 78.6775, 78.6975, 78.7175, 78.7375, 78.7575, 78.7775, 78.7975,
    78.8176, 78.8376, 78.8576, 78.8776, 78.8976, 78.9176, 78.9376, 78.9576, 78.9776, 78.9976,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000,
    79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000, 79.0000
};
int step_time=sizeof(ref_stance_step)/sizeof(ref_stance_step[0]);
const int FTG_time=sizeof(ref_stance_FTG)/sizeof(ref_stance_FTG[0]);
const float standingAngle=ref_stance_FTG[FTG_time-1];
float sittingAngle = 79; //default 79
float tSittingDown = 4 ; //default 4

int trajectoryLength = 51;
float bentAngle = 115; //default 115
//bentAngle = 115;


