#ifndef GEN_H
#define GEN_H

#include "mbed.h"

extern const float ref_stance_step[];
extern const float ref_stance_step095[];
extern const float ref_stance_step100[];
extern const float ref_stance_step105[];
extern const float ref_stance_step110[];
extern const float ref_stance_step115[];
extern const float ref_stance_step120[];
extern const float ref_stance_step125[];
extern const float ref_stance_step130[];

extern const float ref_swing_step[];
extern const float ref_swing_step095[];
extern const float ref_swing_step100[];
extern const float ref_swing_step105[];
extern const float ref_swing_step110[];
extern const float ref_swing_step115[];
extern const float ref_swing_step120[];
extern const float ref_swing_step125[];
extern const float ref_swing_step130[];

extern const float ref_stance_FTG[];
extern const float ref_swing_FTG[];
extern const float ref_stance_FS[];
extern const float ref_swing_FS[];
extern const float ref_sit2stand[];
extern const float ref_stand2sit[];
extern const float standingAngle; //angle of the exo when standing
extern float sittingAngle; //angle of the exo when seated


extern const float tStandingUp;
extern float tSittingDown;
extern const float tFirstStep;
extern const float tStep;
extern const float tNextStep;
extern const float tStepMod;
extern const float tFeetTogether;
extern const float tLockKneeFirstStep;
extern const float tLockKneeStep;

extern int step_time;

// blending functions
extern const float t_blend_home2bent;
extern const float t_blend_home2stand;
extern const float t_blend_home2sit;
extern const float t_blend_step;
extern const float t_blend_FS;
extern const float t_blend_FTG;
extern const float t_blend_standUp;
extern const float t_blend_sitDown;

extern float bentAngle; //angle of the exo when bent forward
extern float blend_e0_R;
extern float blend_e0_L;
extern float blend_R;
extern float blend_L;

extern void initialize_GaitTrajectories();

extern void initialize_blend(float posRef_L0, float posRef_R0, float t_blend);
extern void initialize_blend_from_reference(float posRef_L0, float posRef_R0, float t_blend);

extern void blendToTarget(float t, float t_blend, float posRefTarget_L, float posRefTarget_R);

//extern void blendToBent(float t,float t_blend);

//extern void blendToStand(float t,float t_blend);

//extern void blendToSit(float t,float t_blend);

extern void gaitGen(float *ref_L,float *ref_R,float t,float t_max, float t_blend);

extern void linear_gaitGen(float target_R,float target_L,float t,float t_max);

#endif