#ifndef HIPCONTROL_H
#define HIPCONTROL_H

/**
* Copyright (c) 2012-2014
* All rights reserved.
*
 *
 * by Bradley Perry
 *
*/


/**
* Control strategys for Daniel's Device
*
* @file control.h
* @author Bradley Perry
*
* @brief Control algorithms
*/

//TODO: (Brad) Port to base-class structure

#include "mbed.h"
#include "filter.h"

class HipControl
{
public:
    HipControl(PinName pwm, PinName dirpin);

    /**
    * Feedback linearization and gain scheduling controller.  Used for all hip trajectory following.
    * @param ref Reference point to track.
    * @param pos Current position in degrees
    * @param Kp Proportional gain
    * @param Kd Derivative gain
    * @param sat Commanded current saturation
    */
    //class
    void FL(float ref, float pos);

    /**
    * Vanilla PD controller for set-point tracking.  Mostly used for haptics.
    * @param ref Reference point to track.
    * @param pos Current position in degrees
    * @param Kp Proportional gain
    * @param Kd Derivative gain
    * @param sat Commanded current saturation
    */
    //class
    void PD(float ref, float pos);
//class
    void P(float ref, float pos);
    //base method
    void setGains(float P, float D);
    //base method
    void setSat(float limit);
    //base method
    void sampleTime(float time);
    //class
    void openLoop(float input);
    //base method
    float readPWM();
    //class
    void off();
    //base method
    void flip();
    //base method
    void clear();
    //base method
    void pwmPeriod(float a);
private:
    //Controller Parameters
    //const float Kp=.05;
    PwmOut _pwm;
    DigitalOut _dir;
    float Kp;
    /**
    * Initial proportional gain before cosine gain schedule
    */
    const float Kp0;
    /**
    * Derivative gain
    */
    float Kd;
    /**
    * Commanded current saturation
    */
    float sat;
    float u;
    float u_prev;
    float error[2];
    //sample period
    float _sample_period;
    int sign;
    filter controlFilter;
};

//Controller Parameters


/**
* Counter for proportional gain cosine gain scheduling
*/
/**
* Vector to store error data
*/

/**
* Cosine magnitude for gain scheduling
*/
/**
* Cosine frequency for gain scheduling
*/
/**
* Offset for gain scheduling
*/

#endif



