#ifndef INITDATABED_H
#define INITDATABED_H

#include "mbed.h"
#include "MODSERIAL.h"
#include "BluetoothComm.h"
#include "SDFile.h"

extern MODSERIAL xbeeUI;  // left xbee

extern Serial pc;
extern SPISlave comm; // mosi, miso, sclk, ssel

// amplifier power on
extern DigitalOut mainPower; // power to board/motors etc

// various LEDs
extern DigitalOut statusLed;
extern DigitalOut boardLed1;
extern DigitalOut boardLed2;
extern DigitalOut boardLed3;
extern DigitalOut boardLed4;

extern DigitalIn leftFault;
extern DigitalIn rightFault;

extern BluetoothComm phone;

extern CAN BMS;
extern CANMessage msg;

extern SDFileSystem sd;
extern SDFile err;
extern SDFile readData;
extern SDFile param;
extern SDFile testFile;
extern Ticker interrupt;

#endif

extern void initializeDatabed();