#include "mbed.h"
#include "MODSERIAL.h"
#include "BluetoothComm.h"
#include "SDFile.h"

MODSERIAL xbeeUI(p28, p27); //XBee UI crutch communication

Serial pc(USBTX, USBRX);
SPISlave comm(p5, p6, p7, p8); // mosi, miso, sclk, ssel

// amplifier power on
DigitalOut mainPower(p26); // power to board/motors etc

//inhibit pins
DigitalOut inhibit_L(p24);
DigitalOut inhibit_R(p25);

// various LEDs
DigitalOut statusLed(p15);
DigitalOut boardLed1(LED1);
DigitalOut boardLed2(LED2);
DigitalOut boardLed3(LED3);
DigitalOut boardLed4(LED4);

//Amplifier fault pins
DigitalIn leftFault(p21);
DigitalIn rightFault(p22);
SDFileSystem sd(p11, p12, p13, p14, "sd");
//SDFileSystem sd(p5, p6, p7, p19, "sd");
SDFile err("/sd/", "error.txt", true);
SDFile readData("/sd/", "data.txt", false);
SDFile param("/sd/", "param.txt", false);
SDFile testFile("/sd/", "test.txt", false);
CAN BMS(p30, p29);
CANMessage msg;
Ticker interrupt;

BluetoothComm phone(p9, p10);
//BluetoothComm phone(p13, p14);
void initializeDatabed() {
    xbeeUI.baud(115200);
   // printf("setting pc baud ...\r\n");
    pc.baud(921600);
    //printf("setting comm freq\r\n");   
    comm.frequency(1000000);
    comm.format(8,1);
    inhibit_L=1;
    inhibit_R=1;
    BMS.frequency(250000);

    wait(1);
    printf("Starting databed...\r\n");

}
