#include "mbed.h"
#include "TSISensor.h"

// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx
TSISensor tsi;
DigitalOut leds[4] = { PTA13, PTD5, PTD0, PTD2 };

Thread thread1(osPriorityNormal, 1000); // thread for LED1
Thread thread2(osPriorityNormal, 1000); // thread for LED2
Thread thread3(osPriorityNormal, 1000); // thread for LED3
Thread thread4(osPriorityNormal, 1000); // thread for LED4 

void led1_thread() {
    while (true) {
        Thread::signal_wait(0x1);
        leds[0] = !leds[0];
    }
}
void led2_thread() {
    while (true) {
        Thread::signal_wait(0x1);
        leds[1] = !leds[1];
    }
}
void led3_thread() {
    while (true) {
        Thread::signal_wait(0x1);
        leds[2] = !leds[2];
    }
}
void led4_thread() {
    while (true) {
        Thread::signal_wait(0x1);
        leds[3] = !leds[3];
    }
}

int main(void) {
    enum states { none, leftOut, leftIn, rightIn, rightOut };
    states state = none;
    
    for (int i=0; i<4; i++) { // turn off all leds
        leds[i] = 0;
    }
    
    thread1.start(&led1_thread);
    thread2.start(&led2_thread);
    thread3.start(&led3_thread);
    thread4.start(&led4_thread);
    
    while (true) {
        uint8_t pos = tsi.readDistance() ;  // Distance is between 0 and 39
                                          // When no touch --> 0
                                          // Left --> low value  Right --> high value
        pc.printf("%d", pos) ;  
        pc.putc(' ') ;
        
        switch (state) {
            case none:
                pc.printf("none\n\r");
                if (pos > 3 && pos < 9) {
                    state = leftOut;
                    thread1.signal_set(0x1);
                } else if (pos > 13 && pos < 19) {
                    state = leftIn;
                    thread2.signal_set(0x1);
                } else if (pos > 23 && pos < 29) {
                    state = rightIn;
                    thread3.signal_set(0x1);
                } else if (pos > 33) {
                    state = rightOut;
                    thread4.signal_set(0x1);
                }
                break;
            case leftOut:
                pc.printf("leftOut\n\r");
                if (pos < 3 || pos > 9) {
                    state = none;
                }
                break;
            case leftIn:
                pc.printf("leftIn\n\r");
                if (pos < 13 || pos > 19) {
                    state = none;
                }
                break;
            case rightIn:
                pc.printf("rightIn\n\r");
                if (pos < 23 || pos > 29) {
                    state = none;
                }
                break;
            case rightOut:
                pc.printf("rightOut\n\r");
                if (pos < 33) {
                    state = none;
                }
                break;
        }
        
        Thread::wait(200);  // This polling rate is too slow - increase it
                            // The slower rate maks it easier to output on the terminal
    }
}