#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

Thread triggerThread ; // thread to check trigger state

enum states { flat, right, left, down, up, over, intermediate };

// Had to implement with shared variable because with mailbox it did not work
volatile states accState = intermediate; // code for shared variable implementation

// code for Mail implementation, not working
// Message type
/*typedef struct {
  states accState; // Accelerometer state 
} message_t;

// Mail box
Mail<message_t, 6> mailbox;*/

Serial pc(USBTX, USBRX); // tx, rx

void stateOfTrigger() {
    DigitalOut redLed(LED1);
    DigitalOut greenLed(LED2);
    enum systemStates { flat_start, flat_end, right_start, right_end, up_start, up_end, flat_final, seq_error, time_error };
    Timer timer;
    
    redLed = 1;
    greenLed = 1;
    systemStates state = flat_start;
    //states accState = flat; // code for Mail implementation, not working
    
    while (true) {       
        // code for Mail implementation, not working correctly
        /*osEvent evt = mailbox.get(); // wait for mail 
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            accState = mess->accState;
            mailbox.free(mess) ;  // free the message space
        }*/
        if (accState != intermediate) {       
            switch (state) {
                case flat_start:
                    if (accState == flat) {
                        pc.printf("Flat_start\n\r");
                        timer.start();
                        pc.printf("%d", timer.read_ms());
                        if (timer.read() >= 10) {
                            timer.stop();
                            timer.reset();
                            state = flat_end;
                        }
                    } else {
                        timer.stop();
                        timer.reset();
                        if (accState == right) {
                            state = time_error;
                        } else {
                            state = seq_error;
                        }
                    }
                    break;
                case flat_end:
                    pc.printf("Flat_end\n\r");
                    redLed = 1;
                    if (accState == right) {
                        state = right_start;
                    } else {
                        if (accState != flat) {
                            state = seq_error;
                        }
                    }
                    break;
                case right_start:
                    if (accState == right) {
                        pc.printf("Right_start\n\r");
                        timer.start();
                        pc.printf("%d", timer.read_ms());
                        if (timer.read() >= 2) {
                            state = right_end;
                        }
                    } else {
                        timer.stop();
                        timer.reset();
                        if (accState == up) {
                            state = time_error;
                        } else {
                            state = seq_error;
                        }
                    }
                    break;
                case right_end:
                    pc.printf("Right_end\n\r");
                    pc.printf("%d", timer.read_ms());
                    if (timer.read() <= 6) {
                        if (accState == up) {
                            timer.stop();
                            timer.reset();
                            state = up_start;
                        } else {
                            if (accState != right) {
                                timer.stop();
                                timer.reset();
                                state = seq_error;
                            }
                        }
                    } else {
                        timer.stop();
                        timer.reset();
                        state = time_error;
                    }
                    break;
                case up_start:
                    if (accState == up) {
                        pc.printf("Up_start\n\r");
                        timer.start();
                        pc.printf("%d", timer.read_ms());
                        if (timer.read() >= 4) {
                            state = up_end;
                        }
                    } else {
                        timer.stop();
                        timer.reset();
                        if (accState == flat) {
                            state = time_error;
                        } else {
                            state = seq_error;
                        }
                    }
                    break;
                case up_end:
                    pc.printf("Up_end\n\r");
                    pc.printf("%d", timer.read_ms());
                    if (timer.read() <= 8) {
                        if (accState == flat) {
                            timer.stop();
                            timer.reset();
                            state = flat_final;
                        } else {
                            if (accState != up) {
                                timer.stop();
                                timer.reset();
                                state = seq_error;
                            }
                        }
                    } else {
                        timer.stop();
                        timer.reset();
                        state = time_error;
                    }
                    break;
                case flat_final:
                    pc.printf("Flat_final\n\r");
                    greenLed = 0;
                    break;
                case seq_error:
                    redLed = 0;
                    pc.printf("State sequence error\n\r");
                    if (accState == flat) {
                        state = flat_start;
                    }
                    break;
                case time_error:
                    redLed = 0;
                    pc.printf("State time error\n\r");
                    if (accState == flat) {
                        state = flat_start;
                    }
                    break;
            }
        }
        Thread::wait(100);
    }
}

int main(void)
{    
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    
    triggerThread.start(callback(stateOfTrigger));    
    
    states state = intermediate;
    states oldState = intermediate;
    states oldStableState = intermediate;
    int stateCounter = 0;
    int const stableState = 3;

    pc.printf("MMA8451 ID: %d\n\r", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
        float threshold = 0.10;
                            
        if (z > 1 - threshold && z < 1 + threshold) {
            state = flat;
        } else if (z > -1 - threshold && z < -1 + threshold) {
            state = over;
        } else if (y > 1 - threshold && y < 1 + threshold) {
            state = left;
        } else if (y > -1 - threshold && y < -1 + threshold) {
            state = right;
        } else if (x > 1 - threshold && x < 1 + threshold) {
            state = down;
        } else if (x > -1 - threshold && x < -1 + threshold) {
            state = up;
        } else {
            state = intermediate;
        }
        
        if (state != intermediate) {
            if (state == oldState) {
                if (stateCounter < stableState) {
                    stateCounter ++;
                }
            } else {
                oldState = state;
                stateCounter = 0;
            }
        }
        
        // state has changed and is stable
        if (stateCounter == stableState && oldStableState != state) {
            oldStableState = state;
            
            switch (state) {
                case flat:
                    pc.printf("flat\n\r");
                    break;
                case right:
                    pc.printf("right\n\r");
                    break;
                case left:
                    pc.printf("left\n\r");
                    break;
                case down:
                    pc.printf("down\n\r");
                    break;
                case up:
                    pc.printf("up\n\r");
                    break;
                case over:
                    pc.printf("over\n\r");
                    break;
            }
            // code for Mail implementation, not working
            /*message_t *mess = mailbox.alloc();
            if (mess) {
                mess->accState = state;
                mailbox.put(mess);
            }*/
            accState = state; // code for shared variable implementation
        }
        
        Thread::wait(200);
    }
}