#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

PwmOut rled(LED1);
PwmOut gled(LED2);
PwmOut bled(LED3);

void setLeds(float red, float green, float blue) {
    rled = red;
    gled = green;
    bled = blue;
}

int main(void)
{    
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    Serial pc(USBTX, USBRX); // tx, rx
    
    enum states { flat, right, left, down, up, over, intermediate };
    states state = intermediate;
    states oldState = intermediate;
    states oldStableState = intermediate;
    int stateCounter = 0;
    int const stableState = 3;

    pc.printf("MMA8451 ID: %d\n\r", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
        float threshold = 0.10;
                            
        if (z > 1 - threshold && z < 1 + threshold) {
            state = flat;
        } else if (z > -1 - threshold && z < -1 + threshold) {
            state = over;
        } else if (y > 1 - threshold && y < 1 + threshold) {
            state = left;
        } else if (y > -1 - threshold && y < -1 + threshold) {
            state = right;
        } else if (x > 1 - threshold && x < 1 + threshold) {
            state = down;
        } else if (x > -1 - threshold && x < -1 + threshold) {
            state = up;
        } else {
            state = intermediate;
        }
        
        if (state != intermediate) {
            if (state == oldState) {
                if (stateCounter < stableState) {
                    stateCounter ++;
                }
            } else {
                oldState = state;
                stateCounter = 0;
            }
        } else {
            setLeds(0.99, 0.99, 0.99); // dimmed white led
        }
        
        // print the state
        if (stateCounter == stableState && oldStableState != state) {
            oldStableState = state;
            switch (state) {
                case flat:
                    pc.printf("flat\n\r");
                    setLeds(0.0, 0.0, 1.0); // yellow led
                    break;
                case right:
                    pc.printf("right\n\r");
                    setLeds(1.0, 0.0, 0.0); // light-blue led
                    break;
                case left:
                    pc.printf("left\n\r");
                    setLeds(1.0, 1.0, 0.0); // blue led
                    break;
                case down:
                    pc.printf("down\n\r");
                    setLeds(0.0, 1.0, 0.0); // pink led
                    break;
                case up:
                    pc.printf("up\n\r");
                    setLeds(0.0, 1.0, 1.0); // red led
                    break;
                case over:
                    pc.printf("over\n\r");
                    setLeds(1.0, 0.0, 1.0); // green led
                    break;
            }
        }
        
        Thread::wait(300);
    }
}
