#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn redButton(PTD0);
InterruptIn blueButton(PTD5);
DigitalOut redLed(LED_RED);
DigitalOut blueLed(LED_BLUE);

volatile int redPressEvent = 0;
volatile int bluePressEvent = 0;

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void redButtonCallback(){
    redPressEvent = 1 ;
}

void blueButtonCallback(){
    bluePressEvent = 1 ;
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    // LEDa are on by default
    redLed = 0;
    blueLed = 0;
    
    int flashPeriod = 5;
    int redBtnCounter = flashPeriod;
    int blueBtnCounter = flashPeriod;
    
    bool redIsFlashing = true;
    bool blueIsFlashing = true;
    
    redButton.mode(PullUp);             // Ensure button i/p has pull up
    redButton.fall(&redButtonCallback) ;   // Attach function to falling edge
    blueButton.mode(PullUp);             // Ensure button i/p has pull up
    blueButton.fall(&blueButtonCallback) ;   // Attach function to falling edge   

    while(true) {
        Thread::wait(100);
        if (redIsFlashing) {
            redBtnCounter--;
        }
        if (blueIsFlashing) {
            blueBtnCounter--;
        }
        
        if (redBtnCounter == 0) {
            redLed = !redLed;
            redBtnCounter = flashPeriod;
        }
        if (blueBtnCounter == 0) {
            blueLed = !blueLed;
            blueBtnCounter = flashPeriod;
        }
        
        // Stop flashing (freeze in the current state) every time the button is pressed
        if (redPressEvent) {
            redIsFlashing = !redIsFlashing;
            redPressEvent = 0; // Clear the event variable
        }
        if (bluePressEvent) {
            blueIsFlashing = !blueIsFlashing;
            bluePressEvent = 0; // Clear the event variable
        }
    }
}