#include "mbed.h"
 
DigitalOut led1(LED1);

Serial pc(USBTX, USBRX); // tx, rx

Thread thread;

void led1_thread(int *speed) {
    while (true) {
        led1 = !led1;
        Thread::wait(*speed);
    }
}
 
int main() {
    int speed = 200;
    thread.start(callback(led1_thread, &speed));
    
    char userInput;
    pc.printf("Enter a character>");
    while(1) {
        userInput = pc.getc();
        switch(userInput) {
            case 'f':
                pc.printf("faster");
                speed = speed - 50;
                break;
            case 's':
                pc.printf("slower");
                speed = speed + 50;
                break;
        }
        
        thread.start(callback(led1_thread, &speed));
        Thread::wait(500);
    }
}
