#include "mbed.h"

Serial pc(USBTX, USBRX);

double xLoc, yLoc;

DigitalOut myled(LED1);
DigitalOut control(p21);

DigitalOut charge1M(p5);//1M output
DigitalOut charge100K(p6);//100K output
DigitalOut charge10K(p7);//10K output
DigitalOut charge1K(p8);//1K output
DigitalOut charge100(p9);//100 output

AnalogIn fullIndic(p15);
AnalogIn emptyIndic(p19);
DigitalInOut pin20(p20);
Timer t;
int timeElaps;
float microFarads;
double changeTime = 1000;

double R100 = 98.94;
double R1K = 981.7;
double R10K = 9922.0;
double R100K = 99200.0;
double R1M = 987200.0;

double Rval = 0.0;

bool fail;
bool leave = true;
float RC=0.54;//53;

char startSig[5];

bool checkForC(void)
{
    startSig[0] = pc.getc();
    if(startSig[0] == 'c'){return true;}
    return false;
}

void checkDischarge(void)
{
    
    myled = 1;
    
    charge1M = 0;
    charge100K = 0;
    charge10K = 0;
    charge1K = 0;
    charge100 = 0;
    
    control = 1;
    //bool success = true;
    charge1M = 0;
    pin20.output();
    pin20 = 0;
    while(fullIndic.read() > 0.07){}//pc.printf("read: %f\n",fullIndic.read());}
}

void start1M(void)
{
    Rval = R1M;
    fail = false;
    control = 0;
    pin20.input();
    pin20.mode(PullNone);
    charge1M = 1;
    t.reset();
    t.start();
    
    while(fullIndic < RC){
        if(t.read_ms() > changeTime){
            fail = true;
            charge1M = 0;
            break;
        }
    }
    t.stop();
}

void start100K(void)
{
    Rval = R100K;
    fail = false;
    control = 0;
    pin20.input();
    pin20.mode(PullNone);
    charge100K = 1;
    t.reset();
    t.start();
    
    while(fullIndic < RC){
        if(t.read_ms() > changeTime){
            fail = true;
            charge100K = 0;
            break;
        }
    }
    t.stop();
}

void start10K(void)
{
    Rval = R10K;
    fail = false;
    control = 0;
    pin20.input();
    pin20.mode(PullNone);
    charge10K = 1;
    t.reset();
    t.start();
    
    while(fullIndic < RC){
        if(t.read_ms() > changeTime){
            fail = true;
            charge10K = 0;
            break;
        }
    }
    t.stop();
}

void start1K(void)
{
    Rval = R1K;
    fail = false;
    control = 0;
    pin20.input();
    pin20.mode(PullNone);
    charge1K = 1;
    t.reset();
    t.start();
    
    while(fullIndic < RC){
        if(t.read_ms() > changeTime){
            fail = true;
            charge1K = 0;
            break;
        }
    }
    t.stop();
}

void start100(void)
{
    Rval = R100;
    fail = false;
    control = 0;
    pin20.input();
    pin20.mode(PullNone);
    charge100 = 1;
    t.reset();
    t.start();
    
    while(fullIndic < RC){
        /*if(t.read_ms() > changeTime){
            fail = true;
            charge100 = 0;
            break;
        }*/
    }
    t.stop();
}

void sendErrorMsg(void){
    pc.printf("could not read capacitor\n");    
}

int main() {
    while(1){
    
    leave = true;
    startSig [0] = pc.getc();
    while(startSig[0] != 's'){startSig [0] = pc.getc();}
    
    for(int count = 0; count < 10; count++){
    
    checkDischarge();
    myled = 0;
    start1M();
    //pc.printf("1M\n");

    if(fail){
        checkDischarge();
        
        //pc.printf("100K\n");
        if(fail){// && leave){
            checkDischarge();
            start10K();

            //pc.printf("10K\n");
            if(fail){// && leave){
                checkDischarge();
                start1K();

                if(fail){// && leave){
                    checkDischarge();
                    start100();

                    if(fail){}//&& leave){}//sendErrorMsg();}
                }    
            }
        }
    }
    
    
    timeElaps = t.read_ms();
    t.reset();
    t.start();
    t.stop();
    
    microFarads = (((double)timeElaps-t.read_ms())/Rval);
    pc.printf("%f", microFarads);
    //pc.printf("This is the cap: %f", microFarads);
    }
    }
}
