//Code for mbed C# Piano project
//Based on RPC Example code

#include "mbed.h"
#include "mbed_rpc.h"


Serial pc(USBTX, USBRX);//Replace With Bluetooth

//define RPC function
void moveTo(Arguments *in, Reply *out);
RPCFunction rpcMove(&moveTo, "moveTo");

//Speaker Control
double pwmVal;
PwmOut PWM(p21);

int main() {
        
    char buf[256], outbuf[256];
    while(1) {
        //Get Serial Arguments
        pc.gets(buf, 256);
        //Call the static call method on the RPC class
        RPC::call(buf, outbuf); 
        
    }
}

// Make sure the method takes in Arguments and Reply objects.
void moveTo (Arguments *in, Reply *out)   {
    bool success = true;
    pwmVal = in->getArg<float>();
    
    PWM.period(1.0/(pwmVal));//Set speaker Frequency
    PWM = 0.5;//Set speaker amplitude
    char buffer[200];
}
