/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "stats_report.h"
#include <stdio.h> 
#include <string.h> 
#include <stdlib.h>

DigitalOut output(PTA10);
DigitalIn input(PTD9);
Timer timer1;
Timer timer2;
Timer timer_pwm;

Serial pc(USBTX, USBRX); //create a Serial object

int main() {
    pc.baud(115200);
    int period = 50000;
    float duty_cycle = 0.5;
    
    output.write(0);

    timer1.start();
    timer2.start();
    timer_pwm.start();
     
    int prev = 0;
    int count = 0;
    int t = 0;
    float d = 0;
    int time_on = 0;
   
    while(1) {
        //pc.printf("beginning of loop\n");
        int time_on_output = duty_cycle * period;
        int curr_time = timer_pwm.read_us();
        //pc.printf("%i %i\n", time_on, curr_time);
        if (curr_time > period) {
            output.write(1);
            timer_pwm.reset();
            //pc.printf("outputting 1\n");
        } else if (curr_time > time_on_output) {
            output.write(0);
            //pc.printf("outputting 0\n");
        } 
        
        char buffer1[20];
        char buffer2[20];
        if (pc.readable()) {
            memset(buffer1, 0, 20*sizeof(char));
            memset(buffer2, 0, 20*sizeof(char));
            pc.scanf("%s", &buffer1);
            pc.scanf("%s", &buffer2);
            
//            pc.printf("%s ", buffer1);
//            pc.printf("%s\n", buffer2);
            
            int input_per_i = atoi(buffer1);
            float input_duty_f = atof(buffer2);
            
//            pc.printf("%i ", input_per_i);
//            pc.printf("%f ", input_duty_f);
            
            if (input_per_i < 1000 || input_per_i > 60000 || input_duty_f < 0 || input_duty_f > 1) {
                pc.printf("mbed> ERROR\n");
            } else { 
                period = input_per_i;
                duty_cycle = input_duty_f;
//            output.period_us(atoi(input_per));
//            output.write(atof(input_duty));
            }
        }
        
        int curr = input.read();
        if (curr) {
            if (prev == 0) {
                timer2.reset();
                if (count == 0) {
                    t = timer1.read_us();
                    d = float(time_on) / t;
                    pc.printf("mbed> %i, %.3f\n", t, d);
                }
                count = (count + 1) % 10;
                timer1.reset();
            }
            prev = 1;
        } else {
            if (prev == 1) {
                time_on = timer2.read_us();
            }
            prev = 0;
        }
    }
}
