/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: Target board general functions implementation

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#include "mbed.h"
#include "board.h"

DigitalIn I2cInterrupt( D5 );
I2C I2c(I2C_SDA, I2C_SCL);

DigitalOut Pc7( D9 );
DigitalIn Pc1( A4 );

//DigitalIn UsrButton( PC_13 );
DigitalIn UsrButton( D10 );

DigitalOut Led( D6 );

/* Instantiate the expansion board */
XNucleoIKS01A2 *mems_expansion_board = XNucleoIKS01A2::instance(D14, D15, NC, NC);
 
/* Retrieve the composing elements of the expansion board */
LSM303AGRMagSensor *magnetometer = mems_expansion_board->magnetometer;
HTS221Sensor *hum_temp = mems_expansion_board->ht_sensor;
LPS22HBSensor *press_temp = mems_expansion_board->pt_sensor;
LSM6DSLSensor *acc_gyro = mems_expansion_board->acc_gyro;
LSM303AGRAccSensor *accelerometer = mems_expansion_board->accelerometer;

SX1272MB2xAS Radio( NULL );

void BoardInit( void )
{

    /* Enable all sensors */
    hum_temp->enable();
    press_temp->enable();
    magnetometer->enable();
    accelerometer->enable();
    acc_gyro->enable_x();
    acc_gyro->enable_g();

    TimerTimeCounterInit( );
}

uint8_t BoardGetBatteryLevel( void ) 
{
    return 0xFE;
}

uint32_t BoardGetRandomSeed( void )
{
    return ( ( *( uint32_t* )ID1 ) ^ ( *( uint32_t* )ID2 ) ^ ( *( uint32_t* )ID3 ) );
}

void BoardGetDevEUI( uint8_t *id )
{
    uint32_t DevEuiHWord = 0;

    if( ( id[7] == 0 ) && ( id[6] == 0 ) && ( id[5] == 0 ) && ( id[4] == 0 ) )
    {        
        DevEuiHWord = BoardGetRandomSeed( );
        id[7] = (DevEuiHWord >> 3) & 0xFF;
        id[6] = (DevEuiHWord >> 2) & 0xFF;
        id[5] = (DevEuiHWord >> 1) & 0xFF;
        id[4] = (DevEuiHWord >> 0) & 0xFF;
    }    
}

void BoardGetUniqueId( uint8_t *id )
{
    id[7] = ( ( *( uint32_t* )ID1 )+ ( *( uint32_t* )ID3 ) ) >> 24;
    id[6] = ( ( *( uint32_t* )ID1 )+ ( *( uint32_t* )ID3 ) ) >> 16;
    id[5] = ( ( *( uint32_t* )ID1 )+ ( *( uint32_t* )ID3 ) ) >> 8;
    id[4] = ( ( *( uint32_t* )ID1 )+ ( *( uint32_t* )ID3 ) );
    id[3] = ( ( *( uint32_t* )ID2 ) ) >> 24;
    id[2] = ( ( *( uint32_t* )ID2 ) ) >> 16;
    id[1] = ( ( *( uint32_t* )ID2 ) ) >> 8;
    id[0] = ( ( *( uint32_t* )ID2 ) );
}

