#include "speech.h"
#include "spells.h"
#include "globals.h"
#include "hardware.h"

/**
 * Draw the speech bubble background.
 * Use this file to draw speech bubbles, look at the uLCD libraries for printing
 * text to the uLCD (see graphics.cpp note for link)
 */
static void draw_horizontal_speech_bubble();
static void draw_vertical_speech_bubble();
/**
 * Erase the speech bubble.
 */
 void erase_horizontal_speech_bubble();
 void erase_vertical_speech_bubble();
/**
 * Draw a single line of the speech bubble.
 * @param line The text to display
 * @param which If TOP, the first line; if BOTTOM, the second line.
 */
#define TOP    0
#define MID1   1
#define BOTTOM 3
static void draw_horizontal_speech_line(const char* line, int which);
static void draw_vertical_speech_line(const char* line, int which);
#define SPEECH_X 10
#define SPEECH_Y 80
#define BLACK  0x000000
#define WHITE  0xFFFFFF

/**
 * Delay until it is time to scroll.
 */
static void horizontal_speech_bubble_wait();
static void vertical_speech_bubble_wait();


void draw_horizontal_speech_bubble()
{
    uLCD.rectangle(SPEECH_X,SPEECH_Y,SPEECH_X+110,SPEECH_Y+30,WHITE);       //border 
    uLCD.filled_rectangle(SPEECH_X+1,SPEECH_Y+1,SPEECH_X+109,SPEECH_Y+29,BLACK);
    
}

void draw_vertical_speech_bubble()
{
    uLCD.rectangle(SPEECH_Y,SPEECH_X+10,SPEECH_Y+40,SPEECH_X+70,WHITE);       //border 
    uLCD.filled_rectangle(SPEECH_Y+1,SPEECH_X+11,SPEECH_Y+39,SPEECH_X+69,BLACK);
    
}

void erase_horizontal_speech_bubble()
{
    uLCD.filled_rectangle(SPEECH_X,SPEECH_Y,SPEECH_X+110,SPEECH_Y+30,BLACK);
    wait(.3);
}

void erase_vertical_speech_bubble()
{
    uLCD.filled_rectangle(SPEECH_Y,SPEECH_X+10,SPEECH_Y+40,SPEECH_X+70,BLACK);
    wait(.3);
}


void draw_horizontal_speech_line(const char* line, int which)
{
    int text_x = 2;
    int text_y;
    if(which == TOP){
        text_y = 11;
    }
    if(which == BOTTOM){
        text_y = 12;
    }
    
    uLCD.color(GREEN);
    uLCD.textbackground_color(BLACK);
    uLCD.text_mode(OPAQUE);
    uLCD.color(GREEN);
    
    while(*line){
        pc.printf("%c\n", *line);
        uLCD.locate(text_x,text_y);
        uLCD.printf("%c\n",*line);
        text_x++;
        line = line + 1;
        }
    
}

void draw_vertical_speech_line(const char* line, int which)
{
    int text_x = 12;
    int text_y;
    if(which == TOP){
        text_y = 4;
    }
    
    if(which == MID1){
        text_y = 6;
    }
    
    
    if(which == BOTTOM){
        text_y = 8;
    }
    
    uLCD.color(GREEN);
    uLCD.textbackground_color(BLACK);
    uLCD.text_mode(OPAQUE);
    uLCD.color(GREEN);
    
    while(*line){
        pc.printf("%c\n", *line);
        uLCD.locate(text_x,text_y);
        uLCD.printf("%c\n",*line);
        uLCD.locate(text_x,text_y);
        uLCD.printf("%c\n",*line);
        uLCD.locate(text_x,text_y);
        uLCD.printf("%c\n",*line);
        text_x++;
        line = line + 1;
        }
    
}


void horizontal_speech_bubble_wait1()
{
    GameInputs inputs = read_inputs();
    while(inputs.b1){
        wait(.1);
        inputs = read_inputs();
    }
}

void horizontal_speech_bubble_wait2()
{
    GameInputs inputs = read_inputs();
    while(inputs.b2&&inputs.b1&&inputs.b3){
        wait(.1);
        inputs = read_inputs();
    }
}

void vertical_speech_bubble_wait1()
{
    GameInputs inputs = read_inputs();
    
    int magic;
    
    while(inputs.b2&&inputs.b1&&inputs.b3){
        wait(.1);
        inputs = read_inputs();
        magic = spell();
        
    }
}

void vertical_speech_bubble_wait2()
{
    GameInputs inputs = read_inputs();
    
    int money;
    
    while(inputs.b2&&inputs.b1&&inputs.b3){
        wait(.1);
        inputs = read_inputs();
        money = store();
        
    }
}


void horizontal_speech1(const char* line1, const char* line2)
{
    draw_horizontal_speech_bubble();
    draw_horizontal_speech_line(line1, TOP);
    draw_horizontal_speech_line(line2, BOTTOM);
    horizontal_speech_bubble_wait1();
    erase_horizontal_speech_bubble();
}

void horizontal_speech2(const char* line1, const char* line2)
{
    draw_horizontal_speech_bubble();
    draw_horizontal_speech_line(line1, TOP);
    draw_horizontal_speech_line(line2, BOTTOM);
    horizontal_speech_bubble_wait2();
    erase_horizontal_speech_bubble();
}

//const char* line1, const char* line2
void vertical_speech1(const char* line1, const char* line2, const char* line3)
{
    draw_vertical_speech_bubble();
    draw_vertical_speech_line(line1, TOP);
    draw_vertical_speech_line(line2, MID1);
    draw_vertical_speech_line(line3, BOTTOM);
    vertical_speech_bubble_wait1();
    erase_vertical_speech_bubble();
}

void vertical_speech2(const char* line1, const char* line2, const char* line3)
{
    draw_vertical_speech_bubble();
    draw_vertical_speech_line(line1, TOP);
    draw_vertical_speech_line(line2, MID1);
    draw_vertical_speech_line(line3, BOTTOM);
    vertical_speech_bubble_wait2();
    erase_vertical_speech_bubble();
}

void long_speech(const char* lines[], int n)
{
}
