#include "map.h"

#include "globals.h"
#include "graphics.h"

#define NumBuckets 5
#define NumMaps 3
#define HEIGHT 50
#define WIDTH  50

/**
 * The Map structure. This holds a HashTable for all the MapItems, along with
 * values for the width and height of the Map.
 * In this file you need to define how the map will be structured. IE how will
 * you put values into the map, pull them from the map. Remember a "Map" variable
 * is a hashtable plus two ints (see below)
 * You will have more than one map variable, one will be the main map with it's own hashtable.
 * Then you'll have a second map with another hashtable
 * You should store objects into the hashtable with different properties (spells
 * etc)
 */
struct Map {
    HashTable* items;
    int w, h;
};

/**
 * Storage area for the maps.
 * This is a global variable, but can only be access from this file because it
 * is static.
 */
static Map map[NumMaps];
static int active_map;

/**
 * The first step in HashTable access for the map is turning the two-dimensional
 * key information (x, y) into a one-dimensional unsigned integer.
 * This function should uniquely map (x,y) onto the space of unsigned integers.
 */
static unsigned XY_KEY(int X, int Y)
{
    // TODO: Fix me!
    unsigned int key = WIDTH*X+Y;
    return key;
}

/**
 * This is the hash function actually passed into createHashTable. It takes an
 * unsigned key (the output of XY_KEY) and turns it into a hash value (some
 * small non-negative integer).
 */
unsigned map_hash(unsigned key)
{
    // TODO: Fix me!
    int hash_value = key%NumBuckets;
    return hash_value;
}

void maps_init()
{
    // TODO: Implement!
    // Initialize hash table
    // Set width & height
    
    map[0].items = createHashTable(map_hash,NumBuckets);
    map[0].w = WIDTH;
    map[0].h = HEIGHT;
    
    map[1].items = createHashTable(map_hash,NumBuckets);
    map[1].w = WIDTH-30;
    map[1].h = HEIGHT-30;
    

}

Map* get_active_map()
{
    // There's only one map
    return &map[active_map];
}

int get_map(int m){
    
    return m;
    
    }

Map* set_active_map(int m)
{
    active_map = m;
    return &map[active_map];
}

void print_map()
{
    // As you add more types, you'll need to add more items to this array.
    char lookup[] = {'W', 'P'};
    for(int y = 0; y < map_height(); y++) {
        for (int x = 0; x < map_width(); x++) {
            MapItem* item = get_here(x,y);
            if (item) pc.printf("%c", lookup[item->type]);
            else pc.printf(" ");
        }
        pc.printf("\r\n");
    }
}

int map_width()
{
    return get_active_map()->w;
}

int map_height()
{
    return get_active_map()->h;
}

int map_area()
{
    int area = map_height() * map_width();
    return area;
}

MapItem* get_north(int x, int y)
{
    unsigned int key = XY_KEY(x,y-1);
    MapItem* up = (MapItem*)getItem(get_active_map()->items,key);
    return up;

}

MapItem* get_south(int x, int y)
{
  unsigned int key = XY_KEY(x,y+1);
    MapItem* down = (MapItem*)getItem(get_active_map()->items,key);
    return down;

}

MapItem* get_east(int x, int y)
{
unsigned int key = XY_KEY(x+1,y);
    MapItem* right = (MapItem*)getItem(get_active_map()->items,key);
    return right;

}

MapItem* get_west(int x, int y)
{
    unsigned int key = XY_KEY(x-1,y);
    MapItem* left = (MapItem*)getItem(get_active_map()->items,key);
    return left;

}

MapItem* get_here(int x, int y)
{
    unsigned int key = XY_KEY(x,y);
    MapItem* curr = (MapItem*)getItem(get_active_map()->items,key);
    return curr;
}


void map_erase(int x, int y)
{
    unsigned int key = XY_KEY(x,y);
    
    removeItem(get_active_map()->items,key);
}

void map_delete(int x, int y)
{
    unsigned int key = XY_KEY(x,y);
    
    deleteItem(get_active_map()->items,key);
}

void add_wall(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++) {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = WALL;
        w1->draw = draw_wall;
        w1->walkable = false;
        w1->data = NULL;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}

void add_castle(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++) {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = CASTL;
        w1->draw = draw_castle;
        w1->walkable = false;
        w1->data = NULL;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}

void add_fire(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = CASTL;
    w1->draw = draw_fire;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}


void add_npc(int x, int y)
{
    MapItem*npc = (MapItem*) malloc(sizeof(MapItem));
    npc->type = NPC;
    npc->draw = draw_npc;
    npc->walkable = false;
    npc->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),npc);
    if (val) free(val);
}

void add_npc2(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = NPCT;
    w1->draw = draw_npc2;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}

void add_store(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = CASTL;
    w1->draw = draw_store;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}

void add_merch(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = VILL;
    w1->draw = draw_merch;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}

void add_key(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = KEY;
    w1->draw = draw_key;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}

void add_eye(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = ENEMY;
    w1->draw = draw_eye;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}

void add_goblin(int x, int y, int type)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = type;
    w1->draw = draw_goblin;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}


void add_portal(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = PORTAL;
    w1->draw = draw_portal;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}

void add_kindom(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = KINDOM;
    w1->draw = draw_kindom;
    w1->walkable = false;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}


void add_portal2(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = PORTAl;
    w1->draw = draw_portal2;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}


void add_chest(int x, int y)
{
    MapItem*chest = (MapItem*) malloc(sizeof(MapItem));
    chest->type = CHEST;
    chest->draw = draw_chest;
    chest->walkable = false;
    chest->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),chest);
    if (val) free(val);
}

void add_chest2(int x, int y)
{
    MapItem*chest = (MapItem*) malloc(sizeof(MapItem));
    chest->type = CHESTT;
    chest->draw = draw_chest;
    chest->walkable = false;
    chest->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),chest);
    if (val) free(val);
}

void add_door(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = DOOR;
    w1->draw = draw_door;
    w1->walkable = false;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}

void add_dragon(int x, int y)
{
    MapItem*w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = DRAGON;
    w1->draw = draw_dragon;
    w1->walkable = false;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items,XY_KEY(x,y),w1);
    if (val) free(val);
}




void add_plant(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = PLANT;
    w1->draw = draw_plant;
    w1->walkable = true;
    w1->data = FRUIT;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}