#ifndef GRAPHICS_H
#define GRAPHICS_H



/**
 * Draws the player. This depends on the player state, so it is not a DrawFunc.
 */
void draw_player(int u, int v, int key);

/**
 * Takes a string image and draws it to the screen. The string is 121 characters
 * long, and represents an 11x11 tile in row-major ordering (across, then down,
 * like a regular multi-dimensional array). The available colors are:
 *      R = Red
 *      Y = Yellow
 *      G = Green
 *      D = Brown ("dirt")
 *      5 = Light grey (50%)
 *      3 = Dark grey (30%)
 *      Any other character is black
 * More colors can be easily added by following the pattern already given.
 */
void draw_img(int u, int v, const char* img);

/**
 * DrawFunc functions. 
 * These can be used as the MapItem draw functions.
 */
void draw_nothing(int u, int v);
void draw_wall(int u, int v);
void draw_plant(int u, int v);

/**
 * Draw the upper status bar.
 */
void draw_upper_status(int x, int y, int coin);

/**
 * Draw the lower status bar.
 */ 
void draw_lower_status(int hp, int mp);

void draw_spell(char spell);

/**
 * Draw the border for the map.
 */
 
void draw_start();
 
void draw_border();

void draw_gameover();

void draw_win();

void draw_fire(int u, int v);

void draw_key(int u, int v);

void draw_npc(int u, int v);

void draw_npc2(int u, int v);

void draw_goblin(int u, int v);

void draw_eye(int u, int v);

void draw_store(int u, int v);

void draw_merch(int u, int v);

void draw_chest(int u , int v);

void draw_castle(int u, int v);

void draw_kindom(int u, int v);

void draw_portal(int u, int v);

void draw_door(int u, int v);

void draw_dragon(int u, int v);

void draw_portal2(int u, int v);


#endif // GRAPHICS_H