#include "graphics.h"

#include "globals.h"
#include "main_char.cpp"
#include "chest.cpp"
#include "castle.cpp"
#include "key.cpp"
#include "portal.cpp"
#include "tree.cpp"
#include "npc.cpp"
#include "door.cpp"
#include "dragon.cpp"
#include "portal2.cpp"
#include "kindom.cpp"
#include "eye.cpp"
#include "merch.cpp"
#include "goblin.cpp"
#include "store.cpp"
#include "npc2.cpp"
#include "fire.cpp"

/*
In this file put all your graphical functions (don't forget to declare them first
in graphics.h). So when you want to draw something use this file. One cool function
to look at would be uLCD.blit() there are more like filled_rectangle etc... 
https://os.mbed.com/users/4180_1/notebook/ulcd-144-g2-128-by-128-color-lcd/
This website is a good resource.
*/

void draw_player(int u, int v, int key)
{
    
    uLCD.BLIT(u,v,11,11,main_char_arr);
    //.filled_rectangle(u, v, u+11, v+11, RED);
}

#define YELLOW 0xFFFF00
#define BROWN  0xD2691E
#define BLUE   0x0000FF
#define DIRT   BROWN
void draw_img(int u, int v, const char* img)
{
    int colors[11*11];
    for (int i = 0; i < 11*11; i++)
    {
        if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'Y') colors[i] = YELLOW;
        else if (img[i] == 'G') colors[i] = GREEN;
        else if (img[i] == 'D') colors[i] = DIRT;
        else if (img[i] == '5') colors[i] = LGREY;
        else if (img[i] == '3') colors[i] = DGREY;
        else colors[i] = BLACK;
    }
    uLCD.BLIT(u, v, 11, 11, colors);
    wait_us(250); // Recovery time!
}


void draw_gameover(){
    uLCD.filled_rectangle(0,0,127,127, BLACK);
    uLCD.set_font(FONT_8X8);
    uLCD.text_mode(OPAQUE);
    uLCD.locate(5,6);
    uLCD.printf("GAME OVER");
}

void draw_win(){
    uLCD.filled_rectangle(0,0,127,127, BLACK);
    uLCD.set_font(FONT_8X8);
    uLCD.text_mode(OPAQUE);
    uLCD.color(BLUE);
    uLCD.locate(5,6);
    uLCD.printf("YOU WIN");
}


void draw_nothing(int u, int v)
{
    // Fill a tile with blackness
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
}

void draw_wall(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, BROWN);
}

void draw_plant(int u, int v)
{
    uLCD.BLIT(u,v,11,11,tree_arr);
}

void draw_key(int u, int v)
{
    uLCD.BLIT(u,v,11,11,key_arr);
}

void draw_fire(int u, int v)
{
    uLCD.BLIT(u,v,11,11,fire_arr);
}

void draw_npc(int u, int v)
{
    uLCD.BLIT(u,v,11,11,npc_arr);
}

void draw_npc2(int u, int v)
{
    uLCD.BLIT(u,v,11,11,npc2_arr);
}

void draw_goblin(int u, int v)
{
    uLCD.BLIT(u,v,11,11,goblin_arr);
}

void draw_eye(int u, int v)
{
    uLCD.BLIT(u,v,11,11,eye_arr);
}

void draw_store(int u, int v)
{
    uLCD.BLIT(u,v,11,11,store_arr);
}

void draw_merch(int u, int v)
{
    uLCD.BLIT(u,v,11,11,merch_arr);
}


void draw_portal(int u, int v)
{
    uLCD.BLIT(u,v,11,11,portal_arr);
}

void draw_portal2(int u, int v)
{
    uLCD.BLIT(u,v,11,11,portal2_arr);
}

void draw_castle(int u, int v)
{
    uLCD.BLIT(u,v,11,11,castle_arr);
}

void draw_kindom(int u, int v)
{
    uLCD.BLIT(u,v,11,11,kindom_arr);
}


void draw_door(int u, int v){
     uLCD.BLIT(u,v,11,11,door_arr);
}

void draw_dragon(int u, int v){
     uLCD.BLIT(u,v,11,11,dragon_arr);
}

void draw_chest(int u, int v){
     uLCD.BLIT(u,v,11,11,chest);
}


void draw_upper_status(int player_x, int player_y, int coin)
{
    uLCD.locate(0,0);
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.color(GREEN);
    uLCD.printf("X:[%2i] Y:[%2i] $:%1i",player_x,player_y,coin);
    
    // Draw bottom border of status bar
    
    // Add other status info drawing code here
}

void draw_lower_status(int hp, int mp)
{   
    // Draw top border of status bar
    uLCD.locate(0,15);
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.color(GREEN);
    uLCD.printf("HP:%3i MP:%3i",hp,mp);
    
    // Add other status info drawing code here
}

void draw_spell(char spell)
{   
    // Draw top border of status bar
    uLCD.locate(16,15);
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.color(GREEN);
    uLCD.printf("%c",spell);
    
    // Add other status info drawing code here
}

void draw_border()
{
    uLCD.filled_rectangle(0,     9, 127,  14, WHITE); // Top
    uLCD.filled_rectangle(0,    13,   2, 114, WHITE); // Left
    uLCD.filled_rectangle(0,   114, 127, 117, WHITE); // Bottom
    uLCD.filled_rectangle(124,  14, 127, 117, WHITE); // Right
}

void draw_start(){
    uLCD.text_width(2);
    uLCD.text_height(2);    
    uLCD.color(BLUE);
    uLCD.locate(1,1);
    uLCD.printf("NASLAND");
    uLCD.color(YELLOW);
    uLCD.locate(2,2);
    uLCD.printf("QUEST");
    
    uLCD.filled_rectangle(31,75,92,80,YELLOW);
    uLCD.filled_rectangle(35,70,88,75,RED);
    uLCD.filled_rectangle(38,65,85,70,YELLOW);
    uLCD.filled_rectangle(42,60,81,65,YELLOW);
    uLCD.filled_rectangle(49,55,74,60,YELLOW);
    
    
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.locate(4,12);
    uLCD.printf("Press action");
    uLCD.locate(2,13);
    uLCD.printf("button to begin");
    }
