#ifndef GRAPHICS_H
#define GRAPHICS_H

#define POSITION 2

enum InputType {HIT,NO_HIT};
enum StateType {DAMAGE,NO_DAMAGE};



//Base Class

class ScreenObjects
{
public:
    int getHealth();
    void setHealth(int);
    int * getPosition();
    void setPosition(int,int);
    int * getPrevPosition();
    void setPrevPosition(int *);
    InputType getInput();
    void setInput(InputType);
    StateType getState();
    void setState(StateType);
    virtual void draw(int,int)=0;
    void erase(int,int);
    virtual void update()=0;
    int getDirection();
    void setDirection(int);
    bool getDirPos();
    void setDirPos(bool);


private:
    int health;
    int Position[POSITION];
    int * previousPosition;
    InputType input;
    StateType state;
    
    int direction;
    bool dirPos;

};

class BobAlien:public ScreenObjects
{
public:
    BobAlien();
    void draw(int,int);
    void update();
    void attack();

private:
    bool bobBullet;
};


class AliceAlien:public ScreenObjects
{
public:
    AliceAlien();
    void draw(int,int);
   void update();
    void attack();

private:
    bool aliceBullet;

};
//Gears for the Ship
 enum GearShift {STOP,GEAR1,GEAR2,GEAR3};



class Ship:public ScreenObjects
{
    
public:
    Ship();
    void draw(int,int);
    void attackBullet();
    void update();
    void attackRocket();
    void setGear(GearShift);
    GearShift getGear();
    virtual int move(double);
    friend class Bullet;
    int * getShipPosition();
    void setShipPos(int *);
    

private:
    int numBullets;
    int numRockets;
    GearShift gear;
    int * shipPos;
    
    
    
};



class Bullet:public Ship
{
    
public:
    Bullet();
    void draw(int,int);
    void update();
    //void launch();
    bool getLoaded();
    
    private:
    bool load;
    bool trueDraw;
    
};



class Rocket:public ScreenObjects
{
    
public:
    Rocket();
    void draw(int,int);
    void update();
    void drawExplosion();
    void launch();
   
    
};


#endif//End of Graphics h