#include "graphics.h"
#include "global.h"

#define STOP_D 0
#define GO_RIGHT 1
#define GO_LEFT 2

#define GEAR_1 .3

//The characters for LAME
#include "Sprites/bullet.cpp"
#include "Sprites/BobUp.cpp"
#include "Sprites/ship.cpp"
#include "Sprites/BobDown.cpp"
#include "Sprites/Alice.cpp"
#include "Sprites/rocket.cpp"




//constructors
AliceAlien::AliceAlien()
{
    setInput(NO_HIT);
    setState(NO_DAMAGE);

}

BobAlien::BobAlien()
{
    setInput(NO_HIT);
    setState(NO_DAMAGE);
     setDirPos(true);
    

}

Ship::Ship()
{
    setInput(NO_HIT);
    setState(NO_DAMAGE);
    setGear(STOP);

}

Rocket::Rocket()
{
    setInput(NO_HIT);
    //loadedRocket = false;
}

Bullet::Bullet()
{
    setInput(NO_HIT);
    //loadedBullet = false;
}

//Draw Functions
void BobAlien::draw(int u,int v)
{
    //Use get state here to make bob draw the differnt types
    uLCD.BLIT(u,v,11,11,BobUp);
}

void AliceAlien::draw(int u,int v)
{
    //Use get state here to make bob draw the differnt types
    uLCD.BLIT(u,v,11,11,Alice);
}

void Ship::draw(int u,int v)
{
    //Use get state here to make bob draw the differnt types
    uLCD.BLIT(u,v,11,11,ship);
}

void Bullet::draw(int u,int v)
{
    //Use get state here to make bob draw the differnt types
    uLCD.BLIT(u,v,11,11,bullet);
}

void Rocket::draw(int u,int v)
{
    //Use get state here to make bob draw the differnt types
    uLCD.BLIT(u,v,11,11,rocket);
}

//Screen Object Base functions

void ScreenObjects::setState(StateType currState)
{
    state = currState;
}

void ScreenObjects::setInput(InputType Input)
{
    input = Input;
}

int ScreenObjects::getHealth()
{
    return health;
}

void ScreenObjects::setHealth(int HP)
{
    health = HP;
}

int * ScreenObjects::getPosition()
{
    int * positionPointer = NULL;
    positionPointer = Position;
    return positionPointer;
}

int * ScreenObjects::getPrevPosition()
{
    return previousPosition;
}

void ScreenObjects::setPosition(int posx,int posy)
{
    Position[0] = posx;
    Position[1] = posy;
}

void ScreenObjects::setPrevPosition(int * newPos)
{
    previousPosition = newPos;
}

void ScreenObjects::erase(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
}


int ScreenObjects::getDirection()
{

    return direction;

}

void ScreenObjects::setDirection(int num)
{

    direction = num;

}

bool ScreenObjects::getDirPos()
{

    return dirPos;

}

void ScreenObjects::setDirPos(bool val)
{

    dirPos = val;

}

//Bullet Class Functions


bool Bullet::getLoaded()
{
    load = loadedBullet;
    return load;
}

void Bullet::update()
{
    setPrevPosition(getPosition());

    if(getLoaded()) {
        setPosition(getShipPosition()[0],getShipPosition()[1]-1);
    }

}



//Rocket Class Functions

//

//Ship Class Functions

void Ship::setGear(GearShift Gears)
{
    gear = Gears;
}

GearShift Ship::getGear()
{
    return gear;
}


int Ship::move(double tiltDirection)
{
    if (tiltDirection>GEAR_1) {
        setGear(GEAR1);
        return GO_RIGHT;
    }
    if (tiltDirection<-1*GEAR_1) {
        setGear(GEAR1);
        return GO_LEFT;
    }

    else {
        setGear(STOP);
        return STOP_D;
    }
}


int * Ship::getShipPosition()
{
    return shipPos;
}

void Ship::setShipPos(int * val)
{
    shipPos = val;
}


void Ship::update()
{
    setPrevPosition(getPosition());

    //Stop
    if(getGear() == STOP || getPosition()[0] <=11 || getPosition()[0] > 117) {
        setPosition((getPosition()[0]),getPosition()[1]);
        setShipPos(getPosition());
    }

    //Gear1
    if(getGear() == GEAR1 && getPosition()[0] <= 117) {
        erase(getPosition()[0],getPosition()[1]);//move
        if(getDirection() == GO_LEFT) {
            setPosition((getPosition()[0]-2),getPosition()[1]);
           setShipPos(getPosition());
        }
        if(getDirection() == GO_RIGHT) {
            setPosition((getPosition()[0]+2),getPosition()[1]);
            setShipPos(getPosition());
        }
    }

}

//Bob ALien Class Functions
void BobAlien::update()
{
    setPrevPosition(getPosition());
    erase(getPosition()[0],getPosition()[1]);//move
    
    if(getPosition()[0] < 117 && getDirPos() )
        {
         setDirection(GO_RIGHT);   
        }
    
    if(getPosition()[0] > 117)
    {
        setDirPos(false);
        setDirection(STOP_D);
    }
    
    if(getDirection() == STOP_D)
    {
     setPosition((getPosition()[0]),getPosition()[1]+5); 
     setDirection(GO_LEFT);  
    }
    
    if(getPosition()[0] <= 10 && getDirPos() == false)
    {
        setDirPos(true);
    }
    
   
    
    if(getDirection() == GO_LEFT && getDirPos() == false) {
        setPosition((getPosition()[0]-1),getPosition()[1]);    
    }
    if(getDirection() == GO_RIGHT) {
        setPosition((getPosition()[0]+1),getPosition()[1]);
    }
    
}


//Alice Alien Class Functions
void AliceAlien::update()
{
    setPrevPosition(getPosition());
    erase(getPosition()[0],getPosition()[1]);//move
    
    if(getPosition()[0] < 117 && getDirPos() )
        {
         setDirection(GO_RIGHT);   
        }
    
    if(getPosition()[0] > 117)
    {
        setDirPos(false);
        setDirection(STOP_D);
    }
    
    if(getDirection() == STOP_D)
    {
     setPosition((getPosition()[0]),getPosition()[1]+5); 
     setDirection(GO_LEFT);  
    }
    
    if(getPosition()[0] <= 10 && getDirPos() == false)
    {
        setDirPos(true);
    }
    
   
    
    if(getDirection() == GO_LEFT && getDirPos() == false) {
        setPosition((getPosition()[0]-1),getPosition()[1]);    
    }
    if(getDirection() == GO_RIGHT) {
        setPosition((getPosition()[0]+1),getPosition()[1]);
    }
}

//Rocket Class Functions
void Rocket::update()
{
    setPrevPosition(getPosition());

}