#ifndef GLOBAL_H
#define GLOBAL_H

// Include all the hardware libraries
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "MMA8452.h"
#include <ctime>
#include <cstdlib>

// Declare the hardware interface objects
/*
This file holds all the global variables that are accessable from all the
different files in this project. You see below most of it looks like hardware.
That's because it is hardware! The uLCD object is how you interact with the LCD
screen. The sd variable is how you interact with the sd card and so on for all
the other variables.*/
extern uLCD_4DGL uLCD;      // LCD Screen
//extern SDFileSystem sd;     // SD Card
extern PinDetect buttonA;   // Pushbuttons
extern PinDetect buttonB;
extern PinDetect buttonC;
extern MMA8452   acc;

//bullet launch
extern bool loadedBullet;
extern bool loadedRocket;

#endif